/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.issue.search;

import com.atlassian.jira.bc.issue.search.QueryCache;
import com.atlassian.jira.jql.ClauseHandler;
import com.atlassian.jira.jql.context.QueryContext;
import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.jql.query.QueryCreationContext;
import com.atlassian.jira.security.JiraAuthenticationContextImpl;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.query.Query;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.operand.Operand;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class QueryCacheImpl
implements QueryCache {
    @Override
    public Boolean getDoesQueryFitFilterFormCache(ApplicationUser searcher, Query query) {
        return this.getFitCache().get(new QueryCacheKey(searcher, query));
    }

    @Override
    public void setDoesQueryFitFilterFormCache(ApplicationUser searcher, Query query, boolean doesItFit) {
        this.getFitCache().put(new QueryCacheKey(searcher, query), doesItFit);
    }

    @Override
    public QueryContext getQueryContextCache(ApplicationUser searcher, Query query) {
        return this.getQueryCache().get(new QueryCacheKey(searcher, query));
    }

    @Override
    public void setQueryContextCache(ApplicationUser searcher, Query query, QueryContext queryContext) {
        this.getQueryCache().put(new QueryCacheKey(searcher, query), queryContext);
    }

    @Override
    public QueryContext getSimpleQueryContextCache(ApplicationUser searcher, Query query) {
        return this.getExplicitQueryCache().get(new QueryCacheKey(searcher, query));
    }

    @Override
    public void setSimpleQueryContextCache(ApplicationUser searcher, Query query, QueryContext queryContext) {
        this.getExplicitQueryCache().put(new QueryCacheKey(searcher, query), queryContext);
    }

    @Override
    public Collection<ClauseHandler> getClauseHandlers(ApplicationUser searcher, String jqlClauseName) {
        return this.getClauseHandlerCache().get(new QueryCacheClauseHandlerKey(searcher, jqlClauseName));
    }

    @Override
    public void setClauseHandlers(ApplicationUser searcher, String jqlClauseName, Collection<ClauseHandler> clauseHandlers) {
        this.getClauseHandlerCache().put(new QueryCacheClauseHandlerKey(searcher, jqlClauseName), clauseHandlers);
    }

    @Override
    public List<QueryLiteral> getValues(QueryCreationContext context, Operand operand, TerminalClause jqlClause) {
        return this.getValueCache().get(new QueryCacheLiteralsKey(context, operand, jqlClause));
    }

    @Override
    public void setValues(QueryCreationContext context, Operand operand, TerminalClause jqlClause, List<QueryLiteral> values) {
        this.getValueCache().put(new QueryCacheLiteralsKey(context, operand, jqlClause), values);
    }

    Map<QueryCacheKey, QueryContext> getExplicitQueryCache() {
        return QueryCacheImpl.getCache("jira.simple.query.context.cache");
    }

    Map<QueryCacheKey, QueryContext> getQueryCache() {
        return QueryCacheImpl.getCache("jira.query.context.cache");
    }

    Map<QueryCacheKey, Boolean> getFitCache() {
        return QueryCacheImpl.getCache("jira.query.does.it.fit.navigator.cache");
    }

    Map<QueryCacheClauseHandlerKey, Collection<ClauseHandler>> getClauseHandlerCache() {
        return QueryCacheImpl.getCache("jira.jql.clause.handler.cache");
    }

    Map<QueryCacheLiteralsKey, List<QueryLiteral>> getValueCache() {
        return QueryCacheImpl.getCache("jira.jql.query.literals.cache");
    }

    static <K, V> Map<K, V> getCache(String key) {
        Map<String, Object> requestCache = JiraAuthenticationContextImpl.getRequestCache();
        HashMap result = (HashMap)requestCache.get(key);
        if (result == null) {
            result = new HashMap();
            requestCache.put(key, result);
        }
        return result;
    }

    static class QueryCacheLiteralsKey {
        private final QueryCreationContext context;
        private final Operand operand;
        private final TerminalClause jqlClause;

        public QueryCacheLiteralsKey(QueryCreationContext context, Operand operand, TerminalClause jqlClause) {
            this.context = (QueryCreationContext)Assertions.notNull((String)"context", (Object)context);
            this.operand = (Operand)Assertions.notNull((String)"operand", (Object)operand);
            this.jqlClause = (TerminalClause)Assertions.notNull((String)"jqlClause", (Object)jqlClause);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            QueryCacheLiteralsKey that = (QueryCacheLiteralsKey)o;
            if (!this.jqlClause.equals(that.jqlClause)) {
                return false;
            }
            if (!this.operand.equals(that.operand)) {
                return false;
            }
            return this.context.equals(that.context);
        }

        public int hashCode() {
            int result = this.context.hashCode();
            result = 11 * result + this.operand.hashCode();
            result = 31 * result + this.jqlClause.hashCode();
            return result;
        }
    }

    static class QueryCacheClauseHandlerKey {
        private final ApplicationUser searcher;
        private final String jqlClauseName;

        public QueryCacheClauseHandlerKey(ApplicationUser searcher, String jqlClauseName) {
            this.searcher = searcher;
            this.jqlClauseName = (String)Assertions.notNull((String)"jqlClauseName", (Object)jqlClauseName);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            QueryCacheClauseHandlerKey that = (QueryCacheClauseHandlerKey)o;
            if (!this.jqlClauseName.equals(that.jqlClauseName)) {
                return false;
            }
            return !(this.searcher != null ? !this.searcher.equals((Object)that.searcher) : that.searcher != null);
        }

        public int hashCode() {
            int result = this.searcher != null ? this.searcher.hashCode() : 0;
            result = 31 * result + this.jqlClauseName.hashCode();
            return result;
        }
    }

    static class QueryCacheKey {
        private final ApplicationUser searcher;
        private final Query query;

        public QueryCacheKey(ApplicationUser searcher, Query query) {
            this.searcher = searcher;
            this.query = (Query)Assertions.notNull((String)"query", (Object)query);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            QueryCacheKey that = (QueryCacheKey)o;
            if (!this.query.equals(that.query)) {
                return false;
            }
            return !(this.searcher != null ? !this.searcher.equals((Object)that.searcher) : that.searcher != null);
        }

        public int hashCode() {
            int result = this.searcher != null ? this.searcher.hashCode() : 0;
            result = 31 * result + this.query.hashCode();
            return result;
        }
    }
}

