/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.issue.properties;

import com.atlassian.fugue.Function2;
import com.atlassian.fugue.Option;
import com.atlassian.jira.entity.property.EntityProperty;
import com.atlassian.jira.entity.property.EntityPropertyHelper;
import com.atlassian.jira.entity.property.EntityPropertyType;
import com.atlassian.jira.entity.property.EntityWithKeyPropertyHelper;
import com.atlassian.jira.event.issue.property.IssuePropertyDeletedEvent;
import com.atlassian.jira.event.issue.property.IssuePropertySetEvent;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.google.common.base.Function;

public class IssuePropertyHelper
implements EntityWithKeyPropertyHelper<Issue> {
    private final DeletePropertyEventFunction deletePropertyEventFunction;
    private final I18nHelper i18n;
    private final IssueByIdFunction issueByIdFunction;
    private final IssueByKeyFunction issueByKeyFunction;
    private final IssueManager issueManager;
    private final HasEditPermissionFunction editPermissionFunction;
    private final PermissionManager permissionManager;
    private final HasViewPermissionFunction viewPermissionFunction;
    private final SetPropertyEventFunction setPropertyEventFunction;

    public IssuePropertyHelper(I18nHelper i18n, IssueManager issueManager, PermissionManager permissionManager) {
        this.i18n = i18n;
        this.issueManager = issueManager;
        this.permissionManager = permissionManager;
        this.deletePropertyEventFunction = new DeletePropertyEventFunction();
        this.issueByIdFunction = new IssueByIdFunction();
        this.issueByKeyFunction = new IssueByKeyFunction();
        this.editPermissionFunction = new HasEditPermissionFunction();
        this.viewPermissionFunction = new HasViewPermissionFunction();
        this.setPropertyEventFunction = new SetPropertyEventFunction();
    }

    public Function<String, Option<Issue>> getEntityByKeyFunction() {
        return this.issueByKeyFunction;
    }

    public EntityPropertyHelper.CheckPermissionFunction<Issue> hasEditPermissionFunction() {
        return this.editPermissionFunction;
    }

    public EntityPropertyHelper.CheckPermissionFunction<Issue> hasReadPermissionFunction() {
        return this.viewPermissionFunction;
    }

    public Function<Long, Option<Issue>> getEntityByIdFunction() {
        return this.issueByIdFunction;
    }

    public Function2<ApplicationUser, EntityProperty, IssuePropertySetEvent> createSetPropertyEventFunction() {
        return this.setPropertyEventFunction;
    }

    public Function2<ApplicationUser, EntityProperty, IssuePropertyDeletedEvent> createDeletePropertyEventFunction() {
        return this.deletePropertyEventFunction;
    }

    public EntityPropertyType getEntityPropertyType() {
        return EntityPropertyType.ISSUE_PROPERTY;
    }

    private ErrorCollection checkIssuePermission(ApplicationUser user, Issue issue, IssueAction issueAction) {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        if (!this.permissionManager.hasPermission(issueAction.getPermissionId(), issue, user)) {
            ErrorCollection.Reason reason = user == null ? ErrorCollection.Reason.NOT_LOGGED_IN : ErrorCollection.Reason.FORBIDDEN;
            errorCollection.addErrorMessage(this.i18n.getText(issueAction.getErrorMessage()), reason);
        }
        return errorCollection;
    }

    private static enum IssueAction {
        BROWSE(10, "admin.errors.issues.no.browse.permission"),
        EDIT(12, "editissue.error.no.edit.permission");

        private final int permissionId;
        private final String errorMessage;

        private IssueAction(int permissionId, String errorMessage) {
            this.permissionId = permissionId;
            this.errorMessage = errorMessage;
        }

        int getPermissionId() {
            return this.permissionId;
        }

        String getErrorMessage() {
            return this.errorMessage;
        }
    }

    private class SetPropertyEventFunction
    implements Function2<ApplicationUser, EntityProperty, IssuePropertySetEvent> {
        private SetPropertyEventFunction() {
        }

        public IssuePropertySetEvent apply(ApplicationUser user, EntityProperty entityProperty) {
            return new IssuePropertySetEvent(entityProperty, user);
        }
    }

    private class HasViewPermissionFunction
    implements EntityPropertyHelper.CheckPermissionFunction<Issue> {
        private HasViewPermissionFunction() {
        }

        public ErrorCollection apply(ApplicationUser user, Issue issue) {
            return IssuePropertyHelper.this.checkIssuePermission(user, issue, IssueAction.BROWSE);
        }
    }

    private class HasEditPermissionFunction
    implements EntityPropertyHelper.CheckPermissionFunction<Issue> {
        private HasEditPermissionFunction() {
        }

        public ErrorCollection apply(ApplicationUser user, Issue issue) {
            return IssuePropertyHelper.this.checkIssuePermission(user, issue, IssueAction.EDIT);
        }
    }

    private class IssueByIdFunction
    implements Function<Long, Option<Issue>> {
        private IssueByIdFunction() {
        }

        public Option<Issue> apply(Long issueId) {
            return Option.option((Object)IssuePropertyHelper.this.issueManager.getIssueObject(issueId));
        }
    }

    private class IssueByKeyFunction
    implements Function<String, Option<Issue>> {
        private IssueByKeyFunction() {
        }

        public Option<Issue> apply(String issueKey) {
            return Option.option((Object)IssuePropertyHelper.this.issueManager.getIssueObject(issueKey));
        }
    }

    private class DeletePropertyEventFunction
    implements Function2<ApplicationUser, EntityProperty, IssuePropertyDeletedEvent> {
        private DeletePropertyEventFunction() {
        }

        public IssuePropertyDeletedEvent apply(ApplicationUser user, EntityProperty entityProperty) {
            return new IssuePropertyDeletedEvent(entityProperty, user);
        }
    }
}

