/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.imports.project;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.imports.project.ProjectImportService;
import com.atlassian.jira.bc.project.component.ProjectComponentManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.config.util.AttachmentPathManager;
import com.atlassian.jira.event.project.ProjectImportedEvent;
import com.atlassian.jira.imports.project.ProjectImportManager;
import com.atlassian.jira.imports.project.core.BackupOverview;
import com.atlassian.jira.imports.project.core.BackupProject;
import com.atlassian.jira.imports.project.core.BackupSystemInformation;
import com.atlassian.jira.imports.project.core.MappingResult;
import com.atlassian.jira.imports.project.core.ProjectImportData;
import com.atlassian.jira.imports.project.core.ProjectImportOptions;
import com.atlassian.jira.imports.project.core.ProjectImportResults;
import com.atlassian.jira.imports.project.core.ProjectImportResultsImpl;
import com.atlassian.jira.imports.project.core.ValidationMessage;
import com.atlassian.jira.imports.project.customfield.ExternalCustomFieldConfiguration;
import com.atlassian.jira.imports.project.handler.AbortImportException;
import com.atlassian.jira.imports.project.mapper.CustomFieldMapper;
import com.atlassian.jira.imports.project.taskprogress.EntityCountTaskProgressProcessor;
import com.atlassian.jira.imports.project.taskprogress.TaskProgressInterval;
import com.atlassian.jira.issue.AttachmentManager;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.index.IndexException;
import com.atlassian.jira.plugin.PluginVersion;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.project.version.VersionManager;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.task.TaskProgressSink;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.BuildUtilsInfo;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.MessageSet;
import com.atlassian.jira.util.MessageSetImpl;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.util.dbc.Null;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class DefaultProjectImportService
implements ProjectImportService {
    private static final Logger LOG = LoggerFactory.getLogger((String)"com.atlassian.jira.imports.project.DefaultProjectImportService");
    private final PermissionManager permissionManager;
    private final ProjectImportManager projectImportManager;
    private final ProjectManager projectManager;
    private final UserManager userManager;
    private final IssueManager issueManager;
    private final VersionManager versionManager;
    private final ProjectComponentManager projectComponentManager;
    private final PluginAccessor pluginAccessor;
    private final ApplicationProperties applicationProperties;
    private final AttachmentManager attachmentManager;
    private final AttachmentPathManager attachmentPathManager;
    private final BuildUtilsInfo buildUtilsInfo;
    private final EventPublisher eventPublisher;

    public DefaultProjectImportService(PermissionManager permissionManager, ProjectImportManager projectImportManager, ProjectManager projectManager, UserManager userManager, IssueManager issueManager, VersionManager versionManager, ProjectComponentManager projectComponentManager, PluginAccessor pluginAccessor, ApplicationProperties applicationProperties, AttachmentManager attachmentManager, AttachmentPathManager attachmentPathManager, BuildUtilsInfo buildUtilsInfo, EventPublisher eventPublisher) {
        this.permissionManager = permissionManager;
        this.projectImportManager = projectImportManager;
        this.projectManager = projectManager;
        this.userManager = userManager;
        this.issueManager = issueManager;
        this.versionManager = versionManager;
        this.projectComponentManager = projectComponentManager;
        this.pluginAccessor = pluginAccessor;
        this.applicationProperties = applicationProperties;
        this.attachmentManager = attachmentManager;
        this.attachmentPathManager = attachmentPathManager;
        this.eventPublisher = eventPublisher;
        this.buildUtilsInfo = (BuildUtilsInfo)Assertions.notNull((String)"buildUtilsInfo", (Object)buildUtilsInfo);
    }

    @Override
    public void validateGetBackupOverview(JiraServiceContext jiraServiceContext, ProjectImportOptions projectImportOptions) {
        Null.not("projectImportOptions", projectImportOptions);
        this.validateJiraServiceContext(jiraServiceContext);
        ErrorCollection errorCollection = jiraServiceContext.getErrorCollection();
        I18nHelper i18n = jiraServiceContext.getI18nBean();
        if (!this.userHasSysAdminPermission(jiraServiceContext.getLoggedInUser())) {
            errorCollection.addErrorMessage(this.getText(i18n, "admin.errors.project.import.must.be.admin"));
            return;
        }
        if (StringUtils.isEmpty((String)projectImportOptions.getPathToBackup())) {
            errorCollection.addError("backupPath", this.getText(i18n, "admin.errors.project.import.provide.backup.path"));
        } else if (!this.pathExists(projectImportOptions.getPathToBackup(), true)) {
            errorCollection.addError("backupPath", this.getText(i18n, "admin.errors.project.import.invalid.backup.path"));
        } else if (!this.validIndexZipFile(projectImportOptions.getPathToBackup())) {
            errorCollection.addError("backupPath", this.getText(i18n, "admin.errors.project.import.invalid.backup.file.format", projectImportOptions.getPathToBackup()));
        }
        if (!StringUtils.isEmpty((String)projectImportOptions.getAttachmentPath())) {
            if (!this.attachmentManager.attachmentsEnabled()) {
                errorCollection.addError("backupAttachmentPath", this.getText(i18n, "admin.errors.project.import.attachments.not.enabled"));
            } else if (this.pathExists(projectImportOptions.getAttachmentPath(), false)) {
                String attachmentPathString = this.attachmentPathManager.getAttachmentPath();
                File attachmentPathFile = new File(attachmentPathString);
                File backupAttachmentPathFile = new File(projectImportOptions.getAttachmentPath());
                try {
                    if (attachmentPathFile.getCanonicalPath().equals(backupAttachmentPathFile.getCanonicalPath())) {
                        errorCollection.addError("backupAttachmentPath", this.getText(i18n, "admin.errors.project.import.attachment.backup.path.same.as.system"));
                    }
                }
                catch (IOException e) {
                    errorCollection.addErrorMessage(this.getText(i18n, "admin.errors.project.import.attachment.ioexception", e.getMessage()));
                }
            } else {
                errorCollection.addError("backupAttachmentPath", this.getText(i18n, "admin.errors.project.import.invalid.attachment.backup.path"));
            }
        }
    }

    @Override
    @Nullable
    public BackupOverview getBackupOverview(JiraServiceContext jiraServiceContext, ProjectImportOptions projectImportOptions, TaskProgressSink taskProgressSink) {
        Null.not("projectImportOptions", projectImportOptions);
        this.validateJiraServiceContext(jiraServiceContext);
        ErrorCollection errorCollection = jiraServiceContext.getErrorCollection();
        I18nHelper i18n = jiraServiceContext.getI18nBean();
        if (!this.userHasSysAdminPermission(jiraServiceContext.getLoggedInUser())) {
            errorCollection.addErrorMessage(this.getText(i18n, "admin.errors.project.import.must.be.admin"));
            return null;
        }
        try {
            String backupPath = projectImportOptions.getPathToBackup();
            LOG.info("Project Import: Parsing the backup file '" + backupPath + "' to obtain a Backup Overview.");
            BackupOverview backupOverview = this.projectImportManager.getBackupOverview(backupPath, taskProgressSink, i18n);
            LOG.debug("Project count for backup file = " + backupOverview.getProjects().size());
            LOG.debug("Entity count for backup file = " + backupOverview.getBackupSystemInformation().getEntityCount());
            if (!this.getBuildNumber().equalsIgnoreCase(backupOverview.getBackupSystemInformation().getBuildNumber())) {
                String errorMessage = this.getText(i18n, "admin.errors.project.import.wrong.build.number", this.getBuildNumber(), backupOverview.getBackupSystemInformation().getBuildNumber());
                errorCollection.addErrorMessage(errorMessage);
                LOG.error("This data appears to be from an older version of JIRA. Please upgrade the data and try again. The current version of JIRA is at build number '" + this.getBuildNumber() + "', but the supplied backup file was for build number '" + backupOverview.getBackupSystemInformation().getBuildNumber() + "'.");
            }
            if (!errorCollection.hasAnyErrors()) {
                LOG.info("Project Import: Backup Overview was successfully extracted from '" + backupPath + "'.");
                return backupOverview;
            }
        }
        catch (IOException e) {
            LOG.error("There was a problem accessing the file '" + projectImportOptions.getPathToBackup() + "' when performing a project import.", (Throwable)e);
            errorCollection.addErrorMessage(this.getText(i18n, "admin.errors.project.import.problem.reading.backup", projectImportOptions.getPathToBackup()));
        }
        catch (SAXException e) {
            LOG.error("There was a problem with the SAX parsing of the file '" + projectImportOptions.getPathToBackup() + "' when performing a project import.", (Throwable)e);
            errorCollection.addErrorMessage(this.getText(i18n, "admin.errors.project.import.sax.problem", projectImportOptions.getPathToBackup(), e.getMessage()));
        }
        catch (Exception e) {
            LOG.error("There was a unexpected problem processing the backup XML file at " + projectImportOptions.getPathToBackup(), (Throwable)e);
            errorCollection.addErrorMessage(this.getText(i18n, "admin.errors.project.import.unexpected.problem", projectImportOptions.getPathToBackup(), e.getMessage()));
        }
        return null;
    }

    @Override
    public MessageSet validateBackupProjectImportableSystemLevel(JiraServiceContext jiraServiceContext, BackupProject backupProject, BackupSystemInformation backupSystemInformation) {
        this.validateJiraServiceContext(jiraServiceContext);
        Null.not("backupSystemInformation", backupSystemInformation);
        MessageSetImpl messageSet = new MessageSetImpl();
        I18nHelper i18n = jiraServiceContext.getI18nBean();
        if (backupProject == null) {
            messageSet.addErrorMessage(this.getText(i18n, "admin.error.project.import.null.project"));
            jiraServiceContext.getErrorCollection().addErrorMessage(this.getText(i18n, "admin.error.project.import.null.project"));
            return messageSet;
        }
        if (!this.userHasSysAdminPermission(jiraServiceContext.getLoggedInUser())) {
            messageSet.addErrorMessage(this.getText(i18n, "admin.errors.project.import.must.be.admin"));
        } else {
            this.validateCustomFieldPluginVersions(backupProject, backupSystemInformation.getPluginVersions(), (MessageSet)messageSet, i18n);
            String projectKey = backupProject.getProject().getKey();
            Project existingProject = this.projectManager.getProjectObjByKey(projectKey);
            if (existingProject == null) {
                if (!messageSet.hasAnyErrors()) {
                    messageSet.addWarningMessage(this.getText(i18n, "admin.warning.project.import.no.existing.project", projectKey));
                }
            } else if (!projectKey.equals(existingProject.getKey())) {
                messageSet.addErrorMessage(this.getText(i18n, "admin.error.project.import.historical.key", existingProject.getName(), projectKey));
            } else {
                this.validateExistingProjectHasValidStateForImport(backupProject, backupSystemInformation, existingProject, i18n, (MessageSet)messageSet);
            }
        }
        jiraServiceContext.getErrorCollection().addErrorMessages((Collection)messageSet.getErrorMessages());
        return messageSet;
    }

    @Override
    public void validateDoMapping(JiraServiceContext jiraServiceContext, ProjectImportOptions projectImportOptions, BackupProject backupProject, BackupSystemInformation backupSystemInformation) {
        Null.not("projectImportOptions", projectImportOptions);
        Null.not("backupSystemInformation", backupSystemInformation);
        this.validateJiraServiceContext(jiraServiceContext);
        ErrorCollection errorCollection = jiraServiceContext.getErrorCollection();
        I18nHelper i18n = jiraServiceContext.getI18nBean();
        if (!this.userHasSysAdminPermission(jiraServiceContext.getLoggedInUser())) {
            errorCollection.addErrorMessage(this.getText(i18n, "admin.errors.project.import.must.be.admin"));
        }
        if (StringUtils.isEmpty((String)projectImportOptions.getPathToBackup())) {
            errorCollection.addErrorMessage(this.getText(i18n, "admin.errors.project.import.provide.backup.path"));
        } else if (!this.pathExists(projectImportOptions.getPathToBackup(), true)) {
            errorCollection.addErrorMessage(this.getText(i18n, "admin.errors.project.import.invalid.backup.path"));
        }
        if (backupProject == null) {
            errorCollection.addErrorMessage(this.getText(i18n, "admin.errors.project.import.no.backup.project"));
        }
    }

    @Override
    public MappingResult doMapping(JiraServiceContext jiraServiceContext, ProjectImportOptions projectImportOptions, ProjectImportData projectImportData, BackupProject backupProject, BackupSystemInformation backupSystemInformation, TaskProgressInterval taskProgressInterval) {
        Null.not("backupProject", backupProject);
        Null.not("projectImportOptions", projectImportOptions);
        Null.not("backupSystemInformation", backupSystemInformation);
        Null.not("projectImportData", projectImportData);
        this.validateJiraServiceContext(jiraServiceContext);
        if (!this.userHasSysAdminPermission(jiraServiceContext.getLoggedInUser())) {
            jiraServiceContext.getErrorCollection().addErrorMessage(this.getText(jiraServiceContext.getI18nBean(), "admin.errors.project.import.must.be.admin"));
            return null;
        }
        MappingResult mappingResult = this.validateAndAutoMapFields(jiraServiceContext, projectImportOptions, projectImportData, backupProject, backupSystemInformation, taskProgressInterval);
        if (mappingResult != null && !mappingResult.canImport()) {
            jiraServiceContext.getErrorCollection().addErrorMessage(jiraServiceContext.getI18nBean().getText("admin.errors.project.import.mapping.error"));
        }
        this.writeLogMessages(mappingResult);
        return mappingResult;
    }

    @Override
    public MessageSet preProcessAoImportData(JiraServiceContext jiraServiceContext, ProjectImportOptions projectImportOptions, BackupProject backupProject, BackupSystemInformation backupSystemInformation, TaskProgressInterval taskProgressInterval) {
        throw new UnsupportedOperationException("Not implemented");
    }

    private void writeLogMessages(MappingResult mappingResult) {
        if (mappingResult == null) {
            return;
        }
        for (ValidationMessage validationMessage : mappingResult.getSystemFieldsMessageList()) {
            this.writeLogMessages(validationMessage.getMessageSet());
        }
        for (ValidationMessage validationMessage : mappingResult.getCustomFieldsMessageList()) {
            this.writeLogMessages(validationMessage.getMessageSet());
        }
    }

    private void writeLogMessages(MessageSet messageSet) {
        if (messageSet == null) {
            return;
        }
        for (String s1 : messageSet.getErrorMessagesInEnglish()) {
            LOG.error(s1);
        }
        for (String s : messageSet.getWarningMessagesInEnglish()) {
            LOG.warn(s);
        }
    }

    @Override
    public ProjectImportResults doImport(JiraServiceContext jiraServiceContext, ProjectImportOptions projectImportOptions, BackupProject backupProject, BackupSystemInformation backupSystemInformation, ProjectImportData projectImportData, TaskProgressInterval taskProgressInterval) {
        Null.not("projectImportOptions", projectImportOptions);
        Null.not("backupSystemInformation", backupSystemInformation);
        Null.not("projectImportData", projectImportData);
        Null.not("backupProject", backupProject);
        this.validateJiraServiceContext(jiraServiceContext);
        ErrorCollection errorCollection = jiraServiceContext.getErrorCollection();
        I18nHelper i18n = jiraServiceContext.getI18nBean();
        int usersToCreate = this.isExternalUserManagementEnabled() ? 0 : projectImportData.getProjectImportMapper().getUserMapper().getUsersToAutoCreate().size();
        ProjectImportResults projectImportResults = this.getInitialImportResults(projectImportData, i18n, usersToCreate);
        if (!this.userHasSysAdminPermission(jiraServiceContext.getLoggedInUser())) {
            errorCollection.addErrorMessage(this.getText(i18n, "admin.errors.project.import.must.be.admin"));
            return projectImportResults;
        }
        try {
            TaskProgressInterval subInterval;
            LOG.info("Starting project import for project '" + backupProject.getProject().getKey() + "'.");
            if (this.isExternalUserManagementEnabled()) {
                LOG.info("User directories are all read-only. No users will be imported.");
            } else {
                LOG.info("Creating missing users. Attempting to create " + projectImportResults.getExpectedUsersCreatedCount() + " users.");
                subInterval = this.getSubInterval(taskProgressInterval, 0, 10);
                this.projectImportManager.createMissingUsers(projectImportData.getProjectImportMapper().getUserMapper(), projectImportResults, subInterval);
                LOG.info("Finished creating missing users. " + projectImportResults.getUsersCreatedCount() + " users created.");
            }
            try {
                subInterval = this.getSubInterval(taskProgressInterval, 10, 20);
                this.projectImportManager.importProject(projectImportOptions, projectImportData.getProjectImportMapper(), backupProject, projectImportResults, subInterval);
            }
            catch (AbortImportException e) {
                errorCollection.addErrorMessage(i18n.getText("admin.error.project.import.project.update.error"));
                throw e;
            }
            try {
                subInterval = this.getSubInterval(taskProgressInterval, 20, 100);
                this.projectImportManager.doImport(projectImportOptions, projectImportData, backupProject, backupSystemInformation, projectImportResults, subInterval, i18n, jiraServiceContext.getLoggedInUser());
                projectImportResults.setImportCompleted(true);
            }
            catch (IOException e) {
                LOG.error("There was a problem accessing the partitioned XML files when performing a project import.", (Throwable)e);
                errorCollection.addErrorMessage(this.getText(i18n, "admin.errors.project.import.problem.reading.partitioned.xml", e.getMessage()));
            }
            catch (AbortImportException aie) {
                LOG.error("The import was aborted because there were too many errors.");
                errorCollection.addErrorMessage(i18n.getText("admin.errors.project.import.import.error"));
            }
            catch (SAXException e) {
                LOG.error("There was a problem accessing the partitioned XML files when performing a project import.", (Throwable)e);
                errorCollection.addErrorMessage(this.getText(i18n, "admin.errors.project.import.sax.problem.partitioned.xml", e.getMessage()));
            }
            catch (IndexException e) {
                LOG.error("There was a problem reIndexing the newly imported project.", (Throwable)e);
                errorCollection.addErrorMessage(i18n.getText("admin.errors.project.import.reindex.problem", e.getMessage()));
            }
            LOG.info("Finished project import for project '" + backupProject.getProject().getKey() + "'.");
        }
        catch (AbortImportException aie) {
            LOG.error("The import was aborted because there were too many errors.");
            errorCollection.addErrorMessage(i18n.getText("admin.errors.project.import.import.error"));
        }
        catch (LinkageError | RuntimeException e) {
            LOG.error("An unexpected error occurred while importing the project with key: " + backupProject.getProject().getKey(), e);
            errorCollection.addErrorMessage(i18n.getText("admin.errors.project.import.import.error"));
            throw e;
        }
        projectImportData.getTemporaryFiles().deleteTempFiles();
        projectImportResults.setEndTime(System.currentTimeMillis());
        this.logImportResults(projectImportResults);
        this.sendAnalytics(projectImportResults);
        return projectImportResults;
    }

    private void sendAnalytics(ProjectImportResults projectImportResults) {
        this.eventPublisher.publish((Object)new ProjectImportedEvent(projectImportResults));
    }

    private void logImportResults(ProjectImportResults projectImportResults) {
        LOG.info("The project import took '" + projectImportResults.getImportDuration() + "' ms to run.");
        Project project = projectImportResults.getImportedProject();
        if (project != null) {
            LOG.info("The project import created '" + project.getProjectComponents().size() + "' project components.");
            LOG.info("The project import created '" + project.getVersions().size() + "' project versions.");
            LOG.info("The project import created '" + project.getComponents().size() + "' project components.");
            LOG.info("The project import created '" + project.getVersions().size() + "' project versions.");
        }
        LOG.info("The project import created '" + projectImportResults.getUsersCreatedCount() + "' out of '" + projectImportResults.getExpectedUsersCreatedCount() + "' users.");
        for (String projectRoleName : projectImportResults.getRoles()) {
            LOG.info("The project import created " + projectImportResults.getUsersCreatedCountForRole(projectRoleName) + " users, " + projectImportResults.getGroupsCreatedCountForRole(projectRoleName) + " groups for project role " + projectRoleName + ".");
        }
        LOG.info("The project import created '" + projectImportResults.getIssuesCreatedCount() + "' out of '" + projectImportResults.getExpectedIssuesCreatedCount() + "' issues.");
        LOG.info("The project import created '" + projectImportResults.getAttachmentsCreatedCount() + "' out of " + projectImportResults.getExpectedAttachmentsCreatedCount() + "' attachments.");
    }

    private TaskProgressInterval getSubInterval(TaskProgressInterval taskProgressInterval, int subIntervalStart, int subIntervalEnd) {
        if (taskProgressInterval == null) {
            return null;
        }
        return taskProgressInterval.getSubInterval(subIntervalStart, subIntervalEnd);
    }

    void createValidationMessageList(MappingResult mappingResult, ProjectImportData projectImportData, I18nHelper i18nHelper) {
        ArrayList<ValidationMessage> systemFieldsMessageList = new ArrayList<ValidationMessage>();
        systemFieldsMessageList.add(new ValidationMessage(i18nHelper.getText("issue.field.issuetype"), mappingResult.getIssueTypeMessageSet()));
        systemFieldsMessageList.add(new ValidationMessage(i18nHelper.getText("admin.project.import.custom.field.configuration"), mappingResult.getCustomFieldMessageSet()));
        systemFieldsMessageList.add(new ValidationMessage(i18nHelper.getText("issue.field.status"), mappingResult.getStatusMessageSet()));
        systemFieldsMessageList.add(new ValidationMessage(i18nHelper.getText("issue.field.priority"), mappingResult.getPriorityMessageSet()));
        systemFieldsMessageList.add(new ValidationMessage(i18nHelper.getText("issue.field.resolution"), mappingResult.getResolutionMessageSet()));
        systemFieldsMessageList.add(new ValidationMessage(i18nHelper.getText("admin.common.words.users"), mappingResult.getUserMessageSet()));
        systemFieldsMessageList.add(new ValidationMessage(i18nHelper.getText("admin.common.words.projectrole"), mappingResult.getProjectRoleMessageSet()));
        systemFieldsMessageList.add(new ValidationMessage(i18nHelper.getText("admin.common.words.projectrole.membership"), mappingResult.getProjectRoleActorMessageSet()));
        systemFieldsMessageList.add(new ValidationMessage(i18nHelper.getText("admin.common.words.group"), mappingResult.getGroupMessageSet()));
        systemFieldsMessageList.add(new ValidationMessage(i18nHelper.getText("common.concepts.issuelinktype"), mappingResult.getIssueLinkTypeMessageSet()));
        systemFieldsMessageList.add(new ValidationMessage(i18nHelper.getText("admin.common.words.issue.security.level"), mappingResult.getIssueSecurityLevelMessageSet()));
        systemFieldsMessageList.add(new ValidationMessage(i18nHelper.getText("common.concepts.attachments.files"), mappingResult.getFileAttachmentMessageSet()));
        mappingResult.setSystemFieldsMessageList(systemFieldsMessageList);
        ArrayList<ValidationMessage> customFieldsMessageList = new ArrayList<ValidationMessage>();
        CustomFieldMapper customFieldMapper = projectImportData.getProjectImportMapper().getCustomFieldMapper();
        for (String oldCustomFieldId : mappingResult.getCustomFieldValueMessageSets().keySet()) {
            MessageSet messageSet = mappingResult.getCustomFieldValueMessageSets().get(oldCustomFieldId);
            customFieldsMessageList.add(new ValidationMessage(customFieldMapper.getDisplayName(oldCustomFieldId), messageSet));
        }
        mappingResult.setCustomFieldsMessageList(customFieldsMessageList);
    }

    private boolean projectHasDefaultAssigneeUnassigned(BackupProject backupProject, BackupSystemInformation backupSystemInformation) {
        Long assigneeType;
        try {
            assigneeType = new Long(backupProject.getProject().getAssigneeType());
        }
        catch (NumberFormatException e) {
            assigneeType = null;
        }
        if (assigneeType == null) {
            return backupSystemInformation.unassignedIssuesAllowed();
        }
        return assigneeType == 3L;
    }

    @Override
    public ProjectImportData getProjectImportData(JiraServiceContext jiraServiceContext, ProjectImportOptions projectImportOptions, BackupProject backupProject, BackupSystemInformation backupSystemInformation, TaskProgressInterval taskProgressInterval) {
        ProjectImportData projectImportData;
        Null.not("backupProject", backupProject);
        Null.not("projectImportOptions", projectImportOptions);
        Null.not("backupSystemInformation", backupSystemInformation);
        this.validateJiraServiceContext(jiraServiceContext);
        if (!this.userHasSysAdminPermission(jiraServiceContext.getLoggedInUser())) {
            jiraServiceContext.getErrorCollection().addErrorMessage(this.getText(jiraServiceContext.getI18nBean(), "admin.errors.project.import.must.be.admin"));
            return null;
        }
        ErrorCollection errorCollection = jiraServiceContext.getErrorCollection();
        I18nHelper i18n = jiraServiceContext.getI18nBean();
        try {
            EntityCountTaskProgressProcessor taskProgressProcessor = null;
            if (taskProgressInterval != null) {
                taskProgressProcessor = new EntityCountTaskProgressProcessor(taskProgressInterval, i18n.getText("admin.message.project.import.manager.do.mapping.extracting.project.data"), backupSystemInformation.getEntityCount(), i18n);
            }
            projectImportData = this.projectImportManager.getProjectImportData(projectImportOptions, backupProject, backupSystemInformation, taskProgressProcessor);
        }
        catch (IOException e) {
            LOG.error("There was a problem accessing the file '" + projectImportOptions.getPathToBackup() + "' when performing a project import.", (Throwable)e);
            errorCollection.addErrorMessage(this.getText(i18n, "admin.errors.project.import.problem.reading.backup", projectImportOptions.getPathToBackup()));
            return null;
        }
        catch (SAXException e) {
            LOG.error("There was a problem with the SAX parsing of the file '" + projectImportOptions.getPathToBackup() + "' when performing a project import.");
            errorCollection.addErrorMessage(this.getText(i18n, "admin.errors.project.import.sax.problem", projectImportOptions.getPathToBackup(), e.getMessage()));
            return null;
        }
        catch (LinkageError | RuntimeException e) {
            LOG.error("There was an unexpected problem processing the file '" + projectImportOptions.getPathToBackup() + "' when performing a project import.");
            errorCollection.addErrorMessage(this.getText(i18n, "admin.errors.project.import.unexpected.problem", projectImportOptions.getPathToBackup(), e.getMessage()));
            return null;
        }
        return projectImportData;
    }

    private MappingResult validateAndAutoMapFields(JiraServiceContext jiraServiceContext, ProjectImportOptions projectImportOptions, ProjectImportData projectImportData, BackupProject backupProject, BackupSystemInformation backupSystemInformation, TaskProgressInterval taskProgressInterval) {
        LOG.info("Project Import: Mapping the backed up data to data in the current system, and validating the mappings...");
        MappingResult mappingResult = this.buildMappingResult();
        I18nHelper i18n = jiraServiceContext.getI18nBean();
        this.projectImportManager.autoMapAndValidateIssueTypes(projectImportData, mappingResult, backupProject, jiraServiceContext.getI18nBean());
        if (mappingResult.getIssueTypeMessageSet() != null && !mappingResult.getIssueTypeMessageSet().hasAnyErrors()) {
            this.projectImportManager.autoMapAndValidateCustomFields(projectImportData, mappingResult, backupProject, i18n);
            if (!mappingResult.getCustomFieldMessageSet().hasAnyErrors()) {
                List<ValidationMessage> pluginMessages;
                this.projectImportManager.autoMapSystemFields(projectImportData, backupProject);
                this.projectImportManager.autoMapProjectRoles(projectImportData);
                this.projectImportManager.autoMapCustomFieldOptions(projectImportData, backupProject);
                boolean importAttachments = !StringUtils.isEmpty((String)projectImportOptions.getAttachmentPath());
                int customFieldValuePercentage = importAttachments ? 60 : 90;
                String pathToCustomFieldValueEntityXml = projectImportData.getPathToEntityXml("CustomFieldValue");
                try {
                    TaskProgressInterval subInterval = this.getSubInterval(taskProgressInterval, 0, customFieldValuePercentage);
                    EntityCountTaskProgressProcessor taskProgressProcessor = null;
                    if (taskProgressInterval != null) {
                        taskProgressProcessor = new EntityCountTaskProgressProcessor(subInterval, i18n.getText("admin.message.project.import.manager.do.mapping.validate.custom.field.values"), projectImportData.getCustomFieldValuesEntityCount(), i18n);
                    }
                    this.projectImportManager.validateCustomFieldValues(projectImportData, mappingResult, backupProject, taskProgressProcessor, i18n);
                }
                catch (IOException e) {
                    LOG.error("There was a problem accessing the file '" + pathToCustomFieldValueEntityXml + "' when performing a project import.", (Throwable)e);
                    jiraServiceContext.getErrorCollection().addErrorMessage(this.getText(i18n, "admin.errors.project.import.problem.reading.custom.field.xml", pathToCustomFieldValueEntityXml));
                    return null;
                }
                catch (SAXException e) {
                    LOG.error("There was a problem accessing the file '" + pathToCustomFieldValueEntityXml + "' when performing a project import.", (Throwable)e);
                    jiraServiceContext.getErrorCollection().addErrorMessage(this.getText(i18n, "admin.errors.project.import.custom.field.sax.problem", pathToCustomFieldValueEntityXml, e.getMessage()));
                    return null;
                }
                catch (LinkageError | RuntimeException e) {
                    LOG.error("There was an unexpected problem processing the file '" + pathToCustomFieldValueEntityXml + "' when performing a project import.", e);
                    jiraServiceContext.getErrorCollection().addErrorMessage(this.getText(i18n, "admin.errors.project.import.unexpected.problem", pathToCustomFieldValueEntityXml, e.getMessage()));
                    return null;
                }
                TaskProgressInterval sysFieldSubInterval = null;
                if (taskProgressInterval != null) {
                    sysFieldSubInterval = taskProgressInterval.getSubInterval(customFieldValuePercentage, customFieldValuePercentage + 10);
                }
                this.projectImportManager.validateSystemFields(projectImportData, mappingResult, projectImportOptions, backupProject, sysFieldSubInterval, i18n);
                if (!importAttachments) {
                    MessageSetImpl messageSet = new MessageSetImpl();
                    messageSet.addWarningMessage(this.getText(i18n, "admin.warning.project.import.mapping.no.backup.atttachment.path"));
                    LOG.warn("File attachments will not be imported because you have not provided a backup attachment path.");
                    mappingResult.setFileAttachmentMessageSet((MessageSet)messageSet);
                } else {
                    String pathToFileAttachmentEntityXml = projectImportData.getPathToEntityXml("FileAttachment");
                    try {
                        TaskProgressInterval attachmentSubInterval = this.getSubInterval(taskProgressInterval, 70, 100);
                        EntityCountTaskProgressProcessor taskProgressProcessor = null;
                        if (taskProgressInterval != null) {
                            taskProgressProcessor = new EntityCountTaskProgressProcessor(attachmentSubInterval, i18n.getText("admin.message.project.import.manager.do.mapping.validate.file.attachment.values"), projectImportData.getFileAttachmentEntityCount(), i18n);
                        }
                        this.projectImportManager.validateFileAttachments(projectImportOptions, projectImportData, mappingResult, backupProject, backupSystemInformation, taskProgressProcessor, i18n);
                    }
                    catch (IOException e) {
                        LOG.error("There was a problem accessing the file '" + pathToFileAttachmentEntityXml + "' when performing a project import.", (Throwable)e);
                        jiraServiceContext.getErrorCollection().addErrorMessage(this.getText(i18n, "admin.errors.project.import.problem.reading.attachment.xml", pathToFileAttachmentEntityXml));
                        return null;
                    }
                    catch (SAXException e) {
                        LOG.error("There was a problem accessing the file '" + pathToFileAttachmentEntityXml + "' when performing a project import.", (Throwable)e);
                        jiraServiceContext.getErrorCollection().addErrorMessage(this.getText(i18n, "admin.errors.project.import.custom.field.sax.problem", pathToFileAttachmentEntityXml, e.getMessage()));
                        return null;
                    }
                    catch (LinkageError | RuntimeException e) {
                        LOG.error("There was a problem accessing the file '" + pathToFileAttachmentEntityXml + "' when performing a project import.", e);
                        jiraServiceContext.getErrorCollection().addErrorMessage(this.getText(i18n, "admin.errors.project.import.unexpected.problem", pathToFileAttachmentEntityXml, e.getMessage()));
                        return null;
                    }
                }
                try {
                    pluginMessages = this.projectImportManager.doPluginValidation(backupProject, sysFieldSubInterval, i18n);
                }
                catch (LinkageError | RuntimeException e) {
                    LOG.error("There was an unexpected problem processing the file '" + pathToCustomFieldValueEntityXml + "' when performing a project import.", e);
                    jiraServiceContext.getErrorCollection().addErrorMessage(this.getText(i18n, "admin.errors.project.import.unexpected.problem", pathToCustomFieldValueEntityXml, e.getMessage()));
                    return null;
                }
                mappingResult.setPluginMessageList(pluginMessages);
            } else {
                this.addCustomFieldValuesNotCheckedMessageSets(projectImportData, mappingResult);
            }
        } else {
            this.addCustomFieldValuesNotCheckedMessageSets(projectImportData, mappingResult);
        }
        this.createValidationMessageList(mappingResult, projectImportData, i18n);
        if (mappingResult.canImport()) {
            LOG.info("Project Import: No validation errors were found and the import can continue.");
        } else {
            LOG.info("Project Import: Validation errors were found. The import cannot continue.");
        }
        return mappingResult;
    }

    void addCustomFieldValuesNotCheckedMessageSets(ProjectImportData projectImportData, MappingResult mappingResult) {
        HashMap<String, MessageSet> customFieldMessageSets = new HashMap<String, MessageSet>();
        CustomFieldMapper customFieldMapper = projectImportData.getProjectImportMapper().getCustomFieldMapper();
        for (String oldCustomFieldId : customFieldMapper.getRequiredOldIds()) {
            if (customFieldMapper.isIgnoredCustomField(oldCustomFieldId)) continue;
            customFieldMessageSets.put(oldCustomFieldId, null);
        }
        mappingResult.setCustomFieldValueMessageSets(customFieldMessageSets);
    }

    private void validateExistingProjectHasValidStateForImport(BackupProject backupProject, BackupSystemInformation backupSystemInformation, Project existingProject, I18nHelper i18n, MessageSet messageSet) {
        boolean allowUnassigned;
        long componentCount;
        long versionCount;
        String projectKey = backupProject.getProject().getKey();
        long issueCount = this.issueManager.getIssueCountForProject(existingProject.getId());
        if (issueCount != 0L) {
            messageSet.addErrorMessage(this.getText(i18n, "admin.error.project.import.project.contains.issues", projectKey, String.valueOf(issueCount)));
        }
        if ((versionCount = (long)this.versionManager.getVersions(existingProject.getId()).size()) != 0L) {
            messageSet.addErrorMessage(this.getText(i18n, "admin.error.project.import.project.contains.versions", projectKey, String.valueOf(versionCount)));
        }
        if ((componentCount = (long)this.projectComponentManager.findAllForProject(existingProject.getId()).size()) != 0L) {
            messageSet.addErrorMessage(this.getText(i18n, "admin.error.project.import.project.contains.components", projectKey, String.valueOf(componentCount)));
        }
        if (this.projectHasDefaultAssigneeUnassigned(backupProject, backupSystemInformation) && !(allowUnassigned = this.applicationProperties.getOption("jira.option.allowunassigned"))) {
            messageSet.addErrorMessage(this.getText(i18n, "admin.error.project.import.project.default.assignee.not.allowed", backupProject.getProject().getName()));
        }
    }

    void validateCustomFieldPluginVersions(BackupProject backupProject, Collection<PluginVersion> backupPluginVersions, MessageSet messageSet, I18nHelper i18n) {
        for (ExternalCustomFieldConfiguration customFieldConfiguration : backupProject.getCustomFields()) {
            Plugin plugin;
            String key = customFieldConfiguration.getCustomField().getTypeKey();
            int index = key.indexOf(":");
            if (index != -1) {
                key = key.substring(0, index);
            }
            if ((plugin = this.pluginAccessor.getPlugin(key)) == null) continue;
            String currentPluginVersion = plugin.getPluginInformation().getVersion();
            String backupVersion = null;
            for (PluginVersion backupPluginVersion : backupPluginVersions) {
                PluginVersion pluginVersion = backupPluginVersion;
                if (!pluginVersion.getKey().equals(key)) continue;
                backupVersion = pluginVersion.getVersion();
                break;
            }
            if (currentPluginVersion.equals(backupVersion)) continue;
            String customFieldName = customFieldConfiguration.getCustomField().getName();
            if (backupVersion == null) {
                messageSet.addErrorMessage(i18n.getText("admin.error.project.import.plugin.wrong.version.null.backup", backupProject.getProject().getName(), customFieldName, customFieldConfiguration.getCustomField().getTypeKey(), currentPluginVersion));
                continue;
            }
            messageSet.addErrorMessage(i18n.getText("admin.error.project.import.plugin.wrong.version", (Object)backupProject.getProject().getName(), (Object)customFieldName, (Object)customFieldConfiguration.getCustomField().getTypeKey(), (Object)currentPluginVersion, (Object)backupVersion));
        }
    }

    String getText(I18nHelper i18n, String key, String value1, String value2) {
        return i18n.getText(key, value1, value2);
    }

    String getText(I18nHelper i18n, String key, String value1) {
        return i18n.getText(key, value1);
    }

    String getBuildNumber() {
        return this.buildUtilsInfo.getCurrentBuildNumber();
    }

    String getText(I18nHelper i18n, String key) {
        return i18n.getText(key);
    }

    void validateJiraServiceContext(JiraServiceContext jiraServiceContext) {
        if (jiraServiceContext == null) {
            throw new IllegalArgumentException("The JiraServiceContext must not be null.");
        }
    }

    MappingResult buildMappingResult() {
        return new MappingResult();
    }

    boolean isExternalUserManagementEnabled() {
        return !this.userManager.hasWritableDirectory();
    }

    boolean userHasSysAdminPermission(ApplicationUser user) {
        return this.permissionManager.hasPermission(44, user);
    }

    ProjectImportResults getInitialImportResults(ProjectImportData projectImportData, I18nHelper i18n, int usersToCreate) {
        return new ProjectImportResultsImpl(System.currentTimeMillis(), projectImportData.getIssueEntityCount(), usersToCreate, projectImportData.getValidAttachmentsCount(), i18n);
    }

    private boolean pathExists(String path, boolean isFile) {
        File file = new File(path);
        boolean fileExists = file.exists();
        boolean fileIsCorrectType = isFile ? file.isFile() : file.isDirectory();
        return fileExists && fileIsCorrectType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean validIndexZipFile(String zipFile) {
        boolean bl;
        ZipFile file = new ZipFile(zipFile);
        try {
            ZipArchiveEntry ofbizXML = file.getEntry("entities.xml");
            ZipArchiveEntry aoXML = file.getEntry("activeobjects.xml");
            bl = ofbizXML != null && aoXML != null;
        }
        catch (Throwable throwable) {
            try {
                ZipFile.closeQuietly((ZipFile)file);
                throw throwable;
            }
            catch (IOException e) {
                LOG.debug("Can't access zip file '" + zipFile + "'");
                return false;
            }
        }
        ZipFile.closeQuietly((ZipFile)file);
        return bl;
    }
}

