/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.avatar.types.project;

import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.avatar.types.AvatarAccessPolicy;
import com.atlassian.jira.bc.project.ProjectAction;
import com.atlassian.jira.bc.project.ProjectService;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;

public class ProjectAvatarAccessPolicy
implements AvatarAccessPolicy {
    private final ProjectManager projectManager;
    private final PermissionManager permissionManager;
    private final ProjectService projectService;

    public ProjectAvatarAccessPolicy(ProjectManager projectManager, PermissionManager permissionManager, ProjectService projectService) {
        this.projectManager = projectManager;
        this.permissionManager = permissionManager;
        this.projectService = projectService;
    }

    @Override
    public boolean userCanViewAvatar(ApplicationUser user, Avatar avatar) {
        if (!this.hasCorrectType(avatar)) {
            return false;
        }
        if (avatar.isSystemAvatar()) {
            return true;
        }
        long owningProjectId = Long.parseLong(avatar.getOwner());
        Project project = this.projectManager.getProjectObj(Long.valueOf(owningProjectId));
        boolean hasPermission = null != project;
        hasPermission = hasPermission && this.hasUserPermissionToProject(user, project);
        return hasPermission;
    }

    @Override
    public boolean userCanCreateAvatarFor(ApplicationUser user, String owningObjectId) {
        long owningProjectId;
        try {
            owningProjectId = Long.parseLong(owningObjectId);
        }
        catch (Exception x) {
            throw new IllegalArgumentException("ownerId", x);
        }
        ProjectService.GetProjectResult getProjectResult = this.projectService.getProjectByIdForAction(user, Long.valueOf(owningProjectId), ProjectAction.EDIT_PROJECT_CONFIG);
        return getProjectResult.isValid();
    }

    private boolean hasCorrectType(Avatar avatar) {
        return Avatar.Type.PROJECT == avatar.getAvatarType();
    }

    private boolean hasUserPermissionToProject(ApplicationUser remoteUser, Project project) {
        boolean isAdmin = this.permissionManager.hasPermission(0, remoteUser);
        boolean isProjectAdmin = this.permissionManager.hasPermission(ProjectPermissions.ADMINISTER_PROJECTS, project, remoteUser);
        boolean hasBrowseProject = this.permissionManager.hasPermission(ProjectPermissions.BROWSE_PROJECTS, project, remoteUser);
        return hasBrowseProject || isProjectAdmin || isAdmin;
    }
}

