/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.avatar;

import com.atlassian.fugue.Option;
import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.avatar.AvatarManager;
import com.atlassian.jira.avatar.AvatarService;
import com.atlassian.jira.avatar.AvatarsDisabledException;
import com.atlassian.jira.avatar.GravatarSettings;
import com.atlassian.jira.avatar.JiraAvatarSupport;
import com.atlassian.jira.avatar.JiraPluginAvatar;
import com.atlassian.jira.avatar.NoPermissionException;
import com.atlassian.jira.avatar.PluginAvatarAdapter;
import com.atlassian.jira.cluster.ClusterSafe;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.UserPropertyManager;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.Supplier;
import com.atlassian.jira.util.UrlBuilder;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.web.Condition;
import com.atlassian.plugin.web.descriptors.AbstractWebFragmentModuleDescriptor;
import com.atlassian.util.concurrent.LazyReference;
import com.opensymphony.module.propertyset.PropertySet;
import java.net.URI;
import java.util.Collections;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AvatarServiceImpl
implements AvatarService {
    private static final Logger LOGGER = LoggerFactory.getLogger(AvatarServiceImpl.class);
    private final UserManager userManager;
    private final AvatarManager avatarManager;
    private final UserPropertyManager userPropertyManager;
    private final VelocityRequestContextFactory velocityRequestContextFactory;
    private final ApplicationProperties applicationProperties;
    private final GravatarSettings gravatarSettings;
    private final Supplier<JiraAvatarSupport> jiraAvatarSupport;
    private final PluginAccessor pluginAccessor;
    @ClusterSafe
    private final LazyReference<Avatar.Size> defaultAvatarSize = new LazyReference<Avatar.Size>(){

        protected Avatar.Size create() throws Exception {
            return Avatar.Size.defaultSize();
        }
    };

    AvatarServiceImpl(UserManager userManager, AvatarManager avatarManager, UserPropertyManager userPropertyManager, VelocityRequestContextFactory velocityRequestContextFactory, ApplicationProperties applicationProperties, GravatarSettings gravatarSettings, Supplier<JiraAvatarSupport> jiraAvatarSupport, PluginAccessor pluginAccessor) {
        this.userManager = userManager;
        this.avatarManager = avatarManager;
        this.userPropertyManager = userPropertyManager;
        this.velocityRequestContextFactory = velocityRequestContextFactory;
        this.applicationProperties = applicationProperties;
        this.gravatarSettings = gravatarSettings;
        this.jiraAvatarSupport = jiraAvatarSupport;
        this.pluginAccessor = pluginAccessor;
    }

    public AvatarServiceImpl(UserManager userManager, AvatarManager avatarManager, UserPropertyManager userPropertyManager, VelocityRequestContextFactory velocityRequestContextFactory, ApplicationProperties applicationProperties, GravatarSettings gravatarSettings, PluginAccessor pluginAccessor) {
        this(userManager, avatarManager, userPropertyManager, velocityRequestContextFactory, applicationProperties, gravatarSettings, (Supplier<JiraAvatarSupport>)ComponentAccessor.getOsgiComponentReference(JiraAvatarSupport.class), pluginAccessor);
    }

    protected static ApplicationUser fromStaleUser(ApplicationUser user) {
        try {
            return user;
        }
        catch (IllegalStateException e) {
            return null;
        }
    }

    public Avatar getAvatar(ApplicationUser remoteUser, String username) throws AvatarsDisabledException {
        ApplicationUser user = this.userManager.getUserByName(username);
        if (user == null) {
            Avatar anonymousAvatar = this.getAnonymousAvatar();
            LOGGER.debug("User with key '{}' does not exist, using anonymous avatar id {}", (Object)username, (Object)(anonymousAvatar != null ? anonymousAvatar.getId() : null));
            return anonymousAvatar;
        }
        return this.getAvatarImpl(AvatarServiceImpl.fromStaleUser(remoteUser), false, user, false);
    }

    private Avatar getAvatarImpl(ApplicationUser applicationUser, boolean skipPermissionCheck, final @Nonnull ApplicationUser user, boolean absoluteUrl) {
        JiraPluginAvatar jiraPluginAvatar = ((JiraAvatarSupport)this.jiraAvatarSupport.get()).getAvatar(user, "small");
        return new PluginAvatarAdapter(jiraPluginAvatar, Avatar.Type.USER){

            @Override
            public Long getId() {
                Option pluginModule = Option.option((Object)AvatarServiceImpl.this.pluginAccessor.getEnabledPluginModule("com.atlassian.id.atlassian-account-plugin:atlassianIdAvatarProvider"));
                boolean atlassianIdActive = false;
                if (pluginModule.isDefined()) {
                    try {
                        Condition condition = ((AbstractWebFragmentModuleDescriptor)pluginModule.get()).getCondition();
                        atlassianIdActive = condition.shouldDisplay(Collections.emptyMap());
                    }
                    catch (RuntimeException runtimeException) {
                        // empty catch block
                    }
                }
                if (atlassianIdActive) {
                    return super.getId();
                }
                LOGGER.debug("getId() for user avatar should no longer be called. It'll always return null in 7.0");
                return AvatarServiceImpl.this.userPropertyManager.getPropertySet(user).getLong("user.avatar.id");
            }
        };
    }

    public Avatar getAvatar(ApplicationUser remoteUser, ApplicationUser avatarUser) throws AvatarsDisabledException {
        if (avatarUser == null) {
            return this.getAnonymousAvatar();
        }
        return this.getAvatarImpl(remoteUser, false, avatarUser, false);
    }

    public Avatar getAvatarTagged(ApplicationUser remoteUser, ApplicationUser avatarUser) throws AvatarsDisabledException {
        if (avatarUser == null) {
            return this.getAnonymousAvatar();
        }
        return this.getAvatarImpl(remoteUser, false, avatarUser, true);
    }

    public URI getAvatarURL(ApplicationUser remoteUser, String username) throws AvatarsDisabledException {
        return this.getAvatarURL(AvatarServiceImpl.fromStaleUser(remoteUser), this.userManager.getUserByName(username));
    }

    public URI getAvatarURL(ApplicationUser remoteUser, ApplicationUser avatarUser) throws AvatarsDisabledException {
        return this.getAvatarURLImpl(remoteUser, false, avatarUser, (Avatar.Size)this.defaultAvatarSize.get());
    }

    private URI getAvatarURLImpl(ApplicationUser remoteUser, boolean skipPermissionCheck, ApplicationUser avatarUser, Avatar.Size size) {
        return URI.create(((JiraAvatarSupport)this.jiraAvatarSupport.get()).getAvatar(avatarUser, size.getParam()).getUrl());
    }

    public URI getAvatarURL(ApplicationUser remoteUser, String username, Avatar.Size size) throws AvatarsDisabledException {
        return this.getAvatarURLImpl(AvatarServiceImpl.fromStaleUser(remoteUser), false, this.userManager.getUserByName(username), size);
    }

    public URI getAvatarURL(ApplicationUser remoteUser, ApplicationUser avatarUser, Avatar.Size size) throws AvatarsDisabledException {
        return this.getAvatarURLImpl(remoteUser, false, avatarUser, size);
    }

    public URI getAvatarUrlNoPermCheck(String username, Avatar.Size size) throws AvatarsDisabledException {
        return this.getAvatarURLImpl(null, true, this.userManager.getUserByName(username), size);
    }

    public URI getAvatarUrlNoPermCheck(ApplicationUser avatarUser, Avatar.Size size) throws AvatarsDisabledException {
        return this.getAvatarURLImpl(null, true, avatarUser, size);
    }

    public URI getAvatarUrlNoPermCheck(ApplicationUser avatarUser, Avatar avatar, @Nonnull Avatar.Size size) {
        Long id = avatar.getId();
        String sizeName = size.getParam();
        if (avatar.getAvatarType() == Avatar.Type.USER) {
            return URI.create(((JiraAvatarSupport)this.jiraAvatarSupport.get()).getAvatarById(id, sizeName).getUrl());
        }
        return this.getProjectAvatarUrl(avatar, size);
    }

    public URI getAvatarAbsoluteURL(ApplicationUser remoteUser, String username, Avatar.Size size) throws AvatarsDisabledException {
        return this.getAvatarURLImpl(AvatarServiceImpl.fromStaleUser(remoteUser), false, this.userManager.getUserByName(username), size);
    }

    public URI getAvatarAbsoluteURL(ApplicationUser remoteUser, ApplicationUser avatarUser, Avatar.Size size) throws AvatarsDisabledException {
        return this.getAvatarURLImpl(remoteUser, false, avatarUser, size);
    }

    public boolean hasCustomUserAvatar(ApplicationUser remoteUser, String username) {
        ApplicationUser user = this.userManager.getUserByName(username);
        if (user == null) {
            throw new IllegalArgumentException(String.format("User '%s' does not exist", username));
        }
        return this.hasCustomUserAvatar(AvatarServiceImpl.fromStaleUser(remoteUser), user);
    }

    public boolean hasCustomUserAvatar(ApplicationUser remoteUser, ApplicationUser user) {
        return remoteUser != null && (this.configuredAvatarIdFor(user) != null || this.isUsingExternalAvatar(remoteUser, user));
    }

    public void setCustomUserAvatar(ApplicationUser remoteUser, String username, Long avatarId) throws AvatarsDisabledException, NoPermissionException {
        ApplicationUser user = this.userManager.getUserByName(username);
        if (user == null) {
            throw new IllegalArgumentException(String.format("User '%s' does not exist", username));
        }
        this.setCustomUserAvatar(AvatarServiceImpl.fromStaleUser(remoteUser), user, avatarId);
    }

    public void setCustomUserAvatar(ApplicationUser remoteUser, ApplicationUser user, Long avatarId) throws AvatarsDisabledException, NoPermissionException {
        if (!this.canSetCustomUserAvatar(remoteUser, user)) {
            throw new NoPermissionException();
        }
        this.setConfiguredAvatarIdFor(user, avatarId);
    }

    public boolean canSetCustomUserAvatar(ApplicationUser remoteUser, String username) {
        ApplicationUser user = this.userManager.getUserByName(username);
        if (user == null) {
            throw new IllegalArgumentException(String.format("User '%s' does not exist", username));
        }
        return this.canSetCustomUserAvatar(AvatarServiceImpl.fromStaleUser(remoteUser), user);
    }

    public boolean canSetCustomUserAvatar(ApplicationUser remoteUser, ApplicationUser user) {
        return this.avatarManager.hasPermissionToEdit(remoteUser, user);
    }

    public URI getProjectAvatarURL(Project project, Avatar.Size size) {
        String baseUrl = this.velocityRequestContextFactory.getJiraVelocityRequestContext().getBaseUrl();
        return this.getProjectAvatarURLImpl(project, size, baseUrl);
    }

    public URI getProjectAvatarAbsoluteURL(Project project, Avatar.Size size) {
        String baseUrl = this.velocityRequestContextFactory.getJiraVelocityRequestContext().getCanonicalBaseUrl();
        return this.getProjectAvatarURLImpl(project, size, baseUrl);
    }

    private URI getProjectAvatarUrl(Avatar avatar, Avatar.Size size) {
        Long avatarId;
        String baseUrl = this.velocityRequestContextFactory.getJiraVelocityRequestContext().getCanonicalBaseUrl();
        UrlBuilder urlBuilder = new UrlBuilder(baseUrl + "/secure/projectavatar", this.applicationProperties.getEncoding(), false);
        if (size != null && !size.isDefault) {
            urlBuilder.addParameter("size", size.param);
        }
        Long l = avatarId = avatar != null ? avatar.getId() : null;
        if (avatarId != null) {
            urlBuilder.addParameter("avatarId", avatarId.toString());
        }
        return urlBuilder.asURI();
    }

    private URI getProjectAvatarURLImpl(Project project, Avatar.Size size, String baseUrl) {
        Long avatarId;
        Avatar avatar = project.getAvatar();
        Long l = avatarId = avatar == null ? null : avatar.getId();
        if (this.avatarManager.getDefaultAvatarId(Avatar.Type.PROJECT).equals(avatarId)) {
            return this.getProjectDefaultAvatarURLImpl(size, baseUrl);
        }
        UrlBuilder urlBuilder = new UrlBuilder(baseUrl + "/secure/projectavatar", this.applicationProperties.getEncoding(), false);
        if (size != null && !size.isDefault) {
            urlBuilder.addParameter("size", size.param);
        }
        urlBuilder.addParameter("pid", (Object)project.getId());
        if (avatarId != null) {
            urlBuilder.addParameter("avatarId", avatarId.toString());
        }
        return urlBuilder.asURI();
    }

    public URI getProjectDefaultAvatarURL(Avatar.Size size) {
        String baseUrl = this.velocityRequestContextFactory.getJiraVelocityRequestContext().getBaseUrl();
        return this.getProjectDefaultAvatarURLImpl(size, baseUrl);
    }

    public URI getProjectDefaultAvatarAbsoluteURL(Avatar.Size size) {
        String baseUrl = this.velocityRequestContextFactory.getJiraVelocityRequestContext().getCanonicalBaseUrl();
        return this.getProjectDefaultAvatarURLImpl(size, baseUrl);
    }

    private URI getProjectDefaultAvatarURLImpl(Avatar.Size size, String baseUrl) {
        UrlBuilder urlBuilder = new UrlBuilder(baseUrl + "/secure/projectavatar", this.applicationProperties.getEncoding(), false);
        if (size != null && !size.isDefault) {
            urlBuilder.addParameter("size", size.param);
        }
        urlBuilder.addParameter("avatarId", this.avatarManager.getDefaultAvatarId(Avatar.Type.PROJECT).toString());
        return urlBuilder.asURI();
    }

    protected Long configuredAvatarIdFor(ApplicationUser user) {
        PropertySet userProperties = this.userPropertyManager.getPropertySet(user);
        if (userProperties.exists("user.avatar.id")) {
            long avatarId = userProperties.getLong("user.avatar.id");
            LOGGER.debug("Avatar configured for user '{}' is {}", (Object)user.getUsername(), (Object)avatarId);
            return avatarId;
        }
        return null;
    }

    public boolean isGravatarEnabled() {
        return this.gravatarSettings.isAllowGravatars();
    }

    public boolean isUsingExternalAvatar(ApplicationUser remoteUser, ApplicationUser avatarUser) {
        return ((JiraAvatarSupport)this.jiraAvatarSupport.get()).getAvatar(avatarUser, "small").isExternal();
    }

    protected void setConfiguredAvatarIdFor(ApplicationUser user, Long avatarId) {
        PropertySet userProperties = this.userPropertyManager.getPropertySet(user);
        userProperties.setLong("user.avatar.id", avatarId.longValue());
        LOGGER.debug("Set configured avatar id for user '{}' to {}", (Object)user.getUsername(), (Object)avatarId);
    }

    protected boolean canViewAvatar(ApplicationUser user, Avatar avatar) {
        boolean hasPermission = this.avatarManager.hasPermissionToView(user, avatar.getAvatarType(), avatar.getOwner());
        if (!hasPermission) {
            LOGGER.debug("User '{}' is not allowed to view avatar {}", (Object)user, (Object)avatar.getId());
        }
        return hasPermission;
    }

    protected Avatar getDefaultAvatar() {
        Long defaultAvatarId = this.avatarManager.getDefaultAvatarId(Avatar.Type.USER);
        return defaultAvatarId != null ? this.avatarManager.getById(defaultAvatarId) : null;
    }

    protected Avatar getAnonymousAvatar() {
        Long anonAvatarId = this.avatarManager.getAnonymousAvatarId();
        return anonAvatarId != null ? this.avatarManager.getById(anonAvatarId) : null;
    }
}

