/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.application;

import com.atlassian.annotations.Internal;
import com.atlassian.application.api.ApplicationKey;
import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheLoader;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.cache.CachedReference;
import com.atlassian.cache.Supplier;
import com.atlassian.collectors.CollectorsUtil;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.embedded.api.UserWithAttributes;
import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.crowd.event.application.ApplicationDirectoryOrderUpdatedEvent;
import com.atlassian.crowd.event.directory.DirectoryUpdatedEvent;
import com.atlassian.crowd.event.group.GroupCreatedEvent;
import com.atlassian.crowd.event.group.GroupDeletedEvent;
import com.atlassian.crowd.event.group.GroupMembershipCreatedEvent;
import com.atlassian.crowd.event.group.GroupMembershipDeletedEvent;
import com.atlassian.crowd.event.group.GroupUpdatedEvent;
import com.atlassian.crowd.event.migration.XMLRestoreFinishedEvent;
import com.atlassian.crowd.event.user.AutoUserUpdatedEvent;
import com.atlassian.crowd.event.user.UserDeletedEvent;
import com.atlassian.crowd.event.user.UserEditedEvent;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.fugue.Option;
import com.atlassian.jira.CachingComponent;
import com.atlassian.jira.EventComponent;
import com.atlassian.jira.application.ApplicationKeys;
import com.atlassian.jira.application.ApplicationRole;
import com.atlassian.jira.application.ApplicationRoleDefinitions;
import com.atlassian.jira.application.ApplicationRoleManager;
import com.atlassian.jira.application.ApplicationRoleStore;
import com.atlassian.jira.application.CallableWithoutFeatureFlag;
import com.atlassian.jira.application.DefinitionApplicationRole;
import com.atlassian.jira.application.IdApplicationRole;
import com.atlassian.jira.cluster.ClusterSafe;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.CoreFeatures;
import com.atlassian.jira.config.FeatureEvent;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.license.JiraLicenseManager;
import com.atlassian.jira.license.LicenseChangedEvent;
import com.atlassian.jira.license.LicenseCountService;
import com.atlassian.jira.license.LicenseDetails;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.RecoveryMode;
import com.atlassian.jira.user.util.Users;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@EventComponent
public final class DefaultApplicationRoleManager
implements ApplicationRoleManager,
CachingComponent,
LicenseCountService {
    private static final Logger log = LoggerFactory.getLogger(DefaultApplicationRoleManager.class);
    private static final Pattern CONNECT_USER_ATTRIBUTE_PATTERN = Pattern.compile("^synch\\..+\\.atlassian-connect-user$");
    private final ApplicationRoleDefinitions definitions;
    private final GroupManager groupManager;
    private final ApplicationRoleStore applicationRoleStore;
    private final JiraLicenseManager licenseManager;
    private final RecoveryMode recoveryMode;
    private final FeatureManager featureManager;
    private final CrowdService crowdService;
    private final EventPublisher eventPublisher;
    @ClusterSafe
    private final Cache<ApplicationKey, Option<ApplicationRole>> appRoleCache;
    @ClusterSafe
    private final Cache<ApplicationKey, Integer> activeUsersCountForLicense;
    private final CachedReference<Integer> billableUsersCount;
    private GlobalPermissionManager globalPermissionManager;

    public DefaultApplicationRoleManager(@Nonnull CacheManager cacheManager, @Nonnull ApplicationRoleStore store, @Nonnull ApplicationRoleDefinitions definitions, @Nonnull GroupManager groupManager, @Nonnull JiraLicenseManager licenseManager, @Nonnull FeatureManager featureManager, @Nonnull RecoveryMode recoveryMode, @Nonnull CrowdService crowdService, @Nonnull EventPublisher eventPublisher) {
        Assertions.notNull((String)"cacheManager", (Object)cacheManager);
        this.recoveryMode = (RecoveryMode)Assertions.notNull((String)"recoveryMode", (Object)recoveryMode);
        this.groupManager = (GroupManager)Assertions.notNull((String)"groupManager", (Object)groupManager);
        this.applicationRoleStore = (ApplicationRoleStore)Assertions.notNull((String)"store", (Object)store);
        this.definitions = (ApplicationRoleDefinitions)Assertions.notNull((String)"definitions", (Object)definitions);
        this.licenseManager = (JiraLicenseManager)Assertions.notNull((String)"licenseManager", (Object)licenseManager);
        this.featureManager = (FeatureManager)Assertions.notNull((String)"featureManager", (Object)featureManager);
        this.crowdService = (CrowdService)Assertions.notNull((String)"crowdService", (Object)crowdService);
        this.eventPublisher = (EventPublisher)Assertions.notNull((String)"eventPublisher", (Object)eventPublisher);
        this.appRoleCache = cacheManager.getCache(DefaultApplicationRoleManager.class.getName() + ".applicationRoleGroups", (CacheLoader)new RoleLoader(), new CacheSettingsBuilder().expireAfterAccess(30L, TimeUnit.MINUTES).maxEntries(100).build());
        this.activeUsersCountForLicense = cacheManager.getCache(DefaultApplicationRoleManager.class.getName() + ".activeUsersCountForLicense", (CacheLoader)new ActiveUserCountLoader(), new CacheSettingsBuilder().expireAfterWrite(2L, TimeUnit.HOURS).build());
        this.billableUsersCount = cacheManager.getCachedReference(this.getClass().getName() + ".billableUsersCount", (Supplier)new BillableUserCountLoader(), new CacheSettingsBuilder().expireAfterWrite(2L, TimeUnit.HOURS).build());
    }

    @Nonnull
    @CallableWithoutFeatureFlag
    public Option<ApplicationRole> getRole(@Nonnull ApplicationKey role) {
        Assertions.notNull((String)"role", (Object)role);
        if (!this.rolesEnabled()) {
            return Option.none();
        }
        return (Option)this.appRoleCache.get((Object)role);
    }

    @Nonnull
    @CallableWithoutFeatureFlag
    public Set<ApplicationRole> getRoles() {
        if (!this.rolesEnabled()) {
            return Collections.emptySet();
        }
        HashSet roles = Sets.newHashSet();
        for (ApplicationKey appKey : this.licenseManager.getAllLicensedApplicationKeys()) {
            Iterables.addAll((Collection)roles, this.getRole(appKey));
        }
        return Collections.unmodifiableSet(roles);
    }

    @Nonnull
    @Deprecated
    @CallableWithoutFeatureFlag
    public Set<ApplicationRole> getDefaultRoles() {
        return (Set)this.getRoles().stream().filter(ApplicationRole::isSelectedByDefault).collect(CollectorsUtil.toImmutableSet());
    }

    @Nonnull
    @CallableWithoutFeatureFlag
    public Set<ApplicationKey> getDefaultApplicationKeys() {
        return (Set)this.getDefaultRoles().stream().map(ApplicationRole::getKey).collect(CollectorsUtil.toImmutableSet());
    }

    public boolean hasAnyRole(@Nullable ApplicationUser user) {
        this.dontUseRolesWhenFeatureFlagNotEnabled();
        if (user == null) {
            return false;
        }
        return this.getRoles().stream().anyMatch(role -> this.userHasRole(user, (ApplicationRole)role)) || this.recoveryMode.isRecoveryUser(user);
    }

    public boolean userHasRole(@Nullable ApplicationUser user, ApplicationKey key) {
        Assertions.notNull((String)"key", (Object)key);
        this.dontUseRolesWhenFeatureFlagNotEnabled();
        if (Users.isAnonymous((ApplicationUser)user)) {
            return false;
        }
        Set groups = (Set)this.getRole(key).map(ApplicationRole::getGroups).getOrElse((Object)ImmutableSet.of());
        for (Group appGroup : groups) {
            if (!this.groupManager.isUserInGroup(user, appGroup)) continue;
            return true;
        }
        return false;
    }

    @CallableWithoutFeatureFlag
    public boolean isAnyRoleLimitExceeded() {
        if (!this.rolesEnabled()) {
            return this.legacyIsRoleLimitExceeded();
        }
        Set<ApplicationRole> roles = this.getRoles();
        if (roles.isEmpty()) {
            return true;
        }
        for (ApplicationRole role : roles) {
            if (!this.isRoleLimitExceeded(role.getKey())) continue;
            return true;
        }
        return false;
    }

    public boolean isRoleLimitExceeded(@Nonnull ApplicationKey role) {
        this.dontUseRolesWhenFeatureFlagNotEnabled();
        int numGrantedSeats = this.getNumberOfSeatsGrantedToRole(role);
        if (numGrantedSeats == -1) {
            return false;
        }
        return this.getUserCount(role) > numGrantedSeats;
    }

    @CallableWithoutFeatureFlag
    public boolean hasExceededAllRoles(@Nonnull ApplicationUser user) {
        Assertions.notNull((Object)user);
        if (!this.rolesEnabled()) {
            return this.legacyIsRoleLimitExceeded();
        }
        Set<ApplicationRole> rolesForUser = this.getRolesForUser(user);
        return rolesForUser.stream().allMatch(role -> this.isRoleLimitExceeded(role.getKey()));
    }

    public Set<ApplicationRole> getRolesForUser(@Nonnull ApplicationUser user) {
        Assertions.notNull((Object)user);
        this.dontUseRolesWhenFeatureFlagNotEnabled();
        return (Set)this.getRoles().stream().filter(role -> this.userHasRole(user, (ApplicationRole)role)).collect(CollectorsUtil.toImmutableSet());
    }

    public Set<ApplicationRole> getRolesForGroup(@Nonnull Group group) {
        Assertions.notNull((String)"group", (Object)group);
        this.dontUseRolesWhenFeatureFlagNotEnabled();
        HashSet roles = Sets.newHashSet();
        block0: for (ApplicationRole role : this.getRoles()) {
            for (Group roleGroup : role.getGroups()) {
                if (!roleGroup.equals((Object)group) && !this.crowdService.isGroupMemberOfGroup(group, roleGroup)) continue;
                roles.add(role);
                continue block0;
            }
        }
        return Collections.unmodifiableSet(roles);
    }

    @Nonnull
    @CallableWithoutFeatureFlag
    public Set<Group> getGroupsForLicensedRoles() {
        return (Set)this.getRoles().stream().map(ApplicationRole::getGroups).flatMap(Collection::stream).collect(CollectorsUtil.toImmutableSet());
    }

    @CallableWithoutFeatureFlag
    public void removeGroupFromRoles(@Nonnull Group group) {
        Assertions.notNull((String)"group", (Object)group);
        this.applicationRoleStore.removeGroup(group.getName());
        this.clearCache();
    }

    @CallableWithoutFeatureFlag
    public boolean isRoleInstalledAndLicensed(@Nonnull ApplicationKey key) {
        Assertions.notNull((String)"key", (Object)key);
        return this.definitions.isDefined(key) && this.definitions.isLicensed(key);
    }

    @Nonnull
    public ApplicationRole setRole(@Nonnull ApplicationRole role) {
        this.dontUseRolesWhenFeatureFlagNotEnabled();
        this.validateRole((ApplicationRole)Assertions.notNull((String)"role", (Object)role));
        ApplicationKey key = role.getKey();
        try {
            this.applicationRoleStore.save(new ApplicationRoleStore.ApplicationRoleData(key, DefaultApplicationRoleManager.groupNames(role.getGroups()), DefaultApplicationRoleManager.groupNames(role.getDefaultGroups()), role.isSelectedByDefault()));
        }
        finally {
            this.clearCacheLine(key);
        }
        return (ApplicationRole)((Option)this.appRoleCache.get((Object)key)).getOrElse(() -> IdApplicationRole.empty(key));
    }

    public int getUserCount(@Nonnull ApplicationKey key) {
        Assertions.notNull((String)"key", (Object)key);
        this.dontUseRolesWhenFeatureFlagNotEnabled();
        return (Integer)this.activeUsersCountForLicense.get((Object)key);
    }

    public int getRemainingSeats(@Nonnull ApplicationKey key) {
        Assertions.notNull((String)"key", (Object)key);
        if (!this.rolesEnabled() && this.featureManager.isOnDemand()) {
            return -1;
        }
        this.dontUseRolesWhenFeatureFlagNotEnabled();
        return (Integer)this.getRole(key).map(applicationRole -> {
            int numberOfSeats = applicationRole.getNumberOfSeats();
            if (numberOfSeats == -1) {
                return -1;
            }
            int activeUsers = this.getUserCount(key);
            return Math.max(numberOfSeats - activeUsers, 0);
        }).getOrElse((Object)0);
    }

    public boolean hasSeatsAvailable(@Nonnull ApplicationKey key, int seatCount) {
        Assertions.notNull((String)"key", (Object)key);
        this.dontUseRolesWhenFeatureFlagNotEnabled();
        if (seatCount < 0) {
            throw new IllegalArgumentException("seatCount < 0");
        }
        int remainingSeats = this.getRemainingSeats(key);
        return remainingSeats == -1 || seatCount <= remainingSeats;
    }

    @Nonnull
    public Set<Group> getDefaultGroups(@Nonnull ApplicationKey key) {
        Assertions.notNull((String)"key", (Object)key);
        this.dontUseRolesWhenFeatureFlagNotEnabled();
        return (Set)this.getRole(key).map(ApplicationRole::getDefaultGroups).getOrElse((Object)ImmutableSet.of());
    }

    @CallableWithoutFeatureFlag
    public boolean rolesEnabled() {
        return this.featureManager.isEnabled(CoreFeatures.LICENSE_ROLES_ENABLED);
    }

    @EventListener
    public void onClearCache(ClearCacheEvent event) {
        this.clearCaches(event);
        this.eventPublisher.publish((Object)new XMLRestoreFinishedEvent((Object)this));
    }

    @EventListener
    public void onLicenseChanged(LicenseChangedEvent event) {
        this.clearCaches(event);
    }

    @EventListener
    public void onFeatureChange(FeatureEvent event) {
        if (CoreFeatures.forFeatureKey((String)event.feature()) == CoreFeatures.LICENSE_ROLES_ENABLED) {
            this.clearCaches(event);
        }
    }

    @EventListener
    public void onGroupCreated(GroupCreatedEvent createdEvent) {
        this.clearCaches(createdEvent);
    }

    @EventListener
    public void onGroupDeleted(GroupDeletedEvent deletedEvent) {
        this.clearCaches(deletedEvent);
    }

    @EventListener
    public void onGroupUpdated(GroupUpdatedEvent updatedEvent) {
        this.clearCaches(updatedEvent);
    }

    @EventListener
    public void onDirectoryReorder(ApplicationDirectoryOrderUpdatedEvent event) {
        this.clearCaches(event);
    }

    @EventListener
    public void onDirectoryUpdated(DirectoryUpdatedEvent event) {
        this.clearCaches(event);
    }

    @EventListener
    public void onGroupMembershipCreated(GroupMembershipCreatedEvent e) {
        this.clearUserCounts(e);
    }

    @EventListener
    public void onGroupMembershipDeleted(GroupMembershipDeletedEvent e) {
        this.clearUserCounts(e);
    }

    @EventListener
    public void onUserDeleted(UserDeletedEvent e) {
        this.clearUserCounts(e);
    }

    @EventListener
    public void onUserUpdated(UserEditedEvent event) {
        this.clearCacheForUpdatedUser(event, (User)event.getOriginalUser(), (User)event.getUser());
    }

    @EventListener
    public void onUserUpdated(AutoUserUpdatedEvent event) {
        this.clearCacheForUpdatedUser(event, (User)event.getOriginalUser(), (User)event.getUser());
    }

    @Override
    @Internal
    public void clearCache() {
        this.appRoleCache.removeAll();
        this.activeUsersCountForLicense.removeAll();
        this.flushBillableUsersCache();
    }

    @CallableWithoutFeatureFlag
    public int totalBillableUsers() {
        return (Integer)this.billableUsersCount.get();
    }

    @CallableWithoutFeatureFlag
    public void flush() {
        this.flushBillableUsersCache();
    }

    @CallableWithoutFeatureFlag
    public void flushBillableUsersCache() {
        this.billableUsersCount.reset();
    }

    private boolean legacyIsRoleLimitExceeded() {
        if (this.featureManager.isOnDemand()) {
            return false;
        }
        int maxUsers = ((LicenseDetails)this.licenseManager.getLicenses().iterator().next()).getJiraLicense().getMaximumNumberOfUsers();
        return maxUsers != -1 && this.totalBillableUsers() > maxUsers;
    }

    private int getNumberOfSeatsGrantedToRole(@Nonnull ApplicationKey roleKey) {
        int numSeats = 0;
        for (LicenseDetails license : this.licenseManager.getLicenses()) {
            int num = license.getLicensedApplications().getUserLimit(roleKey);
            if (num == 0) continue;
            if (numSeats != 0) {
                throw new IllegalStateException("Application role has users granted in > 1 license: " + roleKey);
            }
            numSeats = num;
        }
        return numSeats;
    }

    private void validateRole(ApplicationRole role) {
        if (!this.licenseManager.getAllLicensedApplicationKeys().contains(role.getKey())) {
            throw new IllegalArgumentException(String.format("The '%s' role is not provided by any license.", role.getKey()));
        }
        for (Group group : role.getGroups()) {
            if (this.groupManager.groupExists(group)) continue;
            throw new IllegalArgumentException(String.format("The '%s' role is associated with group '%s', which does not exist.", role.getKey(), group.getName()));
        }
    }

    private boolean userHasRole(@Nonnull ApplicationUser user, @Nonnull ApplicationRole role) {
        return role.getGroups().stream().anyMatch(group -> this.groupManager.isUserInGroup(user, group));
    }

    private void clearCaches(@Nullable Object event) {
        String eventName = event != null ? event.getClass().getName() : "<UNKNOWN>";
        log.debug("Clearing the cache on {}.", (Object)eventName);
        this.clearCache();
    }

    private void clearUserCounts(@Nullable Object event) {
        String eventName = event != null ? event.getClass().getName() : "<UNKNOWN>";
        log.debug("Clearing the user counts on {}.", (Object)eventName);
        this.activeUsersCountForLicense.removeAll();
        this.flushBillableUsersCache();
    }

    private void clearCacheForUpdatedUser(@Nullable Object event, User originalUser, @Nullable User updatedUser) {
        if (updatedUser == null || originalUser.isActive() != updatedUser.isActive()) {
            this.clearUserCounts(event);
        }
    }

    private void clearCacheLine(ApplicationKey key) {
        log.debug("Clearing the cache line {}.", (Object)key);
        if (!ApplicationKeys.CORE.equals((Object)key)) {
            this.appRoleCache.remove((Object)ApplicationKeys.CORE);
            this.activeUsersCountForLicense.remove((Object)ApplicationKeys.CORE);
        }
        this.appRoleCache.remove((Object)key);
        this.activeUsersCountForLicense.remove((Object)key);
        this.flushBillableUsersCache();
    }

    private static Iterable<String> groupNames(Collection<Group> groups) {
        return (Iterable)groups.stream().map(Group::getName).collect(CollectorsUtil.toImmutableSet());
    }

    private void dontUseRolesWhenFeatureFlagNotEnabled() {
        if (!this.rolesEnabled()) {
            throw new UnsupportedOperationException("ApplicationRoles are not enabled; see #rolesEnabled");
        }
    }

    private GlobalPermissionManager getGlobalPermissionManager() {
        GlobalPermissionManager temp = this.globalPermissionManager;
        if (temp == null) {
            this.globalPermissionManager = temp = (GlobalPermissionManager)ComponentAccessor.getComponent(GlobalPermissionManager.class);
        }
        return temp;
    }

    private boolean isConnectUser(@Nonnull ApplicationUser user) {
        return this.hasConnectAttributes(user) || this.isConnectUserInConnectGroup(user);
    }

    private boolean hasConnectAttributes(@Nonnull ApplicationUser user) {
        boolean hasConnectAttribute;
        UserWithAttributes userWithAttributes = this.crowdService.getUserWithAttributes(user.getUsername());
        return userWithAttributes != null && (hasConnectAttribute = userWithAttributes.getKeys().stream().filter(key -> CONNECT_USER_ATTRIBUTE_PATTERN.matcher((CharSequence)key).matches()).anyMatch(key -> "true".equals(userWithAttributes.getValue(key))));
    }

    private boolean isConnectUserInConnectGroup(@Nonnull ApplicationUser user) {
        if (user.getName().startsWith("addon_")) {
            Collection groupsForUser = this.groupManager.getGroupsForUser(user);
            return Iterables.any((Iterable)groupsForUser, group -> "atlassian-addons".equals(group.getName()));
        }
        return false;
    }

    private final class BillableUserCountLoader
    implements Supplier<Integer> {
        private BillableUserCountLoader() {
        }

        public Integer get() {
            Set<Group> groupsThatGrantUserAccess = this.getGroupsThatGrantUserAccess();
            HashSet allUsers = new HashSet();
            boolean isOnDemand = DefaultApplicationRoleManager.this.featureManager.isOnDemand();
            for (Group group : groupsThatGrantUserAccess) {
                Collection users = DefaultApplicationRoleManager.this.groupManager.getUsersInGroup(group);
                Set collect = StreamSupport.stream(users.spliterator(), false).filter(user -> user.isActive() && (!isOnDemand || !DefaultApplicationRoleManager.this.getGlobalPermissionManager().hasPermission(GlobalPermissionKey.SYSTEM_ADMIN, user)) && !DefaultApplicationRoleManager.this.isConnectUser(user)).map(user -> IdentifierUtils.toLowerCase((String)user.getUsername())).collect(Collectors.toSet());
                allUsers.addAll(collect);
            }
            return allUsers.size();
        }

        private Set<Group> getGroupsThatGrantUserAccess() {
            if (DefaultApplicationRoleManager.this.rolesEnabled()) {
                return DefaultApplicationRoleManager.this.getGroupsForLicensedRoles();
            }
            HashSet<Group> groupsWithUsePermission = new HashSet<Group>();
            groupsWithUsePermission.addAll(DefaultApplicationRoleManager.this.getGlobalPermissionManager().getGroupsWithPermission(GlobalPermissionKey.USE));
            groupsWithUsePermission.addAll(DefaultApplicationRoleManager.this.getGlobalPermissionManager().getGroupsWithPermission(GlobalPermissionKey.ADMINISTER));
            groupsWithUsePermission.addAll(DefaultApplicationRoleManager.this.getGlobalPermissionManager().getGroupsWithPermission(GlobalPermissionKey.SYSTEM_ADMIN));
            return groupsWithUsePermission;
        }
    }

    private class ActiveUserCountLoader
    implements CacheLoader<ApplicationKey, Integer> {
        private ActiveUserCountLoader() {
        }

        @Nonnull
        public Integer load(@Nonnull ApplicationKey key) {
            boolean isOnDemand = DefaultApplicationRoleManager.this.featureManager.isOnDemand();
            return (Integer)DefaultApplicationRoleManager.this.getRole(key).map(role -> {
                HashSet users = Sets.newHashSet();
                for (Group group : role.getGroups()) {
                    users.addAll(DefaultApplicationRoleManager.this.groupManager.getUsersInGroup(group).stream().filter(user -> user.isActive() && (!isOnDemand || !DefaultApplicationRoleManager.this.getGlobalPermissionManager().hasPermission(GlobalPermissionKey.SYSTEM_ADMIN, user)) && !DefaultApplicationRoleManager.this.isConnectUser(user)).collect(Collectors.toList()));
                }
                if (ApplicationKeys.CORE.equals((Object)key)) {
                    DefaultApplicationRoleManager.this.getRoles().stream().filter(appRole -> !appRole.getKey().equals((Object)ApplicationKeys.CORE)).flatMap(appRole -> appRole.getGroups().stream()).map(arg_0 -> ((GroupManager)DefaultApplicationRoleManager.this.groupManager).getUsersInGroup(arg_0)).forEach(users::removeAll);
                }
                return users.size();
            }).getOrElse((Object)0);
        }
    }

    private class RoleLoader
    implements CacheLoader<ApplicationKey, Option<ApplicationRole>> {
        private RoleLoader() {
        }

        @Nonnull
        public Option<ApplicationRole> load(@Nonnull ApplicationKey key) {
            if (!DefaultApplicationRoleManager.this.rolesEnabled()) {
                return Option.none();
            }
            return DefaultApplicationRoleManager.this.definitions.getLicensed(key).map(appDef -> {
                ApplicationRoleStore.ApplicationRoleData applicationRoleData = DefaultApplicationRoleManager.this.applicationRoleStore.get(key);
                Set realGroups = (Set)applicationRoleData.getGroups().stream().map(arg_0 -> ((GroupManager)DefaultApplicationRoleManager.this.groupManager).getGroup(arg_0)).filter(Objects::nonNull).collect(CollectorsUtil.toImmutableSet());
                Set defaultGroups = (Set)applicationRoleData.getDefaultGroups().stream().map(arg_0 -> ((GroupManager)DefaultApplicationRoleManager.this.groupManager).getGroup(arg_0)).filter(Objects::nonNull).filter(realGroups::contains).collect(CollectorsUtil.toImmutableSet());
                boolean defined = DefaultApplicationRoleManager.this.definitions.isDefined(key);
                return new DefinitionApplicationRole((ApplicationRoleDefinitions.ApplicationRoleDefinition)appDef, realGroups, defaultGroups, DefaultApplicationRoleManager.this.getNumberOfSeatsGrantedToRole(key), applicationRoleData.isSelectedByDefault(), defined);
            });
        }
    }
}

