/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.workflow.validator;

import com.atlassian.fugue.Option;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.permission.ProjectPermission;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.plugin.ProjectPermissionKey;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.workflow.WorkflowDescriptorUtil;
import com.google.common.annotations.VisibleForTesting;
import com.opensymphony.workflow.InvalidInputException;
import com.opensymphony.workflow.Validator;
import java.util.Map;

public abstract class AbstractPermissionValidator
implements Validator {
    @VisibleForTesting
    void hasUserPermission(Map args, Map transientVars, ApplicationUser user) throws InvalidInputException {
        ProjectPermissionKey key = WorkflowDescriptorUtil.resolvePermissionKey(args);
        PermissionManager permissionManager = ComponentAccessor.getPermissionManager();
        Option permission = permissionManager.getProjectPermission(key);
        if (!permission.isDefined()) {
            return;
        }
        Issue issue = (Issue)transientVars.get("issue");
        if (!this.hasUserPermissionForIssue(issue, key, user, permissionManager)) {
            I18nHelper i18nHelper = ComponentAccessor.getJiraAuthenticationContext().getI18nHelper();
            String permissionName = i18nHelper.getText(((ProjectPermission)permission.get()).getNameI18nKey());
            throw new InvalidInputException("User '" + user.getUsername() + "' doesn't have the '" + permissionName + "' permission");
        }
    }

    @VisibleForTesting
    boolean hasUserPermissionForIssue(Issue issue, ProjectPermissionKey permissionKey, ApplicationUser user, PermissionManager permissionManager) throws InvalidInputException {
        if (issue.getGenericValue() != null) {
            return permissionManager.hasPermission(permissionKey, issue, user);
        }
        if (issue.getProjectObject() != null) {
            return permissionManager.hasPermission(permissionKey, issue.getProjectObject(), user);
        }
        throw new InvalidInputException("Invalid project specified.");
    }
}

