/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.workflow.function.issue;

import com.atlassian.jira.issue.MutableIssue;
import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.workflow.FunctionProvider;
import com.opensymphony.workflow.loader.DescriptorFactory;
import com.opensymphony.workflow.loader.FunctionDescriptor;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IssueStoreFunction
implements FunctionProvider {
    private static final Logger log = LoggerFactory.getLogger(IssueStoreFunction.class);

    public void execute(Map transientVars, Map args, PropertySet ps) {
        MutableIssue issue = (MutableIssue)transientVars.get("issue");
        if (issue == null) {
            log.warn("Issue is null - cannot store.");
            return;
        }
        try {
            issue.store();
        }
        catch (Exception e) {
            log.error("An exception occurred", (Throwable)e);
        }
    }

    public static FunctionDescriptor makeDescriptor() {
        FunctionDescriptor descriptor = DescriptorFactory.getFactory().createFunctionDescriptor();
        descriptor.setType("class");
        descriptor.getArgs().put("class.name", IssueStoreFunction.class.getName());
        return descriptor;
    }
}

