/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.workflow;

import com.atlassian.core.util.Clock;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.ofbiz.FieldMap;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.util.RealClock;
import com.atlassian.jira.workflow.DraftWorkflowSchemeStore;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowSchemeStateBuilderTemplate;
import com.atlassian.jira.workflow.WorkflowSchemeStoreSupport;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.sql.Timestamp;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.ofbiz.core.entity.EntityUtil;
import org.ofbiz.core.entity.GenericValue;

public class OfBizDraftWorkflowSchemeStore
implements DraftWorkflowSchemeStore {
    private final OfBizDelegator delegator;
    private final WorkflowSchemeStoreSupport<DraftWorkflowSchemeStore.DraftState> support;

    OfBizDraftWorkflowSchemeStore(OfBizDelegator delegator, Clock clock) {
        this.delegator = delegator;
        this.support = new WorkflowSchemeStoreSupport<DraftWorkflowSchemeStore.DraftState>(delegator, new SupportDelegate(delegator, clock));
    }

    public OfBizDraftWorkflowSchemeStore(OfBizDelegator delegator) {
        this(delegator, RealClock.getInstance());
    }

    @Override
    public DraftWorkflowSchemeStore.DraftState create(DraftWorkflowSchemeStore.DraftState state) {
        return this.support.create(state);
    }

    @Override
    public DraftWorkflowSchemeStore.DraftState update(DraftWorkflowSchemeStore.DraftState state) {
        return this.support.update(state);
    }

    @Override
    public boolean delete(long id) {
        return this.support.delete(id);
    }

    @Override
    public boolean delete(DraftWorkflowSchemeStore.DraftState state) {
        return this.support.delete(state);
    }

    @Override
    public boolean deleteByParentId(long parentId) {
        GenericValue schemeGvFromParent = this.findSchemeGvFromParent(parentId);
        return schemeGvFromParent != null && this.delete(schemeGvFromParent.getLong("id"));
    }

    @Override
    public boolean hasDraftForParent(long parentId) {
        return this.findSchemeGvFromParent(parentId) != null;
    }

    @Override
    public DraftWorkflowSchemeStore.DraftState getDraftForParent(long parentId) {
        return this.support.createStateFrom(this.findSchemeGvFromParent(parentId));
    }

    @Override
    public DraftWorkflowSchemeStore.DraftState get(long id) {
        GenericValue schemeGv = this.getGenericValue(id);
        return this.support.createStateFrom(schemeGv);
    }

    private GenericValue getGenericValue(long id) {
        return this.delegator.findByPrimaryKey("DraftWorkflowScheme", Long.valueOf(id));
    }

    @Override
    public Iterable<DraftWorkflowSchemeStore.DraftState> getAll() {
        return this.support.getAll();
    }

    @Override
    public DraftWorkflowSchemeStore.DraftState.Builder builder(long parentId) {
        return new DefaultWorkflowSchemeStateBuilder(parentId);
    }

    @Override
    public boolean renameWorkflow(String oldName, String newName) {
        return this.support.renameWorkflow(oldName, newName);
    }

    @Override
    public Long getParentId(long id) {
        GenericValue draftValue = this.getGenericValue(id);
        return draftValue != null ? draftValue.getLong("workflowSchemeId") : null;
    }

    @Override
    public Iterable<DraftWorkflowSchemeStore.DraftState> getSchemesUsingWorkflow(JiraWorkflow workflow) {
        return this.support.getSchemesUsingWorkflow(workflow);
    }

    private GenericValue findSchemeGvFromParent(long id) {
        List byAnd = this.delegator.findByAnd("DraftWorkflowScheme", (Map)ImmutableMap.of((Object)"workflowSchemeId", (Object)id), Collections.singletonList("id"));
        return EntityUtil.getFirst((List)byAnd);
    }

    static class SupportDelegate
    implements WorkflowSchemeStoreSupport.Delegate<DraftWorkflowSchemeStore.DraftState> {
        private final OfBizDelegator delegator;
        private final Clock clock;

        SupportDelegate(OfBizDelegator delegator, Clock clock) {
            this.delegator = delegator;
            this.clock = clock;
        }

        @Override
        public String schemeTable() {
            return "DraftWorkflowScheme";
        }

        @Override
        public String entityTable() {
            return "DraftWorkflowSchemeEntity";
        }

        @Override
        public String schemeToEntityRelationship() {
            return "ChildDraftWorkflowSchemeEntity";
        }

        @Override
        public GenericValue create(DraftWorkflowSchemeStore.DraftState state) {
            FieldMap fieldMap = FieldMap.build((String)"workflowSchemeId", (Object)state.getParentSchemeId());
            fieldMap.add("lastModifiedDate", (Object)this.currentDate());
            fieldMap.add("lastModifiedUser", (Object)state.getLastModifiedUser());
            return this.delegator.createValue("DraftWorkflowScheme", (Map)fieldMap);
        }

        @Override
        public void update(DraftWorkflowSchemeStore.DraftState state, GenericValue schemeGv) {
            Long parentId = schemeGv.getLong("workflowSchemeId");
            if (parentId == null || !parentId.equals(state.getParentSchemeId())) {
                throw new DataAccessException("Trying to change the parent of a draft.");
            }
            schemeGv.set("lastModifiedDate", (Object)this.currentDate());
            schemeGv.set("lastModifiedUser", (Object)state.getLastModifiedUser());
            this.delegator.store(schemeGv);
        }

        @Override
        public DraftWorkflowSchemeStore.DraftState get(GenericValue schemeGv, Map<String, String> map) {
            Long id = schemeGv.getLong("id");
            Long parentId = schemeGv.getLong("workflowSchemeId");
            String user = schemeGv.getString("lastModifiedUser");
            Timestamp timestamp = schemeGv.getTimestamp("lastModifiedDate");
            Date lastModified = timestamp != null ? new Date(timestamp.getTime()) : new Date(0L);
            return new DraftWorkflowSchemeStateImpl(id, parentId, map, lastModified, user);
        }

        private Timestamp currentDate() {
            return new Timestamp(this.clock.getCurrentDate().getTime());
        }
    }

    private static class DraftWorkflowSchemeStateImpl
    implements DraftWorkflowSchemeStore.DraftState {
        private final Long id;
        private final long parentSchemeId;
        private final Date lastModifiedDate;
        private final String lastModifiedUser;
        private final Map<String, String> issueTypeToWorkflow;

        private DraftWorkflowSchemeStateImpl(Long id, long parentSchemeId, Map<String, String> issueTypeToWorkflow, Date lastModifiedDate, String lastModifiedUser) {
            this.id = id;
            this.parentSchemeId = parentSchemeId;
            this.lastModifiedDate = lastModifiedDate;
            this.lastModifiedUser = lastModifiedUser;
            this.issueTypeToWorkflow = Collections.unmodifiableMap(Maps.newHashMap(issueTypeToWorkflow));
        }

        @Override
        public long getParentSchemeId() {
            return this.parentSchemeId;
        }

        @Override
        public Long getId() {
            return this.id;
        }

        @Override
        public Map<String, String> getMappings() {
            return this.issueTypeToWorkflow;
        }

        @Override
        public String getDefaultWorkflow() {
            return this.issueTypeToWorkflow.get(null);
        }

        @Override
        public Date getLastModifiedDate() {
            return this.lastModifiedDate;
        }

        @Override
        public String getLastModifiedUser() {
            return this.lastModifiedUser;
        }

        @Override
        public DefaultWorkflowSchemeStateBuilder builder() {
            return new DefaultWorkflowSchemeStateBuilder(this);
        }
    }

    private static class DefaultWorkflowSchemeStateBuilder
    extends WorkflowSchemeStateBuilderTemplate<DraftWorkflowSchemeStore.DraftState.Builder>
    implements DraftWorkflowSchemeStore.DraftState.Builder {
        private final long parentId;
        private String lastModifiedUser;
        private Date lastModifiedDate;

        DefaultWorkflowSchemeStateBuilder(long parentId) {
            this.parentId = parentId;
        }

        DefaultWorkflowSchemeStateBuilder(DraftWorkflowSchemeStore.DraftState state) {
            super(state);
            this.parentId = state.getParentSchemeId();
            this.lastModifiedDate = state.getLastModifiedDate();
            this.lastModifiedUser = state.getLastModifiedUser();
        }

        @Override
        public long getParentSchemeId() {
            return this.parentId;
        }

        @Override
        DraftWorkflowSchemeStore.DraftState.Builder getThis() {
            return this;
        }

        @Override
        public String getLastModifiedUser() {
            return this.lastModifiedUser;
        }

        @Override
        public DraftWorkflowSchemeStore.DraftState.Builder setLastModifiedUser(String user) {
            this.lastModifiedUser = user;
            return this;
        }

        @Override
        public Date getLastModifiedDate() {
            return this.lastModifiedDate;
        }

        @Override
        public DraftWorkflowSchemeStore.DraftState build() {
            return new DraftWorkflowSchemeStateImpl(this.getId(), this.parentId, this.getMappings(), this.lastModifiedDate, this.lastModifiedUser);
        }
    }

    private static class EntityTable {
        private static final String ENTITY = "DraftWorkflowSchemeEntity";

        private EntityTable() {
        }
    }

    private static class SchemeTable {
        private static final String ENTITY = "DraftWorkflowScheme";
        private static final String ENTITY_RELATIONSHIP = "ChildDraftWorkflowSchemeEntity";

        private SchemeTable() {
        }

        private static class Columns {
            private static final String ID = "id";
            private static final String PARENT = "workflowSchemeId";
            private static final String UPDATED_DATE = "lastModifiedDate";
            private static final String UPDATED_USER = "lastModifiedUser";

            private Columns() {
            }
        }
    }
}

