/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.servlet;

import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.avatar.TypeAvatarService;
import com.atlassian.jira.avatar.UniversalAvatarsService;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.web.servlet.AvatarToStream;
import java.io.IOException;
import java.util.NoSuchElementException;
import javax.annotation.Nonnull;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ViewUniversalAvatarServletImpl {
    public static final String AVATAR_ID_PARAM = "avatarId";
    public static final String AVATAR_TYPE_PARAM = "avatarType";
    public static final String AVATAR_SIZE_PARAM = "size";
    private final JiraAuthenticationContext authenticationContext;
    private final UniversalAvatarsService avatars;
    private final AvatarToStream avatarToStream;

    public ViewUniversalAvatarServletImpl(JiraAuthenticationContext authenticationContext, UniversalAvatarsService avatars, AvatarToStream avatarToStream) {
        this.authenticationContext = authenticationContext;
        this.avatars = avatars;
        this.avatarToStream = avatarToStream;
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        try {
            Avatar avatar = this.getAvatar(request);
            Avatar.Size size = this.getValidAvatarSize(request);
            this.avatarToStream.sendAvatar(avatar, size, response);
        }
        catch (IllegalArgumentException iae) {
            response.sendError(404, iae.getMessage());
        }
    }

    @Nonnull
    private Avatar getAvatar(HttpServletRequest request) {
        ApplicationUser user = this.authenticationContext.getUser();
        long avatarId = this.getValidAvatarId(request);
        Avatar.Type avatarType = this.getValidAvatarType(request);
        TypeAvatarService avatarsForType = this.avatars.getAvatars(avatarType);
        if (null == avatarsForType) {
            throw new IllegalArgumentException("Avatar type: " + avatarType);
        }
        Avatar avatar = avatarsForType.getAvatar(user, avatarId);
        if (null == avatar) {
            avatar = avatarsForType.getDefaultAvatar();
        }
        return avatar;
    }

    private long getValidAvatarId(HttpServletRequest request) {
        String avatarIdSpec = request.getParameter(AVATAR_ID_PARAM);
        if (null == avatarIdSpec) {
            throw new IllegalArgumentException(AVATAR_ID_PARAM);
        }
        try {
            return Long.valueOf(avatarIdSpec);
        }
        catch (NumberFormatException x) {
            throw new IllegalArgumentException(AVATAR_ID_PARAM, x);
        }
    }

    private Avatar.Type getValidAvatarType(HttpServletRequest request) {
        String avatarTypeSpec = request.getParameter(AVATAR_TYPE_PARAM);
        Avatar.Type type = Avatar.Type.getByName((String)avatarTypeSpec);
        if (null == type) {
            throw new IllegalArgumentException(AVATAR_TYPE_PARAM);
        }
        return type;
    }

    private Avatar.Size getValidAvatarSize(HttpServletRequest request) {
        String avatarSizeSpec = request.getParameter(AVATAR_SIZE_PARAM);
        if (null == avatarSizeSpec) {
            return Avatar.Size.defaultSize();
        }
        try {
            return Avatar.Size.getSizeFromParam((String)avatarSizeSpec);
        }
        catch (NoSuchElementException x) {
            throw new IllegalArgumentException(AVATAR_SIZE_PARAM, x);
        }
    }
}

