/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.servlet;

import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.web.servlet.AbstractAvatarServlet;
import java.io.IOException;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;

public class ViewProjectAvatarServlet
extends AbstractAvatarServlet {
    @Override
    protected Long validateInput(String projectId, Long avatarId, HttpServletResponse response) throws IOException {
        if (StringUtils.isBlank((String)projectId)) {
            return this.getAvatarManager().getDefaultAvatarId(Avatar.Type.PROJECT);
        }
        Project project = this.getProjectManager().getProjectObj(Long.valueOf(Long.parseLong(projectId)));
        if (project == null) {
            response.sendError(404, "Unknown project");
            return null;
        }
        if (!this.getAvatarManager().hasPermissionToView(this.getAuthenticationContext().getUser(), project)) {
            response.sendError(403, "Unknown project");
            return null;
        }
        if (avatarId == null) {
            return project.getAvatar().getId();
        }
        return avatarId;
    }

    @Override
    protected String getOwnerIdParamName() {
        return "pid";
    }

    JiraAuthenticationContext getAuthenticationContext() {
        return ComponentAccessor.getJiraAuthenticationContext();
    }

    ProjectManager getProjectManager() {
        return ComponentAccessor.getProjectManager();
    }
}

