/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.servlet;

import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.avatar.AvatarManager;
import com.atlassian.jira.util.Consumer;
import com.atlassian.jira.util.StreamCopyingConsumer;
import com.atlassian.jira.web.servlet.HttpResponseHeaders;
import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;

public class AvatarToStream {
    private static final int AVATAR_BUFFER_SIZE = 4096;
    private final AvatarManager avatarManager;

    public AvatarToStream(AvatarManager avatarManager) {
        this.avatarManager = avatarManager;
    }

    public void sendAvatar(Avatar avatar, Avatar.Size size, HttpServletResponse response) throws IOException {
        response.setContentType(AvatarManager.AVATAR_IMAGE_FORMAT_FULL.getContentType());
        HttpResponseHeaders.cachePrivatelyForAboutOneYear(response);
        ServletOutputStream out = response.getOutputStream();
        StreamCopyingConsumer streamCopier = new StreamCopyingConsumer((OutputStream)out, 4096);
        AvatarManager.ImageSize avatarSize = AvatarManager.ImageSize.fromSize((Avatar.Size)size);
        this.avatarManager.readAvatarData(avatar, avatarSize, (Consumer)streamCopier);
    }
}

