/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.filters.accesslog;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.zip.CRC32;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtlassianSessionIdUtil {
    public static final String ASESSIONID_NAME = "ASESSIONID";
    public static final String JSESSIONID_NAME = "JSESSIONID";
    private static final Logger log = LoggerFactory.getLogger(AtlassianSessionIdUtil.class);

    public static String generateAtlassianSessionHash(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        HttpSession session = httpServletRequest.getSession(false);
        if (session == null) {
            return null;
        }
        String ASESSIONID = (String)session.getAttribute(ASESSIONID_NAME);
        if (ASESSIONID == null) {
            ASESSIONID = AtlassianSessionIdUtil.generateNewASESSIONID(session);
        }
        return AtlassianSessionIdUtil.getDigestEncodedValue(ASESSIONID);
    }

    private static String generateNewASESSIONID(HttpSession session) {
        String sessionId = session.getId();
        String ASESSIONID = AtlassianSessionIdUtil.generateASESSIONID(sessionId);
        if (ASESSIONID == null) {
            if (log.isDebugEnabled()) {
                log.debug("Session with id '" + sessionId + "' generated a null hash. Not setting ASESSIONID cookie or header.");
            }
            return null;
        }
        String sessionIdHex = AtlassianSessionIdUtil.smartHexEncode(sessionId, AtlassianSessionIdUtil.getinUTF8(sessionId));
        ASESSIONID = ASESSIONID + '-' + sessionIdHex;
        session.setAttribute(ASESSIONID_NAME, (Object)ASESSIONID);
        return ASESSIONID;
    }

    public static String generateASESSIONID(String sessionId) {
        if (sessionId == null) {
            return null;
        }
        byte[] bytes = AtlassianSessionIdUtil.getinUTF8(sessionId);
        MessageDigest md = AtlassianSessionIdUtil.getMessageDigest("SHA");
        if (md == null) {
            md = AtlassianSessionIdUtil.getMessageDigest("MD5");
        }
        if (md == null) {
            return null;
        }
        md.update(bytes);
        byte[] digest = md.digest();
        return AtlassianSessionIdUtil.encode(digest);
    }

    private static String getDigestEncodedValue(String asessionId) {
        if (StringUtils.isBlank((String)asessionId)) {
            return null;
        }
        int index = asessionId.lastIndexOf(45);
        if (index == -1 || index == 0) {
            return null;
        }
        return asessionId.substring(0, index);
    }

    private static byte[] getinUTF8(String sessionId) {
        byte[] input = null;
        try {
            input = sessionId.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return input;
    }

    private static String smartHexEncode(String sessionId, byte[] bytes) {
        boolean isAllHex = true;
        for (char c : sessionId.toCharArray()) {
            if (AtlassianSessionIdUtil.isHex(c)) continue;
            isAllHex = false;
            break;
        }
        if (isAllHex) {
            return sessionId;
        }
        StringBuilder sb = new StringBuilder();
        for (byte aByte : bytes) {
            sb.append(Integer.toHexString(aByte));
        }
        return sb.toString();
    }

    private static boolean isHex(char c) {
        return c >= '0' && c <= '9' || c >= 'A' && c <= 'F' || c >= 'a' && c <= 'f';
    }

    private static String encode(byte[] bytes) {
        CRC32 crc32 = new CRC32();
        crc32.update(bytes);
        return Long.toString(crc32.getValue(), 36);
    }

    private static MessageDigest getMessageDigest(String digestName) {
        try {
            return MessageDigest.getInstance(digestName);
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
    }
}

