/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.component.subtask;

import com.atlassian.jira.bean.SubTask;
import com.atlassian.jira.bean.SubTaskBean;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.JiraWebUtils;
import com.atlassian.jira.web.component.SimpleColumnLayoutItem;
import java.util.Collection;
import java.util.Map;

public class SubTaskReorderColumnLayoutItem
extends SimpleColumnLayoutItem {
    int displaySequence = 0;
    private final String contextPath = JiraWebUtils.getHttpRequest().getContextPath();
    final Collection subTasks;
    private final SubTaskBean subTaskBean;
    private final String subTaskView;
    private final I18nHelper i18n;
    private final boolean allowedReorderSubTasks;
    private final Issue parentIssue;

    public SubTaskReorderColumnLayoutItem(PermissionManager permissionManager, SubTaskBean subTaskBean, String subTaskView, Issue parentIssue, ApplicationUser user, I18nHelper i18n) {
        this.subTaskBean = subTaskBean;
        this.subTaskView = subTaskView;
        this.i18n = i18n;
        this.allowedReorderSubTasks = permissionManager.hasPermission(12, parentIssue, user);
        this.parentIssue = parentIssue;
        this.subTasks = subTaskBean.getSubTasks(subTaskView);
    }

    @Override
    protected String getColumnCssClass() {
        return "streorder";
    }

    @Override
    public String getHtml(Map displayParams, Issue issue) {
        ++this.displaySequence;
        StringBuilder html = new StringBuilder();
        html.append("<div class=\"subtask-reorder\">");
        if (this.allowedReorderSubTasks) {
            Long subtaskSequence = this.getCurrentSubTaskSequence(issue, this.subTasks);
            if (this.displaySequence != 1) {
                html.append("<a href=\"").append(this.contextPath).append("/secure/MoveIssueLink.jspa?id=").append(this.parentIssue.getId()).append("&currentSubTaskSequence=").append(subtaskSequence).append("&subTaskSequence=").append(this.subTaskBean.getPreviousSequence(subtaskSequence, this.subTaskView)).append("\" title=\"").append(this.i18n.getText("admin.workflowdescriptor.move.up")).append("\"><span class=\"icon-default aui-icon aui-icon-small aui-iconfont-up\">").append(this.i18n.getText("admin.workflowdescriptor.move.up")).append("</span></a>");
            } else {
                html.append("<img src=\"").append(this.contextPath).append("/images/border/spacer.gif\" class=\"sortArrow\" alt=\"\" />");
            }
            if (this.displaySequence != this.subTasks.size()) {
                html.append("<a href=\"").append(this.contextPath).append("/secure/MoveIssueLink.jspa?id=").append(this.parentIssue.getId()).append("&currentSubTaskSequence=").append(subtaskSequence).append("&subTaskSequence=").append(this.subTaskBean.getNextSequence(subtaskSequence, this.subTaskView)).append("\" title=\"").append(this.i18n.getText("admin.workflowdescriptor.move.down")).append("\"><span class=\"icon-default aui-icon aui-icon-small aui-iconfont-down\">").append(this.i18n.getText("admin.workflowdescriptor.move.down")).append("</span></a>");
            } else {
                html.append("<img src=\"").append(this.contextPath).append("/images/border/spacer.gif\" class=\"sortArrow\" alt=\"\" />");
            }
        } else {
            html.append("&nbsp;");
        }
        html.append("</div>");
        return html.toString();
    }

    private Long getCurrentSubTaskSequence(Issue issue, Collection subTasks) {
        for (Object subTask1 : subTasks) {
            SubTask subTask = (SubTask)subTask1;
            if (!subTask.getSubTask().equals((Object)issue)) continue;
            return subTask.getSequence();
        }
        return new Long(-1L);
    }
}

