/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.component;

import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.bean.SubTaskBean;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.FieldException;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.NavigableField;
import com.atlassian.jira.issue.fields.layout.column.ColumnLayoutItem;
import com.atlassian.jira.issue.fields.layout.column.ColumnLayoutStorageException;
import com.atlassian.jira.issue.fields.layout.column.ExcelColumnLayoutItem;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.issue.search.util.SearchSortUtil;
import com.atlassian.jira.jql.context.QueryContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.preferences.UserPreferencesManager;
import com.atlassian.jira.web.component.ColumnLayoutItemProvider;
import com.atlassian.jira.web.component.IssueTableLayoutBean;
import com.atlassian.jira.web.component.TableLayoutUtils;
import com.atlassian.jira.web.component.subtask.ColumnLayoutItemFactory;
import com.atlassian.query.Query;
import com.atlassian.query.order.SearchSort;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Transformer;

public class TableLayoutFactory {
    private final FieldManager fieldManager;
    private final TableLayoutUtils tableLayoutUtils;
    private final ColumnLayoutItemFactory columnLayoutItemFactory;
    private final UserPreferencesManager userPreferencesManager;
    private final SearchService searchService;
    private final SearchSortUtil searchSortUtil;

    public TableLayoutFactory(FieldManager fieldManager, TableLayoutUtils tableLayoutUtils, ColumnLayoutItemFactory columnLayoutItemFactory, UserPreferencesManager userPreferencesManager, SearchService searchService, SearchSortUtil searchSortUtil) {
        this.fieldManager = fieldManager;
        this.tableLayoutUtils = tableLayoutUtils;
        this.columnLayoutItemFactory = columnLayoutItemFactory;
        this.userPreferencesManager = userPreferencesManager;
        this.searchService = searchService;
        this.searchSortUtil = searchSortUtil;
    }

    public IssueTableLayoutBean getStandardLayout(SearchRequest searchRequest, ApplicationUser user) {
        IssueTableLayoutBean layoutBean = new IssueTableLayoutBean(this.getUserColumns(searchRequest, user), this.getSearchSorts(searchRequest));
        if (user != null) {
            layoutBean.setShowActionColumn(true);
        }
        return layoutBean;
    }

    public IssueTableLayoutBean getDashboardLayout(ApplicationUser user, List<String> columnNames) throws FieldException {
        IssueTableLayoutBean layout = new IssueTableLayoutBean(this.getDashboardColumns(user, columnNames));
        layout.setSortingEnabled(false);
        layout.setDisplayHeader(false);
        layout.setShowExteriorTable(false);
        layout.setTableCssClass("grid issuetable-db maxWidth");
        return layout;
    }

    private List<ColumnLayoutItem> getDashboardColumns(ApplicationUser user, List<String> columnNames) throws FieldException {
        if (columnNames == null || columnNames.isEmpty()) {
            columnNames = this.tableLayoutUtils.getDefaultColumnNames("jira.table.cols.dashboard");
        }
        return this.tableLayoutUtils.getColumns(user, columnNames);
    }

    public IssueTableLayoutBean getPrintableLayout(SearchRequest searchRequest, ApplicationUser user) {
        IssueTableLayoutBean layout = new IssueTableLayoutBean(this.getUserColumns(searchRequest, user), this.getSearchSorts(searchRequest));
        layout.setSortingEnabled(false);
        layout.addCellDisplayParam("print_view", (Object)Boolean.TRUE);
        return layout;
    }

    public IssueTableLayoutBean getStandardExcelLayout(SearchRequest searchRequest, ApplicationUser user) {
        IssueTableLayoutBean standardLayout = new IssueTableLayoutBean(this.getExcelUserColumns(searchRequest, user), this.getSearchSorts(searchRequest));
        this.setExcelLayout(standardLayout);
        return standardLayout;
    }

    public IssueTableLayoutBean getAllColumnsExcelLayout(SearchRequest searchRequest, ApplicationUser user) {
        IssueTableLayoutBean standardLayout = new IssueTableLayoutBean(this.getAllUserExcelColumns(searchRequest, user), this.getSearchSorts(searchRequest));
        this.setExcelLayout(standardLayout);
        return standardLayout;
    }

    public IssueTableLayoutBean getSubTaskIssuesLayout(ApplicationUser user, Issue parentIssue, SubTaskBean subTaskBean, String subTaskView, boolean timeTrackingData) throws ColumnLayoutStorageException, FieldException {
        ArrayList userSpecifiedColumns = this.tableLayoutUtils.getDefaultColumnNames("jira.table.cols.subtasks");
        if (!timeTrackingData && userSpecifiedColumns != null) {
            userSpecifiedColumns = new ArrayList(userSpecifiedColumns);
            userSpecifiedColumns.remove("progress");
        }
        ColumnLayoutItem displaySequence = this.columnLayoutItemFactory.getSubTaskDisplaySequenceColumn();
        ColumnLayoutItem simpleSummary = this.columnLayoutItemFactory.getSubTaskSimpleSummaryColumn();
        ColumnLayoutItem subTaskReorder = this.columnLayoutItemFactory.getSubTaskReorderColumn(user, parentIssue, subTaskBean, subTaskView);
        ArrayList<ColumnLayoutItem> columns = new ArrayList<ColumnLayoutItem>();
        columns.add(displaySequence);
        columns.add(simpleSummary);
        columns.addAll(this.tableLayoutUtils.getColumns(user, userSpecifiedColumns));
        columns.add(subTaskReorder);
        IssueTableLayoutBean layout = new IssueTableLayoutBean(columns, Collections.emptyList());
        layout.setSortingEnabled(false);
        layout.setDisplayHeader(false);
        layout.setShowExteriorTable(false);
        layout.setTableCssClass("");
        layout.setShowActionColumn(true);
        return layout;
    }

    private void setExcelLayout(IssueTableLayoutBean layoutBean) {
        layoutBean.setSortingEnabled(false);
        layoutBean.setAlternateRowColors(false);
        layoutBean.addCellDisplayParam("nolink", (Object)Boolean.TRUE);
        layoutBean.addCellDisplayParam("textOnly", (Object)Boolean.TRUE);
        layoutBean.addCellDisplayParam("full_link", (Object)Boolean.TRUE);
        layoutBean.addCellDisplayParam("excel_view", (Object)Boolean.TRUE);
    }

    private List<SearchSort> getSearchSorts(SearchRequest searchRequest) {
        if (searchRequest != null) {
            return this.searchSortUtil.getSearchSorts(searchRequest.getQuery());
        }
        return null;
    }

    private List<ColumnLayoutItem> getAllUserExcelColumns(SearchRequest searchRequest, ApplicationUser user) {
        try {
            Set availableFields;
            Query query = searchRequest.getQuery();
            if (query.getWhereClause() == null) {
                availableFields = this.fieldManager.getAvailableNavigableFieldsWithScope(user);
            } else {
                QueryContext queryContext = this.searchService.getQueryContext(user, query);
                availableFields = this.fieldManager.getAvailableNavigableFieldsWithScope(user, queryContext);
            }
            ArrayList columnItems = Lists.newArrayListWithCapacity((int)availableFields.size());
            Iterator iterator = availableFields.iterator();
            while (iterator.hasNext()) {
                NavigableField field = (NavigableField)iterator.next();
                if (field instanceof CustomField) {
                    CustomField customField = (CustomField)field;
                    if (!customField.getCustomFieldType().getDescriptor().isViewTemplateExists() && !customField.getCustomFieldType().getDescriptor().isColumnViewTemplateExists()) {
                        iterator.remove();
                        continue;
                    }
                    columnItems.add(new ExcelColumnLayoutItem(field, columnItems.size()));
                    continue;
                }
                columnItems.add(new ExcelColumnLayoutItem(field, columnItems.size()));
            }
            return columnItems;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @VisibleForTesting
    List<ColumnLayoutItem> getUserColumns(SearchRequest searchRequest, ApplicationUser user) {
        if (searchRequest == null) {
            throw new NullPointerException("searchRequest cannot be null");
        }
        try {
            return this.getColumnsProvider().getColumns(user, searchRequest);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @VisibleForTesting
    ColumnLayoutItemProvider getColumnsProvider() {
        return new ColumnLayoutItemProvider();
    }

    private List<ColumnLayoutItem> getExcelUserColumns(SearchRequest searchRequest, ApplicationUser user) {
        ArrayList<ColumnLayoutItem> visibleColumns = new ArrayList<ColumnLayoutItem>(this.getUserColumns(searchRequest, user));
        CollectionUtils.transform(visibleColumns, (Transformer)new Transformer(){

            public Object transform(Object input) {
                return new ExcelColumnLayoutItem((ColumnLayoutItem)input);
            }
        });
        return visibleColumns;
    }
}

