/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.bean;

import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Query;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.query.entity.UserQuery;
import com.atlassian.crowd.search.query.entity.restriction.NullRestrictionImpl;
import com.atlassian.crowd.search.query.membership.MembershipQuery;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.comparator.UserNameComparator;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.ApplicationUsers;
import com.atlassian.jira.web.bean.FilterUtils;
import com.atlassian.jira.web.bean.PagerFilter;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;

public class UserBrowserFilter
extends PagerFilter<ApplicationUser> {
    public String emailFilter = null;
    public String userNameFilter = null;
    public String fullNameFilter = null;
    public String group = null;
    private final Locale userLocale;

    public UserBrowserFilter(Locale userLocale) {
        this.userLocale = userLocale;
    }

    public String getEmailFilter() {
        return this.emailFilter;
    }

    public void setEmailFilter(String emailFilter) {
        this.emailFilter = FilterUtils.verifyString(emailFilter);
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = FilterUtils.verifyString(group);
    }

    public String getUserNameFilter() {
        return this.userNameFilter;
    }

    public void setUserNameFilter(String userNameFilter) {
        this.userNameFilter = userNameFilter;
    }

    public String getFullNameFilter() {
        return this.fullNameFilter;
    }

    public void setFullNameFilter(String fullNameFilter) {
        this.fullNameFilter = fullNameFilter;
    }

    public List<ApplicationUser> getFilteredUsers() throws Exception {
        List<ApplicationUser> unfilteredUsers = ApplicationUsers.from(this.getUsersFilteredByGroup());
        if (this.userNameFilter == null && this.fullNameFilter == null && this.emailFilter == null) {
            return Lists.newArrayList(unfilteredUsers);
        }
        Iterable users = Iterables.filter(unfilteredUsers, (Predicate)new Predicate<ApplicationUser>(){

            public boolean apply(ApplicationUser user) {
                return UserBrowserFilter.this.isUserIncluded(user);
            }
        });
        ArrayList filteredUsers = Lists.newArrayList((Iterable)users);
        Collections.sort(filteredUsers, new UserNameComparator(this.userLocale));
        return filteredUsers;
    }

    private Iterable<User> getUsersFilteredByGroup() {
        CrowdService crowdService = (CrowdService)ComponentAccessor.getComponentOfType(CrowdService.class);
        if (this.group != null) {
            MembershipQuery membershipQuery = QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).childrenOf(EntityDescriptor.group()).withName(this.group).returningAtMost(-1);
            return crowdService.search((Query)membershipQuery);
        }
        UserQuery query = new UserQuery(User.class, (SearchRestriction)NullRestrictionImpl.INSTANCE, 0, -1);
        return crowdService.search((Query)query);
    }

    private boolean isUserIncluded(ApplicationUser user) {
        boolean included = true;
        included = this.includeBasedOnUserName(user, included);
        included &= this.includeBasedOnFullName(user, included);
        included &= this.includeBasedOnEmail(user, included);
        return included;
    }

    private boolean includeBasedOnUserName(ApplicationUser user, boolean included) {
        return this.userNameFilter == null ? included : this.includeBasedOnUserString(included, this.userNameFilter, user.getName());
    }

    private boolean includeBasedOnFullName(ApplicationUser user, boolean included) {
        return this.fullNameFilter == null ? included : this.includeBasedOnUserString(included, this.fullNameFilter, user.getDisplayName());
    }

    private boolean includeBasedOnEmail(ApplicationUser user, boolean included) {
        return this.emailFilter == null ? included : this.includeBasedOnUserString(included, this.emailFilter, user.getEmailAddress());
    }

    private boolean includeBasedOnUserString(boolean included, String filterValue, String userValue) {
        if (included && filterValue != null) {
            included = userValue != null && userValue.toLowerCase().indexOf(filterValue.toLowerCase()) >= 0;
        }
        return included;
    }
}

