/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.bean;

import com.atlassian.fugue.Option;
import com.atlassian.jira.bulkedit.BulkEditMultiSelectFieldOption;
import com.atlassian.jira.bulkedit.BulkEditMultiSelectFieldOptionAdd;
import com.atlassian.jira.bulkedit.BulkEditMultiSelectFieldOptionRemove;
import com.atlassian.jira.bulkedit.BulkEditMultiSelectFieldOptionRemoveAll;
import com.atlassian.jira.bulkedit.BulkEditMultiSelectFieldOptionReplace;
import com.atlassian.jira.issue.fields.OrderableField;
import com.atlassian.jira.web.bean.BulkEditMultiSelectFieldBean;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class BulkEditMultiSelectFieldBeanImpl
implements BulkEditMultiSelectFieldBean {
    public static final String CHANGE_MODE_FIELD_PREFIX = "change";
    public static final List<String> BULK_EDIT_FIELDS_WITH_CHANGE_MODE_SELECTION = ImmutableList.of((Object)"labels", (Object)"versions", (Object)"components", (Object)"fixVersions");
    public static final String ADD_ID = "add";
    public static final String REMOVE_ID = "remove";
    public static final String REPLACE_ID = "replace";
    public static final String REMOVEALL_ID = "removeall";
    public static final BulkEditMultiSelectFieldOption addOption = new BulkEditMultiSelectFieldOptionAdd();
    public static final BulkEditMultiSelectFieldOption replaceOption = new BulkEditMultiSelectFieldOptionReplace();
    public static final BulkEditMultiSelectFieldOption removeOption = new BulkEditMultiSelectFieldOptionRemove();
    public static final BulkEditMultiSelectFieldOption removeAllOption = new BulkEditMultiSelectFieldOptionRemoveAll();
    public static final Map<String, BulkEditMultiSelectFieldOption> multiSelectChangeModeOptions = ImmutableMap.of((Object)"add", (Object)addOption, (Object)"replace", (Object)replaceOption, (Object)"remove", (Object)removeOption, (Object)"removeall", (Object)removeAllOption);
    public Map<String, BulkEditMultiSelectFieldOption> changeModeOptions = Maps.newHashMap();

    public boolean isChangeModeSelectionAllowed(OrderableField field) {
        return BULK_EDIT_FIELDS_WITH_CHANGE_MODE_SELECTION.contains(field.getId());
    }

    public String getChangeModeFieldName(OrderableField field) {
        return CHANGE_MODE_FIELD_PREFIX + field.getId();
    }

    public void setChangeModeForField(OrderableField field, BulkEditMultiSelectFieldOption changeMode) throws IllegalArgumentException {
        if (!this.isChangeModeSelectionAllowed(field)) {
            throw new IllegalArgumentException("Field not supported for BulkEditMultiSelect change: " + field.getId());
        }
        this.changeModeOptions.put(field.getId(), changeMode);
    }

    public Option<BulkEditMultiSelectFieldOption> getChangeModeForField(OrderableField field) {
        if (this.isChangeModeSelectionAllowed(field)) {
            if (this.changeModeOptions.get(field.getId()) != null) {
                return Option.some((Object)this.changeModeOptions.get(field.getId()));
            }
            return Option.some((Object)this.getDefaultChangeModeOption());
        }
        return Option.none();
    }

    public void setChangeModeFromParams(OrderableField field, Map<String, String[]> params) throws IllegalArgumentException {
        String selectedOption;
        if (this.isChangeModeSelectionAllowed(field)) {
            String fieldName = this.getChangeModeFieldName(field);
            String[] selectedOptions = params.get(fieldName);
            selectedOption = null;
            if (selectedOptions != null) {
                for (String value : selectedOptions) {
                    if (this.getChangeModeOptionById(value) == null) continue;
                    selectedOption = value;
                }
                if (selectedOption == null) {
                    selectedOption = this.getDefaultChangeModeOption().getId();
                }
            } else {
                selectedOption = this.getDefaultChangeModeOption().getId();
            }
        } else {
            throw new IllegalArgumentException("Field not supported for BulkEditMultiSelect change: " + field.getId());
        }
        this.changeModeOptions.put(field.getId(), this.getChangeModeOptionById(selectedOption));
    }

    public Collection<BulkEditMultiSelectFieldOption> getChangeModeOptions() {
        return multiSelectChangeModeOptions.values();
    }

    public BulkEditMultiSelectFieldOption getDefaultChangeModeOption() {
        return multiSelectChangeModeOptions.get(ADD_ID);
    }

    public BulkEditMultiSelectFieldOption getChangeModeOptionById(String id) {
        return multiSelectChangeModeOptions.get(id);
    }

    public String getMultiSelectFieldActionDescription(OrderableField field) {
        Option<BulkEditMultiSelectFieldOption> option = this.getChangeModeForField(field);
        return option.isDefined() ? ((BulkEditMultiSelectFieldOption)option.get()).getDescriptionI18nKey() : "";
    }
}

