/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.user;

import com.atlassian.crowd.embedded.api.CrowdDirectoryService;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.user.UserPropertyManager;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.JiraUrlCodec;
import com.atlassian.jira.web.action.admin.user.UserProperty;
import com.opensymphony.module.propertyset.PropertySet;

public class DeleteUserProperty
extends UserProperty {
    private boolean confirm;

    public DeleteUserProperty(CrowdService crowdService, CrowdDirectoryService crowdDirectoryService, UserPropertyManager userPropertyManager, UserManager userManager) {
        super(crowdService, crowdDirectoryService, userPropertyManager, userManager);
    }

    @Override
    protected void doValidation() {
        if (this.getUser() == null) {
            this.addErrorMessage(this.getText("admin.errors.users.user.does.not.exist"));
        }
    }

    @Override
    @RequiresXsrfCheck
    protected String doExecute() throws Exception {
        if (this.confirm && !this.hasAnyErrors()) {
            String trueKey = this.getTrueKey();
            PropertySet ps = this.userPropertyManager.getPropertySet(this.getUser());
            if (ps.exists(trueKey)) {
                ps.remove(trueKey);
            }
        }
        return this.returnComplete("EditUserProperties.jspa?name=" + JiraUrlCodec.encode((String)this.getName()));
    }

    public boolean isConfirm() {
        return this.confirm;
    }

    public void setConfirm(boolean confirm) {
        this.confirm = confirm;
    }
}

