/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.statuses;

import com.atlassian.jira.bc.ServiceResult;
import com.atlassian.jira.bc.config.StatusService;
import com.atlassian.jira.issue.status.SimpleStatus;
import com.atlassian.jira.issue.status.SimpleStatusImpl;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.web.action.ActionViewData;
import com.atlassian.jira.web.action.admin.constants.AbstractDeleteConstant;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import java.util.Collection;

@WebSudoRequired
public class DeleteStatus
extends AbstractDeleteConstant<Status> {
    private final StatusService statusService;

    public DeleteStatus(StatusService statusService) {
        this.statusService = statusService;
    }

    @Override
    protected String getConstantEntityName() {
        return "Status";
    }

    @Override
    protected String getNiceConstantName() {
        return "status";
    }

    @Override
    protected String getIssueConstantField() {
        return "status";
    }

    @Override
    protected Status getConstant(String id) {
        return this.getConstantsManager().getStatusObject(id);
    }

    @Override
    protected String getRedirectPage() {
        return "ViewStatuses.jspa";
    }

    @Override
    protected Collection<Status> getConstants() {
        return this.getConstantsManager().getStatusObjects();
    }

    @Override
    protected void clearCaches() {
        this.getConstantsManager().refreshStatuses();
    }

    @Override
    protected void doValidation() {
        ServiceResult validationResult = this.statusService.validateRemoveStatus(this.getLoggedInUser(), this.getStatusObject());
        if (!validationResult.isValid()) {
            this.addErrorCollection(validationResult.getErrorCollection());
        }
    }

    private Status getStatusObject() {
        return this.statusService.getStatusById(this.getLoggedInUser(), this.id);
    }

    @ActionViewData(key="status")
    public SimpleStatus getStatusFormValues() {
        return new SimpleStatusImpl(this.getStatusObject());
    }

    @ActionViewData
    public Collection<String> getErrorMessages() {
        return super.getErrorMessages();
    }

    @ActionViewData
    public String getToken() {
        return super.getXsrfToken();
    }

    @Override
    @RequiresXsrfCheck
    protected String doExecute() throws Exception {
        if (this.confirm) {
            this.statusService.removeStatus(this.getLoggedInUser(), this.getStatusObject());
        }
        if (this.getHasErrorMessages()) {
            return "error";
        }
        return this.returnCompleteWithInlineRedirect(this.getRedirectPage());
    }
}

