/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.priorities;

import com.atlassian.jira.config.PriorityManager;
import com.atlassian.jira.issue.priority.Priority;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.web.action.admin.constants.AbstractViewConstants;
import com.atlassian.jira.web.action.admin.translation.TranslationManager;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import java.util.Collection;
import org.apache.commons.lang.StringUtils;
import org.ofbiz.core.entity.GenericEntityException;

@WebSudoRequired
public class ViewPriorities
extends AbstractViewConstants<Priority> {
    private boolean preview = false;
    private String statusColor;
    private final PriorityManager priorityManager;

    public ViewPriorities(TranslationManager translationManager, PriorityManager priorityManager) {
        super(translationManager);
        this.priorityManager = priorityManager;
    }

    @Override
    protected String getConstantEntityName() {
        return "Priority";
    }

    @Override
    protected String getNiceConstantName() {
        return this.getText("admin.issue.constant.priority.lowercase");
    }

    @Override
    protected String getIssueConstantField() {
        return "priority";
    }

    @Override
    protected Priority getConstant(String id) {
        return this.getConstantsManager().getPriorityObject(id);
    }

    @Override
    protected String getRedirectPage() {
        return "ViewPriorities.jspa";
    }

    @Override
    protected Collection<Priority> getConstants() {
        return this.getConstantsManager().getPriorityObjects();
    }

    @Override
    protected void clearCaches() {
        this.getConstantsManager().refreshPriorities();
    }

    @RequiresXsrfCheck
    public String doAddPriority() throws Exception {
        if (this.isPreview()) {
            return "input";
        }
        if (StringUtils.isBlank((String)this.getIconurl())) {
            this.addError("iconurl", this.getText("admin.errors.must.specify.url.for.icon.of.priority"));
        }
        if (StringUtils.isBlank((String)this.getStatusColor())) {
            this.addError("statusColor", this.getText("admin.errors.must.specify.color"));
        }
        this.addField("statusColor", this.getStatusColor());
        return super.doAddConstant();
    }

    @Override
    protected String redirectToView() {
        return this.getRedirect("ViewPriorities.jspa");
    }

    @Override
    protected String getDefaultPropertyName() {
        return "jira.constant.default.priority";
    }

    public boolean isPreview() {
        return this.preview;
    }

    public void setPreview(boolean preview) {
        this.preview = preview;
    }

    public String getStatusColor() {
        return this.statusColor;
    }

    public void setStatusColor(String statusColor) {
        this.statusColor = statusColor;
    }

    @Override
    protected void addConstant() throws GenericEntityException {
        this.priorityManager.createPriority(this.name, this.description, this.iconurl, this.statusColor);
    }

    @RequiresXsrfCheck
    public String doMoveDown() {
        this.priorityManager.movePriorityDown(this.down);
        return this.getResult();
    }

    @RequiresXsrfCheck
    public String doMoveUp() {
        this.priorityManager.movePriorityUp(this.up);
        return this.getResult();
    }

    @RequiresXsrfCheck
    public String doMakeDefault() throws Exception {
        this.priorityManager.setDefaultPriority(this.make);
        return "success";
    }
}

