/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.permission;

import com.atlassian.jira.permission.ProjectPermission;
import com.atlassian.jira.permission.ProjectPermissionCategory;
import com.atlassian.jira.permission.ProjectPermissionSchemeHelper;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.scheme.Scheme;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.web.action.admin.permission.SchemeAwarePermissionAction;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import java.util.Collection;
import java.util.List;
import org.ofbiz.core.entity.GenericEntityException;

@WebSudoRequired
public class EditPermissions
extends SchemeAwarePermissionAction {
    private final PermissionManager permissionManager;
    private final ProjectPermissionSchemeHelper helper;
    private String usersGroupsRolesHeaderText;
    private List<Project> projects;

    public EditPermissions(PermissionManager permissionManager, ProjectPermissionSchemeHelper helper) {
        this.permissionManager = permissionManager;
        this.helper = helper;
    }

    public Collection<ProjectPermission> getProjectPermissions() {
        return this.permissionManager.getProjectPermissions(ProjectPermissionCategory.PROJECTS);
    }

    public Collection<ProjectPermission> getIssuePermissions() {
        return this.permissionManager.getProjectPermissions(ProjectPermissionCategory.ISSUES);
    }

    public Collection<ProjectPermission> getVotersAndWatchersPermissions() {
        return this.permissionManager.getProjectPermissions(ProjectPermissionCategory.VOTERS_AND_WATCHERS);
    }

    public Collection<ProjectPermission> getTimeTrackingPermissions() {
        return this.permissionManager.getProjectPermissions(ProjectPermissionCategory.TIME_TRACKING);
    }

    public Collection<ProjectPermission> getCommentsPermissions() {
        return this.permissionManager.getProjectPermissions(ProjectPermissionCategory.COMMENTS);
    }

    public Collection<ProjectPermission> getAttachmentsPermissions() {
        return this.permissionManager.getProjectPermissions(ProjectPermissionCategory.ATTACHMENTS);
    }

    public Collection<ProjectPermission> getOtherPermissions() {
        return this.permissionManager.getProjectPermissions(ProjectPermissionCategory.OTHER);
    }

    public String getI18nUsersGroupsRolesHeader() {
        if (this.usersGroupsRolesHeaderText == null) {
            this.usersGroupsRolesHeaderText = this.getText("admin.common.words.users.groups.roles");
        }
        return this.usersGroupsRolesHeaderText;
    }

    public List getPermissions(String permissionKey) throws GenericEntityException {
        return this.getSchemeManager().getEntities(this.getScheme(), permissionKey);
    }

    public List<Project> getUsedIn() {
        if (this.projects == null) {
            Scheme permissionScheme = this.getSchemeObject();
            this.projects = this.helper.getSharedProjects(permissionScheme);
        }
        return this.projects;
    }
}

