/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.issuefields.screens;

import com.atlassian.jira.issue.fields.screen.FieldScreenFactory;
import com.atlassian.jira.issue.fields.screen.FieldScreenManager;
import com.atlassian.jira.issue.fields.screen.FieldScreenScheme;
import com.atlassian.jira.issue.fields.screen.FieldScreenSchemeItem;
import com.atlassian.jira.issue.fields.screen.FieldScreenSchemeItemImpl;
import com.atlassian.jira.issue.fields.screen.FieldScreenSchemeManager;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.web.action.admin.issuefields.screens.AbstractFieldScreenSchemeAction;
import com.atlassian.sal.api.websudo.WebSudoRequired;

@WebSudoRequired
public class EditFieldScreenScheme
extends AbstractFieldScreenSchemeAction {
    private boolean edited;
    private final FieldScreenFactory fieldScreenFactory;
    private final FieldScreenManager fieldScreenManager;

    public EditFieldScreenScheme(FieldScreenSchemeManager fieldScreenSchemeManager, FieldScreenFactory fieldScreenFactory, FieldScreenManager fieldScreenManager) {
        super(fieldScreenSchemeManager);
        this.fieldScreenFactory = fieldScreenFactory;
        this.fieldScreenManager = fieldScreenManager;
    }

    public String doDefault() throws Exception {
        this.validateId();
        if (!this.invalidInput()) {
            this.setFieldScreenSchemeName(this.getFieldScreenScheme().getName());
            this.setFieldScreenSchemeDescription(this.getFieldScreenScheme().getDescription());
            return "input";
        }
        return this.getResult();
    }

    protected void doValidation() {
        this.validateId();
        if (!this.invalidInput()) {
            this.validateName(true);
        }
    }

    @RequiresXsrfCheck
    protected String doExecute() throws Exception {
        FieldScreenScheme fieldScreenScheme = this.getFieldScreenScheme();
        fieldScreenScheme.setName(this.getFieldScreenSchemeName());
        fieldScreenScheme.setDescription(this.getFieldScreenSchemeDescription());
        fieldScreenScheme.store();
        return this.redirectToView();
    }

    public String doViewCopyFieldScreenScheme() {
        this.validateId();
        if (!this.invalidInput()) {
            this.setFieldScreenSchemeName(this.getText("common.words.copyof", this.getFieldScreenScheme().getName()));
            this.setFieldScreenSchemeDescription(this.getFieldScreenScheme().getDescription());
            return "input";
        }
        return this.getResult();
    }

    @RequiresXsrfCheck
    public String doCopyFieldScreenScheme() {
        this.validateId();
        if (!this.invalidInput()) {
            this.validateName(false);
            if (!this.invalidInput()) {
                FieldScreenScheme fieldScreenScheme = this.fieldScreenFactory.createFieldScreenScheme();
                fieldScreenScheme.setName(this.getFieldScreenSchemeName());
                fieldScreenScheme.setDescription(this.getFieldScreenSchemeDescription());
                fieldScreenScheme.store();
                for (FieldScreenSchemeItem fieldScreenSchemeItem : this.getFieldScreenScheme().getFieldScreenSchemeItems()) {
                    FieldScreenSchemeItemImpl copyFieldScreenSchemeItem = new FieldScreenSchemeItemImpl(this.getFieldScreenSchemeManager(), fieldScreenSchemeItem, this.fieldScreenManager);
                    fieldScreenScheme.addFieldScreenSchemeItem((FieldScreenSchemeItem)copyFieldScreenSchemeItem);
                }
            }
            return this.redirectToView();
        }
        return this.getResult();
    }

    public boolean isEdited() {
        return this.edited;
    }

    public void setEdited(boolean edited) {
        this.edited = edited;
    }
}

