/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.index;

import com.atlassian.fugue.Option;
import com.atlassian.jira.index.ha.IndexRecoveryService;
import com.atlassian.jira.issue.fields.option.TextOption;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.scheduler.cron.CronValidator;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.web.action.ProjectActionSupport;
import com.atlassian.jira.web.action.admin.index.IndexRecoveryUtil;
import com.atlassian.jira.web.component.cron.CronEditorBean;
import com.atlassian.jira.web.component.cron.CronEditorWebComponent;
import com.atlassian.jira.web.component.cron.generator.CronExpressionGenerator;
import com.atlassian.jira.web.component.cron.parser.CronExpressionParser;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.atlassian.scheduler.SchedulerService;
import java.util.Collection;
import webwork.action.ActionContext;

@WebSudoRequired
public class EditIndexRecoverySettings
extends ProjectActionSupport {
    private final IndexRecoveryService indexRecoveryService;
    private final SchedulerService schedulerService;
    private boolean recoveryEnabled;
    private IndexRecoveryUtil.Interval snapshotInterval;
    private CronEditorBean cronEditorBean;

    public EditIndexRecoverySettings(ProjectManager projectManager, PermissionManager permissionManager, IndexRecoveryService indexRecoveryService, SchedulerService schedulerService) {
        super(projectManager, permissionManager);
        this.indexRecoveryService = indexRecoveryService;
        this.schedulerService = schedulerService;
    }

    public String doDefault() throws Exception {
        this.recoveryEnabled = this.indexRecoveryService.isRecoveryEnabled(this.getLoggedInUser());
        if (this.recoveryEnabled) {
            String cronExpression = this.indexRecoveryService.getSnapshotCronExpression(this.getLoggedInUser());
            try {
                this.cronEditorBean = new CronExpressionParser(cronExpression).getCronEditorBean();
            }
            catch (IllegalArgumentException e) {
                this.cronEditorBean = new CronExpressionParser().getCronEditorBean();
                this.recoveryEnabled = false;
            }
        } else {
            this.recoveryEnabled = false;
            this.cronEditorBean = new CronExpressionParser().getCronEditorBean();
        }
        return "input";
    }

    protected void doValidation() {
        Option<String> cronError;
        this.cronEditorBean = new CronEditorBean("service.schedule", ActionContext.getParameters());
        CronEditorWebComponent component = new CronEditorWebComponent();
        this.addErrorCollection(component.validateInput(this.cronEditorBean, "cron.editor.name"));
        if (!this.hasAnyErrors() && (cronError = new CronValidator(this.getI18nHelper(), this.schedulerService).validateCron(component.getCronExpressionFromInput(this.cronEditorBean))).isDefined()) {
            this.addError("cron.editor.name", (String)cronError.get());
        }
        super.doValidation();
    }

    @RequiresXsrfCheck
    protected String doExecute() throws Exception {
        String cronExpression = new CronExpressionGenerator().getCronExpressionFromInput(this.cronEditorBean);
        this.indexRecoveryService.updateRecoverySettings(this.getLoggedInUser(), this.recoveryEnabled, cronExpression);
        return this.returnComplete("IndexAdmin.jspa");
    }

    public CronEditorBean getCronEditorBean() {
        return this.cronEditorBean;
    }

    public boolean isRecoveryEnabled() {
        return this.recoveryEnabled;
    }

    public void setRecoveryEnabled(boolean recoveryEnabled) {
        this.recoveryEnabled = recoveryEnabled;
    }

    public String getSnapshotInterval() {
        return this.snapshotInterval.name();
    }

    public void setSnapshotInterval(String snapshotInterval) {
        this.snapshotInterval = IndexRecoveryUtil.Interval.valueOf(snapshotInterval);
    }

    public Collection<TextOption> getIntervalOptions() {
        return IndexRecoveryUtil.getIntervalOptions(this.getI18nHelper());
    }
}

