/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.customfields;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.managedconfiguration.ConfigurationItemAccessLevel;
import com.atlassian.jira.config.managedconfiguration.ManagedConfigurationItemService;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.customfields.CustomFieldSearcher;
import com.atlassian.jira.issue.customfields.CustomFieldType;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.ObjectUtils;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.web.action.admin.customfields.CustomFieldValidator;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class CustomFieldValidatorImpl
implements CustomFieldValidator {
    private final CustomFieldManager customFieldManager;
    private final ManagedConfigurationItemService managedConfigurationItemService;

    public CustomFieldValidatorImpl(CustomFieldManager customFieldManager, ManagedConfigurationItemService managedConfigurationItemService) {
        this.customFieldManager = customFieldManager;
        this.managedConfigurationItemService = managedConfigurationItemService;
    }

    @Override
    public ErrorCollection validateType(String fieldType) {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        if (fieldType == null) {
            errorCollection.addErrorMessage(this.getI18nBean().getText("admin.errors.customfields.no.field.type.specified"));
        } else {
            try {
                CustomFieldType customFieldType = this.customFieldManager.getCustomFieldType(fieldType);
                if (customFieldType == null) {
                    errorCollection.addErrorMessage(this.getI18nBean().getText("admin.errors.customfields.invalid.field.type"));
                } else if (customFieldType.getDescriptor().isTypeManaged()) {
                    ConfigurationItemAccessLevel managedAccessLevel = customFieldType.getDescriptor().getManagedAccessLevel();
                    if (!this.managedConfigurationItemService.doesUserHavePermission(this.getLoggedInUser(), managedAccessLevel)) {
                        errorCollection.addErrorMessage(this.getI18nBean().getText("admin.managed.configuration.items.customfieldtype.error.cannot.create.locked", customFieldType.getName()));
                    }
                }
            }
            catch (IllegalArgumentException e) {
                errorCollection.addErrorMessage(this.getI18nBean().getText("admin.errors.customfields.invalid.field.type"));
            }
        }
        return errorCollection;
    }

    @Override
    public boolean isValidType(String fieldType) {
        return !this.validateType(fieldType).hasAnyErrors();
    }

    @Override
    public ErrorCollection validateDetails(String fieldName, String fieldType, String searcher) {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        if (StringUtils.isBlank((String)fieldName)) {
            errorCollection.addError("fieldName", this.getI18nBean().getText("admin.errors.customfields.no.name"));
        }
        if (ObjectUtils.isValueSelected((Object)searcher)) {
            CustomFieldSearcher customFieldSearcher = this.customFieldManager.getCustomFieldSearcher(searcher);
            if (customFieldSearcher == null) {
                errorCollection.addError("searcher", this.getI18nBean().getText("admin.errors.customfields.unknown.searcher"));
            } else {
                CustomFieldType customFieldType = this.customFieldManager.getCustomFieldType(fieldType);
                if (customFieldType != null && !this.isValidSearcher(customFieldSearcher, customFieldType)) {
                    errorCollection.addError("searcher", this.getI18nBean().getText("admin.errors.customfields.invalid.searcher"));
                }
            }
        }
        return errorCollection;
    }

    protected boolean isValidSearcher(CustomFieldSearcher searcher, CustomFieldType customFieldType) {
        if (searcher != null) {
            List searchers = this.customFieldManager.getCustomFieldSearchers(customFieldType);
            if (searchers != null && !searchers.isEmpty()) {
                for (CustomFieldSearcher issueSearcher : searchers) {
                    if (!issueSearcher.getDescriptor().getCompleteKey().equals(searcher.getDescriptor().getCompleteKey())) continue;
                    return true;
                }
                return false;
            }
            return false;
        }
        return true;
    }

    protected I18nHelper getI18nBean() {
        return ComponentAccessor.getJiraAuthenticationContext().getI18nHelper();
    }

    protected ApplicationUser getLoggedInUser() {
        return ComponentAccessor.getJiraAuthenticationContext().getLoggedInUser();
    }
}

