/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.constants;

import com.atlassian.jira.issue.IssueConstant;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.web.action.admin.constants.AbstractConstantAction;
import org.apache.commons.lang.StringUtils;

public abstract class AbstractEditConstant<T extends IssueConstant>
extends AbstractConstantAction<T> {
    protected String id;
    protected T constant;
    protected String name;
    protected String description;
    protected String iconurl;

    public String doDefault() throws Exception {
        T constant = this.getConstant();
        if (constant == null) {
            this.addErrorMessage(this.getText("admin.errors.no.id.set"));
            return "error";
        }
        this.name = constant.getName();
        this.description = constant.getDescription();
        this.iconurl = constant.getIconUrl();
        return super.doDefault();
    }

    protected void doValidation() {
        IssueConstant constantByName;
        String actualName;
        if (this.getConstant() == null) {
            this.addErrorMessage(this.getText("admin.errors.specified.constant.does.not.exist"));
        }
        if ((actualName = StringUtils.trimToNull((String)this.name)) == null) {
            this.addError("name", this.getText("admin.errors.must.specify.name"));
        }
        if ((constantByName = this.getConstantsManager().getConstantByNameIgnoreCase(this.getConstantEntityName(), actualName)) != null && !constantByName.getId().equals(this.getConstant().getId())) {
            this.addError("name", this.createDuplicateMessage());
        }
    }

    protected String createDuplicateMessage() {
        return this.getText("admin.errors.constant.already.exists", this.getNiceConstantName());
    }

    @RequiresXsrfCheck
    protected abstract String doExecute() throws Exception;

    public T getConstant() {
        if (this.constant == null) {
            this.constant = this.getConstant(this.id);
        }
        return this.constant;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getIconurl() {
        return this.iconurl;
    }

    public void setIconurl(String iconurl) {
        this.iconurl = iconurl;
    }
}

