/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action;

import com.atlassian.jira.bc.filter.SearchRequestService;
import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.bc.issue.worklog.TimeTrackingConfiguration;
import com.atlassian.jira.bc.security.login.LoginInfo;
import com.atlassian.jira.bc.security.login.LoginService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.AttachmentManager;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.project.VersionProxy;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.project.version.VersionManager;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.UserIssueHistoryManager;
import com.atlassian.jira.util.JiraDurationUtils;
import com.atlassian.jira.util.JiraUrlCodec;
import com.atlassian.jira.web.FieldVisibilityManager;
import com.atlassian.jira.web.action.ProjectActionSupport;
import com.atlassian.jira.web.session.SessionPagerFilterManager;
import com.atlassian.jira.web.session.SessionSearchObjectManagerFactory;
import com.atlassian.jira.web.session.SessionSearchRequestManager;
import com.atlassian.jira.web.session.SessionSelectedIssueManager;
import com.atlassian.jira.workflow.WorkflowUtil;
import com.atlassian.security.random.DefaultSecureTokenGenerator;
import com.atlassian.security.random.SecureTokenGenerator;
import com.opensymphony.workflow.Workflow;
import com.opensymphony.workflow.loader.ActionDescriptor;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import webwork.action.ActionContext;

public class IssueActionSupport
extends ProjectActionSupport {
    private Workflow workflow;
    private final IssueManager issueManager;
    private final CustomFieldManager customFieldManager;
    protected final AttachmentManager attachmentManager;
    private final VersionManager versionManager;
    private final UserIssueHistoryManager userHistoryManager;
    private final TimeTrackingConfiguration timeTrackingConfiguration;
    private final SecureTokenGenerator secureTokenGenerator = DefaultSecureTokenGenerator.getInstance();
    private SearchRequest searchRequest;
    private SessionSearchRequestManager sessionSearchRequestManager;
    private SessionSelectedIssueManager sessionSelectedIssueManager;
    private SessionPagerFilterManager sessionPagerFilterManager;
    private SessionSearchObjectManagerFactory sessionSearchObjectManagerFactory;
    private LoginService loginService;
    private Map<String, LoginInfo> loginInfoCache = new HashMap<String, LoginInfo>();
    private String formToken;

    public IssueActionSupport(IssueManager issueManager, CustomFieldManager customFieldManager, AttachmentManager attachmentManager, ProjectManager projectManager, PermissionManager permissionManager, VersionManager versionManager, UserIssueHistoryManager userHistoryManager, TimeTrackingConfiguration timeTrackingConfiguration) {
        super(projectManager, permissionManager);
        this.issueManager = issueManager;
        this.customFieldManager = customFieldManager;
        this.attachmentManager = attachmentManager;
        this.versionManager = versionManager;
        this.userHistoryManager = userHistoryManager;
        this.timeTrackingConfiguration = timeTrackingConfiguration;
    }

    public IssueActionSupport() {
        this((IssueManager)ComponentAccessor.getComponent(IssueManager.class), (CustomFieldManager)ComponentAccessor.getComponent(CustomFieldManager.class), (AttachmentManager)ComponentAccessor.getComponent(AttachmentManager.class), (ProjectManager)ComponentAccessor.getComponent(ProjectManager.class), (PermissionManager)ComponentAccessor.getComponent(PermissionManager.class), (VersionManager)ComponentAccessor.getComponent(VersionManager.class), (UserIssueHistoryManager)ComponentAccessor.getComponent(UserIssueHistoryManager.class), (TimeTrackingConfiguration)ComponentAccessor.getComponent(TimeTrackingConfiguration.class));
    }

    public IssueManager getIssueManager() {
        return this.issueManager;
    }

    public CustomFieldManager getCustomFieldManager() {
        return this.customFieldManager;
    }

    public AttachmentManager getAttachmentManager() {
        return this.attachmentManager;
    }

    public SearchRequest getSearchRequest() {
        if (this.searchRequest == null) {
            SearchRequest requestFromDB;
            this.searchRequest = (SearchRequest)this.getSessionSearchRequestManager().getCurrentObject();
            if (this.searchRequest != null && this.searchRequest.isLoaded() && (requestFromDB = ((SearchRequestService)ComponentAccessor.getComponent(SearchRequestService.class)).getFilter(this.getJiraServiceContext(), this.searchRequest.getId())) != null) {
                if (this.searchRequest.isModified()) {
                    this.searchRequest.setPermissions(requestFromDB.getPermissions());
                } else {
                    requestFromDB.setUseColumns(this.searchRequest.useColumns());
                    this.setSearchRequest(requestFromDB);
                    this.searchRequest = requestFromDB;
                }
            }
        }
        return this.searchRequest;
    }

    public String getCurrentJQL() {
        SearchRequest sr = this.getSearchRequest();
        if (sr != null) {
            SearchService searchService = (SearchService)ComponentAccessor.getComponent(SearchService.class);
            return searchService.getJqlString(sr.getQuery());
        }
        return null;
    }

    protected void setSearchRequest(SearchRequest searchRequest) {
        this.searchRequest = null;
        this.getSessionSearchRequestManager().setCurrentObject(searchRequest);
    }

    protected SessionSearchRequestManager getSessionSearchRequestManager() {
        if (this.sessionSearchRequestManager == null) {
            this.sessionSearchRequestManager = this.getSessionSearchRequestManagerFactory().createSearchRequestManager(ActionContext.getRequest());
        }
        return this.sessionSearchRequestManager;
    }

    protected SessionSelectedIssueManager getSessionSelectedIssueManager() {
        if (this.sessionSelectedIssueManager == null) {
            this.sessionSelectedIssueManager = this.getSessionSearchRequestManagerFactory().createSelectedIssueManager(ActionContext.getRequest());
        }
        return this.sessionSelectedIssueManager;
    }

    protected SessionPagerFilterManager getSessionPagerFilterManager() {
        if (this.sessionPagerFilterManager == null) {
            this.sessionPagerFilterManager = this.getSessionSearchRequestManagerFactory().createPagerFilterManager(ActionContext.getRequest());
        }
        return this.sessionPagerFilterManager;
    }

    public SessionSearchObjectManagerFactory getSessionSearchRequestManagerFactory() {
        if (this.sessionSearchObjectManagerFactory == null) {
            this.sessionSearchObjectManagerFactory = (SessionSearchObjectManagerFactory)ComponentAccessor.getComponentOfType(SessionSearchObjectManagerFactory.class);
        }
        return this.sessionSearchObjectManagerFactory;
    }

    protected void updateSearchRequest() {
        SearchRequestService searchRequestService = (SearchRequestService)ComponentAccessor.getComponent(SearchRequestService.class);
        this.setSearchRequest(searchRequestService.updateFilter(this.getJiraServiceContext(), this.getSearchRequest()));
    }

    public void addIssueToHistory(Issue issueObj) {
        ApplicationUser remoteUser = this.getLoggedInUser();
        this.userHistoryManager.addIssueToHistory(remoteUser, issueObj);
    }

    public List<VersionProxy> getPossibleVersions(Project project) throws Exception {
        return this.getPossibleVersions(project, true);
    }

    public List<VersionProxy> getPossibleVersionsReleasedFirst(Project project) throws Exception {
        return this.getPossibleVersions(project, false);
    }

    private List<VersionProxy> getPossibleVersions(Project project, boolean unreleasedFirst) throws Exception {
        ArrayList<VersionProxy> unreleased = new ArrayList<VersionProxy>();
        Iterator unreleasedIter = this.versionManager.getVersionsUnreleased(project.getId(), false).iterator();
        if (unreleasedIter.hasNext()) {
            unreleased.add(new VersionProxy(-2L, this.getText("common.filters.unreleasedversions")));
            while (unreleasedIter.hasNext()) {
                unreleased.add(new VersionProxy((Version)unreleasedIter.next()));
            }
        }
        ArrayList<VersionProxy> released = new ArrayList<VersionProxy>();
        ArrayList releasedIter = new ArrayList(this.versionManager.getVersionsReleased(project.getId(), false));
        if (!releasedIter.isEmpty()) {
            released.add(new VersionProxy(-3L, this.getText("common.filters.releasedversions")));
            Collections.reverse(releasedIter);
            for (Version element : releasedIter) {
                released.add(new VersionProxy(element));
            }
        }
        ArrayList<VersionProxy> versions = new ArrayList<VersionProxy>();
        if (unreleasedFirst) {
            versions.addAll(unreleased);
            versions.addAll(released);
        } else {
            versions.addAll(released);
            versions.addAll(unreleased);
        }
        return versions;
    }

    public String getUrlEncoded(String s) {
        return JiraUrlCodec.encode((String)s);
    }

    public Workflow getWorkflow() {
        if (this.workflow == null) {
            this.workflow = ComponentAccessor.getWorkflowManager().makeWorkflow(this.getLoggedInUser());
        }
        return this.workflow;
    }

    public BigDecimal getHoursPerDay() {
        return this.timeTrackingConfiguration.getHoursPerDay();
    }

    public BigDecimal getDaysPerWeek() {
        return this.timeTrackingConfiguration.getDaysPerWeek();
    }

    public boolean isTimeTrackingEnabled() {
        return this.timeTrackingConfiguration.enabled();
    }

    public String getPrettyDuration(Long v) {
        return ((JiraDurationUtils)ComponentAccessor.getComponent(JiraDurationUtils.class)).getFormattedDuration(v);
    }

    @Deprecated
    public void setSelectedIssueId(Long selectedIssueId) {
    }

    public void clearSelectedIssue() {
        this.getSessionSelectedIssueManager().setCurrentObject(new SessionSelectedIssueManager.SelectedIssueData(null, 0, null));
    }

    public Long getSelectedIssueId() {
        SessionSelectedIssueManager.SelectedIssueData selectedIssueData = (SessionSelectedIssueManager.SelectedIssueData)this.getSessionSelectedIssueManager().getCurrentObject();
        return selectedIssueData == null ? null : selectedIssueData.getSelectedIssueId();
    }

    @Deprecated
    public boolean isCustomFieldHidden(Long projectId, Long customFieldId, String issueTypeId) {
        return this.getFieldVisibilityManager().isFieldHidden(projectId, "customfield_" + customFieldId, issueTypeId);
    }

    @Deprecated
    public boolean isFieldHidden(Long projectId, String id, String issueTypeId) {
        return this.getFieldVisibilityManager().isFieldHidden(projectId, id, issueTypeId);
    }

    public boolean isFieldHidden(Long projectId, String id, Integer issueTypeId) {
        return this.getFieldVisibilityManager().isFieldHidden(projectId, id, issueTypeId.toString());
    }

    public String getWorkflowTransitionDisplayName(ActionDescriptor descriptor) {
        return WorkflowUtil.getWorkflowTransitionDisplayName((ActionDescriptor)descriptor);
    }

    public String getWorkflowTransitionDescription(ActionDescriptor descriptor) {
        return StringUtils.trimToNull((String)WorkflowUtil.getWorkflowTransitionDescription((ActionDescriptor)descriptor));
    }

    public String getLastLogin(ApplicationUser user) {
        return this.getLoginDate(this.getLoginInfo(user).getLastLoginTime());
    }

    public String getPreviousLogin(ApplicationUser user) {
        return this.getLoginDate(this.getLoginInfo(user).getPreviousLoginTime());
    }

    public String getLastFailedLogin(ApplicationUser user) {
        return this.getLoginDate(this.getLoginInfo(user).getLastFailedLoginTime());
    }

    public String getLoginCount(ApplicationUser user) {
        return this.getLoginLong(this.getLoginInfo(user).getLoginCount());
    }

    public String getCurrentFailedLoginCount(ApplicationUser user) {
        return this.getLoginLong(this.getLoginInfo(user).getCurrentFailedLoginCount());
    }

    public String getTotalFailedLoginCount(ApplicationUser user) {
        return this.getLoginLong(this.getLoginInfo(user).getTotalFailedLoginCount());
    }

    public boolean isElevatedSecurityCheckRequired(ApplicationUser user) {
        return this.getLoginInfo(user).isElevatedSecurityCheckRequired();
    }

    public boolean getEverLoggedIn(ApplicationUser user) {
        return this.getLoginInfo(user).getLoginCount() != null;
    }

    private LoginInfo getLoginInfo(ApplicationUser user) {
        String username = user.getName();
        LoginInfo loginInfo = this.loginInfoCache.get(username);
        if (loginInfo == null) {
            loginInfo = this.getLoginService().getLoginInfo(username);
            this.loginInfoCache.put(username, loginInfo);
        }
        return loginInfo;
    }

    LoginService getLoginService() {
        if (this.loginService == null) {
            this.loginService = (LoginService)ComponentAccessor.getComponentOfType(LoginService.class);
        }
        return this.loginService;
    }

    private String getLoginDate(Long value) {
        if (value == null) {
            return this.getText("login.not.recorded");
        }
        return this.getOutlookDate().format(new Date(value));
    }

    private String getLoginLong(Long value) {
        if (value == null) {
            return this.getText("login.not.recorded");
        }
        return String.valueOf(value);
    }

    private FieldVisibilityManager getFieldVisibilityManager() {
        return (FieldVisibilityManager)this.getComponentInstanceOfType(FieldVisibilityManager.class);
    }

    public String getFormToken() {
        if (this.formToken == null) {
            this.setFormToken(this.secureTokenGenerator.generateToken());
        }
        return this.formToken;
    }

    public void setFormToken(String formToken) {
        this.formToken = formToken;
    }
}

