/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util.resourcebundle;

import com.atlassian.jira.plugin.language.Language;
import com.atlassian.jira.plugin.language.LanguageModuleDescriptor;
import com.atlassian.jira.util.resourcebundle.DefaultResourceBundle;
import com.atlassian.jira.util.resourcebundle.ResourceBundleLoader;
import com.atlassian.jira.util.resourcebundle.ResourceLoaderInvocation;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.elements.ResourceDescriptor;
import com.atlassian.plugin.metadata.PluginMetadataManager;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
class PluginResourceLoaderInvocation
extends ResourceLoaderInvocation {
    private static final Logger log = LoggerFactory.getLogger(ResourceBundleLoader.class);
    private static final int INITIAL_FLATTENED_MAP_SIZE = 8192;
    private final PluginAccessor accessor;
    private final PluginMetadataManager pluginMetadata;
    private final Function<Locale, Iterable<ResourceBundle>> defaultLanguage;
    private final BundleLoader bundleLoader;

    PluginResourceLoaderInvocation(PluginAccessor accessor, PluginMetadataManager pluginMetadata) {
        this(accessor, pluginMetadata, new DefaultLanguageSupplierImpl(), new DefaultBundleLoader());
    }

    @VisibleForTesting
    PluginResourceLoaderInvocation(PluginAccessor accessor, PluginMetadataManager pluginMetadata, DefaultLanguageSupplier defaultLanguage, BundleLoader loader) {
        this.accessor = accessor;
        this.pluginMetadata = pluginMetadata;
        this.defaultLanguage = defaultLanguage;
        this.bundleLoader = loader;
    }

    private static boolean providedLocaleMatches(Locale providedLocale, Locale targetLocale) {
        if (providedLocale.getLanguage().length() == 0) {
            return true;
        }
        if (!providedLocale.getLanguage().equals(targetLocale.getLanguage())) {
            return false;
        }
        if (providedLocale.getCountry().length() == 0) {
            return true;
        }
        return providedLocale.getCountry().equals(targetLocale.getCountry());
    }

    private static void logFlatteningException(String key, ResourceBundle bundle, Exception e) {
        if (log.isDebugEnabled()) {
            log.debug("Failed to resolve key " + key + "  from resource bundle " + bundle + ": " + e, (Throwable)e);
        }
    }

    @Override
    ResourceBundleLoader.LoadResult load() {
        Iterable translations = this.loadPluginSourcedBundles();
        if (this.getMode().includeLangPacks()) {
            translations = Iterables.concat(translations, (Iterable)((Iterable)this.defaultLanguage.apply((Object)this.getLocale())), this.loadV2LanguagePackBundles());
        }
        Map<String, String> text = this.flattenResourceBundlesToMap(Iterables.filter(translations, (Predicate)Predicates.notNull()));
        return new ResourceBundleLoader.LoadResult(text);
    }

    private Map<String, String> flattenResourceBundlesToMap(Iterable<ResourceBundle> bundles) {
        HashMap<String, String> map = new HashMap<String, String>(8192);
        for (ResourceBundle bundle : bundles) {
            this.logBundleLoadedMessage(bundle);
            Enumeration<String> keys = bundle.getKeys();
            while (keys.hasMoreElements()) {
                String propertyKey = keys.nextElement();
                if (propertyKey == null) continue;
                try {
                    String value = bundle.getString(propertyKey);
                    if (value == null) continue;
                    map.put(propertyKey.intern(), value.intern());
                }
                catch (RuntimeException e) {
                    PluginResourceLoaderInvocation.logFlatteningException(propertyKey, bundle, e);
                }
            }
        }
        return ImmutableMap.copyOf(map);
    }

    private void logBundleLoadedMessage(ResourceBundle bundle) {
        if (log.isDebugEnabled()) {
            String name;
            try {
                Field bundleNameField = ResourceBundle.class.getDeclaredField("name");
                bundleNameField.setAccessible(true);
                name = (String)bundleNameField.get(bundle);
            }
            catch (Exception e) {
                name = String.valueOf(bundle);
            }
            log.debug(String.format("Adding ResourceBundle: %s bundle; Locale: %s; Mode: %s; %d keys.", new Object[]{name, bundle.getLocale(), this.getMode(), bundle.keySet().size()}));
        }
    }

    private Iterable<ResourceBundle> loadV2LanguagePackBundles() {
        ArrayList<ResourceBundle> v2LanguagePacks = new ArrayList<ResourceBundle>();
        List descriptors = this.accessor.getEnabledModuleDescriptorsByClass(LanguageModuleDescriptor.class);
        for (LanguageModuleDescriptor descriptor : descriptors) {
            this.addV2LanguagePackBundle(v2LanguagePacks, descriptor);
        }
        Collections.sort(v2LanguagePacks, ResourceBundleLocaleSorter.INSTANCE);
        return v2LanguagePacks;
    }

    private void addV2LanguagePackBundle(List<ResourceBundle> v2LanguagePacks, LanguageModuleDescriptor descriptor) {
        block13: {
            try {
                Locale providedLocale = ((Language)descriptor.getModule()).getLocale();
                if (PluginResourceLoaderInvocation.providedLocaleMatches(providedLocale, this.getLocale())) {
                    ResourceBundle resourceBundle = this.bundleLoader.getBundle(descriptor);
                    v2LanguagePacks.add(resourceBundle);
                    Iterable i18nResources = Iterables.filter((Iterable)descriptor.getPlugin().getResourceDescriptors(), (Predicate)this.getMode().filter());
                    for (ResourceDescriptor resourceDescriptor : i18nResources) {
                        try {
                            v2LanguagePacks.add(this.bundleLoader.getBundle(this.getLocale(), descriptor.getPlugin(), resourceDescriptor));
                        }
                        catch (MissingResourceException e) {
                            if (!log.isDebugEnabled()) continue;
                            log.debug(String.format("FAILED plugin resource; targetLocale: %s; pluginKey: %s; location: %s; mode:%s", new Object[]{this.getLocale(), descriptor.getPluginKey(), resourceDescriptor.getLocation(), this.getMode()}));
                        }
                    }
                    if (log.isDebugEnabled()) {
                        log.debug("Accepted v2 lang pack; targetLocale=" + this.getLocale() + "; descriptor=" + descriptor.getCompleteKey() + "; providedLocale=" + providedLocale);
                    }
                } else if (log.isDebugEnabled()) {
                    log.debug("IGNORING v2 lang pack; targetLocale=" + this.getLocale() + "; descriptor=" + descriptor.getCompleteKey() + "; providedLocale=" + providedLocale);
                }
            }
            catch (MissingResourceException mre) {
                if (log.isDebugEnabled()) {
                    log.debug("Missing resource for v2 lang pack; targetLocale=" + this.getLocale() + "; descriptor=" + descriptor.getCompleteKey() + "; ");
                }
            }
            catch (RuntimeException re) {
                String descriptorKey;
                if (!log.isDebugEnabled()) break block13;
                try {
                    descriptorKey = descriptor.getCompleteKey();
                }
                catch (RuntimeException ex) {
                    descriptorKey = "<" + ex + '>';
                }
                log.debug("FAILED v2 lang pack; targetLocale=" + this.getLocale() + "; descriptor=" + descriptorKey + "; ", (Throwable)re);
            }
        }
    }

    private Iterable<ResourceBundle> loadPluginSourcedBundles() {
        ArrayList pluginBundles = Lists.newArrayList();
        ArrayList enabledPlugins = Lists.newArrayList((Iterable)this.accessor.getEnabledPlugins());
        Ordering ordering = Ordering.from((Comparator)PluginLanguagePackSorter.INSTANCE);
        if (this.getMode() == ResourceLoaderInvocation.Mode.HELP) {
            ordering = ordering.compound((Comparator)Ordering.natural().reverse().onResultOf((Function)new Function<Plugin, Boolean>(){

                public Boolean apply(Plugin input) {
                    return PluginResourceLoaderInvocation.this.pluginMetadata.isSystemProvided(input);
                }
            }));
        }
        Collections.sort(enabledPlugins, ordering);
        for (Plugin plugin : enabledPlugins) {
            try {
                this.loadPluginSourcedBundles(this.getLocale(), pluginBundles, plugin);
            }
            catch (RuntimeException re) {
                if (!log.isDebugEnabled()) continue;
                log.debug(String.format("FAILED plugin resources: targetLocale: %s; pluginKey: %s; mode: %s", new Object[]{this.getLocale(), plugin.getKey(), this.getMode()}), (Throwable)re);
            }
        }
        Collections.sort(pluginBundles, ResourceBundleLocaleSorter.INSTANCE);
        return pluginBundles;
    }

    private void loadPluginSourcedBundles(Locale targetLocale, List<ResourceBundle> pluginBundles, Plugin plugin) {
        for (ResourceDescriptor resourceDescriptor : this.getResourceBundleLocations(plugin)) {
            try {
                this.loadPluginSourcedBundle(targetLocale, pluginBundles, plugin, resourceDescriptor);
            }
            catch (RuntimeException re) {
                log.debug(String.format("FAILED plugin resource; targetLocale: %s; pluginKey: %s; descriptor: <toxic>; mode: %s", new Object[]{targetLocale, plugin.getKey(), this.getMode()}), (Throwable)re);
            }
        }
    }

    private void loadPluginSourcedBundle(Locale targetLocale, List<ResourceBundle> pluginBundles, Plugin plugin, ResourceDescriptor descriptor) {
        try {
            ResourceBundle resourceBundle = this.bundleLoader.getBundle(targetLocale, plugin, descriptor);
            if (PluginResourceLoaderInvocation.providedLocaleMatches(resourceBundle.getLocale(), targetLocale)) {
                if (log.isDebugEnabled()) {
                    log.debug(String.format("Accepted plugin resource; targetLocale: %s; pluginKey: %s; descriptor: %s; mode: %s", new Object[]{targetLocale, plugin.getKey(), descriptor.getLocation(), this.getMode()}));
                }
                pluginBundles.add(resourceBundle);
            } else if (log.isDebugEnabled()) {
                log.debug(String.format("IGNORING plugin resource; targetLocale: %s; pluginKey: %s; descriptor: %s; mode: %s", new Object[]{targetLocale, plugin.getKey(), descriptor.getLocation(), this.getMode()}));
            }
        }
        catch (MissingResourceException mre) {
            log.debug(String.format("FAILED plugin resource; targetLocale: %s; pluginKey: %s; location: %s; mode:%s", new Object[]{targetLocale, plugin.getKey(), descriptor.getLocation(), this.getMode()}));
        }
    }

    private Collection<ResourceDescriptor> getResourceBundleLocations(Plugin plugin) {
        ArrayList locations = Lists.newArrayList();
        Iterables.addAll((Collection)locations, (Iterable)Iterables.filter((Iterable)plugin.getResourceDescriptors(), (Predicate)this.getMode().filter()));
        for (ModuleDescriptor moduleDescriptor : plugin.getModuleDescriptors()) {
            try {
                Iterables.addAll((Collection)locations, (Iterable)Iterables.filter((Iterable)moduleDescriptor.getResourceDescriptors(), (Predicate)this.getMode().filter()));
            }
            catch (RuntimeException re) {
                if (!log.isDebugEnabled()) continue;
                log.debug(String.format("FAILED plugin module resource descriptors: pluginKey: %s; moduleKey: %s; mode: %s", new Object[]{plugin.getKey(), moduleDescriptor.getCompleteKey(), this.getMode()}), (Throwable)re);
            }
        }
        return locations;
    }

    private static class DefaultBundleLoader
    implements BundleLoader {
        private static final ResourceBundle.Control NO_FALLBACK_CONTROL = ResourceBundle.Control.getNoFallbackControl(ResourceBundle.Control.FORMAT_DEFAULT);

        private DefaultBundleLoader() {
        }

        @Override
        public ResourceBundle getBundle(Locale targetLocale, Plugin plugin, ResourceDescriptor descriptor) {
            return ResourceBundle.getBundle(descriptor.getLocation(), targetLocale, plugin.getClassLoader(), NO_FALLBACK_CONTROL);
        }

        @Override
        public ResourceBundle getBundle(LanguageModuleDescriptor descriptor) {
            return ResourceBundle.getBundle(descriptor.getResourceBundleName(), ((Language)descriptor.getModule()).getLocale(), descriptor.getPlugin().getClassLoader(), NO_FALLBACK_CONTROL);
        }
    }

    private static class DefaultLanguageSupplierImpl
    implements DefaultLanguageSupplier {
        private DefaultLanguageSupplierImpl() {
        }

        public Iterable<ResourceBundle> apply(Locale input) {
            return Collections.singletonList(DefaultResourceBundle.getDefaultResourceBundle(input));
        }
    }

    @Immutable
    private static final class PluginLanguagePackSorter
    implements Comparator<Plugin> {
        static final PluginLanguagePackSorter INSTANCE = new PluginLanguagePackSorter();

        private PluginLanguagePackSorter() {
        }

        private static boolean isLanguagePack(Plugin plugin) {
            return !plugin.getModuleDescriptorsByModuleClass(LanguageModuleDescriptor.class).isEmpty();
        }

        @Override
        public int compare(Plugin plugin1, Plugin plugin2) {
            boolean isPlugin1LanguagePack = PluginLanguagePackSorter.isLanguagePack(plugin1);
            boolean isPlugin2LanguagePack = PluginLanguagePackSorter.isLanguagePack(plugin2);
            if (isPlugin1LanguagePack) {
                return isPlugin2LanguagePack ? 0 : 1;
            }
            return isPlugin2LanguagePack ? -1 : 0;
        }
    }

    @Immutable
    private static final class ResourceBundleLocaleSorter
    implements Comparator<ResourceBundle> {
        private static final ResourceBundleLocaleSorter INSTANCE = new ResourceBundleLocaleSorter();

        private ResourceBundleLocaleSorter() {
        }

        @Override
        public int compare(ResourceBundle bundle1, ResourceBundle bundle2) {
            Locale locale1 = bundle1.getLocale();
            Locale locale2 = bundle2.getLocale();
            if (locale1.getLanguage().length() == 0) {
                return locale2.getLanguage().length() == 0 ? 0 : -1;
            }
            if (locale2.getLanguage().length() == 0) {
                return 1;
            }
            if (locale1.getCountry().length() == 0) {
                return locale2.getCountry().length() == 0 ? 0 : -1;
            }
            if (locale2.getCountry().length() == 0) {
                return 1;
            }
            return 0;
        }
    }

    static interface DefaultLanguageSupplier
    extends Function<Locale, Iterable<ResourceBundle>> {
    }

    static interface BundleLoader {
        public ResourceBundle getBundle(Locale var1, Plugin var2, ResourceDescriptor var3);

        public ResourceBundle getBundle(LanguageModuleDescriptor var1);
    }
}

