/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util.log;

import com.atlassian.jira.util.dbc.Null;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.log4j.Appender;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.slf4j.MDC;

public class Log4jKit {
    public static final String MDC_JIRA_USERNAME = "jira.username";
    public static final String MDC_JIRA_REQUEST_ID = "jira.request.id";
    public static final String MDC_JIRA_ASSESSION_ID = "jira.request.assession.id";
    public static final String MDC_JIRA_REQUEST_URL = "jira.request.url";
    public static final String MDC_JIRA_REQUEST_IPADDR = "jira.request.ipaddr";
    static final String ANONYMOUS = "anonymous";

    public static File getLogFileName(String appenderName) {
        Null.not("appenderName", appenderName);
        Enumeration currentLoggers = LogManager.getCurrentLoggers();
        while (currentLoggers.hasMoreElements()) {
            Logger logger = (Logger)currentLoggers.nextElement();
            Enumeration allAppenders = logger.getAllAppenders();
            while (allAppenders.hasMoreElements()) {
                File file;
                Appender appender = (Appender)allAppenders.nextElement();
                if (!appenderName.equals(appender.getName()) || (file = Log4jKit.getFile(appender)) == null) continue;
                return file;
            }
        }
        return null;
    }

    public static Set<File> getAllLogFiles() {
        HashSet<File> logFileNames = new HashSet<File>();
        Enumeration currentLoggers = LogManager.getCurrentLoggers();
        while (currentLoggers.hasMoreElements()) {
            Logger logger = (Logger)currentLoggers.nextElement();
            Enumeration allAppenders = logger.getAllAppenders();
            while (allAppenders.hasMoreElements()) {
                Appender appender = (Appender)allAppenders.nextElement();
                File file = Log4jKit.getFile(appender);
                if (file == null) continue;
                logFileNames.add(file);
            }
        }
        return logFileNames;
    }

    private static File getFile(Appender appender) {
        try {
            Method file = appender.getClass().getMethod("getFile", new Class[0]);
            Object o = file.invoke((Object)appender, new Object[0]);
            if (o instanceof String) {
                return new File((String)o).getAbsoluteFile();
            }
            if (o instanceof File) {
                return ((File)o).getAbsoluteFile();
            }
            return null;
        }
        catch (NoSuchMethodException e) {
            return null;
        }
        catch (InvocationTargetException e) {
            return null;
        }
        catch (IllegalAccessException e) {
            return null;
        }
    }

    public static void putToMDC(String userName, String requestId, String asessionId, String requestURL, String ipAddr) {
        Log4jKit.putUserToMDC(userName);
        Log4jKit.nvlput(MDC_JIRA_REQUEST_ID, requestId);
        Log4jKit.nvlput(MDC_JIRA_ASSESSION_ID, asessionId);
        Log4jKit.nvlput(MDC_JIRA_REQUEST_URL, requestURL);
        Log4jKit.nvlput(MDC_JIRA_REQUEST_IPADDR, ipAddr);
    }

    public static void putUserToMDC(String userName) {
        Log4jKit.nvlput(MDC_JIRA_USERNAME, StringUtils.isBlank((String)userName) ? ANONYMOUS : userName);
    }

    public static void putASessionIdToMDC(String atlassianSessionId) {
        Log4jKit.nvlput(MDC_JIRA_ASSESSION_ID, atlassianSessionId);
    }

    private static void nvlput(@Nonnull String key, @Nullable Object value) {
        MDC.put((String)key, (String)ObjectUtils.toString((Object)value, (String)"-"));
    }

    public static void clearMDC() {
        MDC.clear();
    }
}

