/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util.index;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.index.ha.NodeReindexService;
import com.atlassian.jira.issue.index.IssueIndexManager;
import com.atlassian.jira.issue.index.IssueIndexingParams;
import com.atlassian.jira.sharing.index.SharedEntityIndexManager;
import com.atlassian.jira.task.context.Context;
import com.atlassian.jira.util.RuntimeInterruptedException;
import com.atlassian.jira.util.index.IndexLifecycleManager;
import com.atlassian.jira.util.index.IndexingCounterManager;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompositeIndexLifecycleManager
implements IndexLifecycleManager {
    private static final Logger log = LoggerFactory.getLogger(CompositeIndexLifecycleManager.class);
    private final IndexLifecycleManager[] delegates;
    private final IndexingCounterManager indexingCounterManager;

    public CompositeIndexLifecycleManager(IssueIndexManager issueIndexManager, SharedEntityIndexManager sharedEntityIndexManager, IndexingCounterManager indexingCounterManager) {
        this.delegates = new IndexLifecycleManager[]{issueIndexManager, sharedEntityIndexManager};
        this.indexingCounterManager = indexingCounterManager;
    }

    public long optimize() {
        log.info("Optimize Indexes starting...");
        long result = 0L;
        for (IndexLifecycleManager delegate : this.delegates) {
            long optimize = delegate.optimize();
            log.info("Optimize took: " + optimize + "ms. Indexer: " + delegate.toString());
            result += optimize;
        }
        log.info("Optimize Indexes complete. Total time: " + result + "ms.");
        return result;
    }

    public long reIndexAll(Context context) {
        return this.reIndexAll(context, IssueIndexingParams.INDEX_ALL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long reIndexAll(Context context, IssueIndexingParams issueIndexingParams) {
        log.info("Reindex All starting...");
        NodeReindexService nodeReindexService = (NodeReindexService)ComponentAccessor.getComponent(NodeReindexService.class);
        nodeReindexService.pause();
        nodeReindexService.resetIndexCount();
        long result = 0L;
        try {
            for (IndexLifecycleManager delegate : this.delegates) {
                try {
                    long reIndexAll = delegate.reIndexAll(context, issueIndexingParams);
                    log.info("Reindex took: " + reIndexAll + "ms. Indexer: " + delegate.toString());
                    result += reIndexAll;
                }
                catch (RuntimeException re) {
                    log.error("Reindex All FAILED.  Indexer: " + delegate.toString(), (Throwable)re);
                    throw re;
                }
            }
        }
        finally {
            nodeReindexService.start();
        }
        long newCounterValue = this.indexingCounterManager.incrementValue();
        context.setName("");
        log.info("Reindex All complete. Total time: " + result + "ms. Reindex run: " + newCounterValue);
        return result;
    }

    public long reIndexAllIssuesInBackground(Context context) {
        return this.reIndexIssuesInBackground(context, IssueIndexingParams.INDEX_ISSUE_ONLY);
    }

    public long reIndexAllIssuesInBackground(Context context, boolean reIndexComments, boolean reIndexChangeHistory) {
        IssueIndexingParams issueIndexingParams = IssueIndexingParams.builder().setComments(reIndexComments).setChangeHistory(reIndexChangeHistory).build();
        return this.reIndexIssuesInBackground(context, issueIndexingParams);
    }

    public long reIndexIssuesInBackground(Context context, IssueIndexingParams issueIndexingParams) {
        log.info("Reindex All In Background starting...");
        long result = 0L;
        for (IndexLifecycleManager delegate : this.delegates) {
            try {
                long reIndexAll = delegate.reIndexIssuesInBackground(context, issueIndexingParams);
                log.info("Reindex took: " + reIndexAll + "ms. Indexer: " + delegate.toString());
                result += reIndexAll;
            }
            catch (RuntimeInterruptedException rie) {
                log.warn("Reindex All In Background CANCELLED. Indexer: " + delegate.toString());
                throw rie;
            }
            catch (RuntimeException re) {
                log.error("Reindex All In Background FAILED. Indexer: " + delegate.toString(), (Throwable)re);
                throw re;
            }
        }
        long newCounterValue = this.indexingCounterManager.incrementValue();
        context.setName("");
        log.info("Reindex All In Background complete. Total time: " + result + "ms. Reindex run: " + newCounterValue);
        return result;
    }

    public void shutdown() {
        for (IndexLifecycleManager delegate : this.delegates) {
            delegate.shutdown();
        }
    }

    public long activate(Context context) {
        return this.activate(context, true);
    }

    public long activate(Context context, boolean reindex) {
        long result = 0L;
        for (IndexLifecycleManager delegate : this.delegates) {
            result += delegate.activate(context, reindex);
        }
        return result;
    }

    public void deactivate() {
        for (IndexLifecycleManager delegate : this.delegates) {
            delegate.deactivate();
        }
    }

    public boolean isIndexingEnabled() {
        return this.delegates[0].isIndexAvailable();
    }

    public boolean isIndexAvailable() {
        return this.delegates[0].isIndexAvailable();
    }

    public boolean isIndexConsistent() {
        for (IndexLifecycleManager delegate : this.delegates) {
            if (delegate.isIndexConsistent()) continue;
            return false;
        }
        return true;
    }

    public Collection<String> getAllIndexPaths() {
        ArrayList result = Lists.newArrayListWithCapacity((int)this.delegates.length);
        for (IndexLifecycleManager delegate : this.delegates) {
            result.addAll(delegate.getAllIndexPaths());
        }
        return Collections.unmodifiableCollection(result);
    }

    public int size() {
        int result = 0;
        for (IndexLifecycleManager delegate : this.delegates) {
            result += delegate.size();
        }
        return result;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }
}

