/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util;

import com.atlassian.jira.cluster.ClusterSafe;
import com.atlassian.jira.config.properties.JiraSystemProperties;
import com.atlassian.jira.util.dbc.Assertions;
import java.io.File;

public class TempDirectoryUtil {
    private static final Object TMP_FILE_LOCK = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ClusterSafe(value="Local")
    public static File createTempDirectory(String prefix) {
        Assertions.notNull((String)"prefix", (Object)prefix);
        Object object = TMP_FILE_LOCK;
        synchronized (object) {
            File f;
            long counter = System.currentTimeMillis();
            String systemTempDir = TempDirectoryUtil.getSystemTempDir();
            do {
                f = new File(systemTempDir, prefix + counter);
                ++counter;
            } while (!f.mkdir());
            f.deleteOnExit();
            return f;
        }
    }

    public static String getSystemTempDir() {
        return JiraSystemProperties.getInstance().getProperty("java.io.tmpdir");
    }
}

