/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user.util;

import com.atlassian.application.api.ApplicationKey;
import com.atlassian.jira.application.ApplicationKeys;
import com.atlassian.jira.application.ApplicationRole;
import com.atlassian.jira.application.ApplicationRoleManager;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.SortedSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class AdminAccessHelper {
    private final GlobalPermissionManager permissionManager;
    private final ApplicationRoleManager applicationRoleManager;
    private final GroupManager groupManager;

    public AdminAccessHelper(GlobalPermissionManager permissionManager, ApplicationRoleManager applicationRoleManager, GroupManager groupManager) {
        this.permissionManager = (GlobalPermissionManager)Assertions.notNull((Object)permissionManager);
        this.applicationRoleManager = (ApplicationRoleManager)Assertions.notNull((Object)applicationRoleManager);
        this.groupManager = groupManager;
    }

    public void associateAdminGroupsWithAppRole() {
        HashSet allAdminGroups = Sets.newHashSet((Iterable)this.permissionManager.getGroupsWithPermission(GlobalPermissionKey.ADMINISTER));
        allAdminGroups.addAll(this.permissionManager.getGroupsWithPermission(GlobalPermissionKey.SYSTEM_ADMIN));
        ApplicationRole adminDefaultApplicationRole = (ApplicationRole)this.applicationRoleManager.getRole(this.determineDefaultApplication()).get();
        HashSet existingGroups = Sets.newHashSet((Iterable)adminDefaultApplicationRole.getGroups());
        existingGroups.addAll(allAdminGroups);
        HashSet existingDefaultGroups = Sets.newHashSet((Iterable)adminDefaultApplicationRole.getDefaultGroups());
        existingDefaultGroups.removeAll(allAdminGroups);
        ApplicationRole modifiedRole = adminDefaultApplicationRole.withGroups((Iterable)existingGroups, (Iterable)existingDefaultGroups);
        this.applicationRoleManager.setRole(modifiedRole);
    }

    public boolean areThereAdminsWithoutAccess() {
        if (!this.applicationRoleManager.rolesEnabled()) {
            return false;
        }
        return Stream.concat(this.permissionManager.getGroupsWithPermission(GlobalPermissionKey.ADMINISTER).stream(), this.permissionManager.getGroupsWithPermission(GlobalPermissionKey.SYSTEM_ADMIN).stream()).map(arg_0 -> ((GroupManager)this.groupManager).getUsersInGroup(arg_0)).flatMap(Collection::stream).anyMatch(admin -> !this.applicationRoleManager.hasAnyRole(admin));
    }

    private ApplicationKey determineDefaultApplication() {
        SortedSet licensedAppKeys = this.applicationRoleManager.getRoles().stream().map(ApplicationRole::getKey).collect(Collectors.toCollection(() -> Sets.newTreeSet((Comparator)Ordering.natural().onResultOf(ApplicationKey::value))));
        ApplicationKey appForAdmin = licensedAppKeys.contains(ApplicationKeys.CORE) ? ApplicationKeys.CORE : (licensedAppKeys.contains(ApplicationKeys.SOFTWARE) ? ApplicationKeys.SOFTWARE : (ApplicationKey)licensedAppKeys.first());
        return appForAdmin;
    }
}

