/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user.profile;

import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.template.TemplateSources;
import com.atlassian.jira.template.VelocityTemplatingEngine;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.profile.UserProfileFragment;
import com.atlassian.jira.util.VelocityParamFactory;
import java.util.Map;
import org.apache.velocity.exception.VelocityException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractUserProfileFragment
implements UserProfileFragment {
    private static final Logger log = LoggerFactory.getLogger(AbstractUserProfileFragment.class);
    public static final String PROFILE_USER = "profileUser";
    public static final String CURRENT_USER = "currentUser";
    protected final JiraAuthenticationContext jiraAuthenticationContext;
    private final VelocityTemplatingEngine templatingEngine;
    private final VelocityParamFactory velocityParamFactory;

    public AbstractUserProfileFragment(JiraAuthenticationContext jiraAuthenticationContext, VelocityTemplatingEngine templatingEngine, VelocityParamFactory velocityParamFactory) {
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.templatingEngine = templatingEngine;
        this.velocityParamFactory = velocityParamFactory;
    }

    @Override
    public boolean showFragment(ApplicationUser profileUser, ApplicationUser currentUser) {
        return true;
    }

    @Override
    public String getFragmentHtml(ApplicationUser profileUser, ApplicationUser currentUser) {
        String template = this.getId() + ".vm";
        try {
            Map<String, Object> velocityParams = this.createVelocityParams(profileUser, currentUser);
            return this.templatingEngine.render(TemplateSources.file((String)("templates/plugins/userprofile/" + template))).applying(velocityParams).asHtml();
        }
        catch (VelocityException e) {
            log.error("Error occurred while rendering velocity template for 'templates/plugins/userprofile/" + template + "'.", (Throwable)e);
            return "";
        }
    }

    protected Map<String, Object> createVelocityParams(ApplicationUser profileUser, ApplicationUser currentUser) {
        Map velocityParams = this.velocityParamFactory.getDefaultVelocityParams(this.jiraAuthenticationContext);
        velocityParams.put("fragid", this.getId());
        velocityParams.put(PROFILE_USER, profileUser);
        velocityParams.put(CURRENT_USER, currentUser);
        velocityParams.put("i18n", this.jiraAuthenticationContext.getI18nHelper());
        return velocityParams;
    }
}

