/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks.role;

import com.atlassian.application.api.ApplicationKey;
import com.atlassian.jira.upgrade.tasks.role.ApplicationRole;
import com.atlassian.jira.upgrade.tasks.role.ApplicationRoles;
import com.atlassian.jira.upgrade.tasks.role.AuditEntry;
import com.atlassian.jira.upgrade.tasks.role.Licenses;
import com.atlassian.jira.upgrade.tasks.role.MigrationLog;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import java.util.Objects;
import java.util.function.Function;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

final class MigrationState {
    private final Licenses licenses;
    private final ApplicationRoles roles;
    private final ImmutableList<Runnable> afterSaveTasks;
    private final MigrationLog log;

    MigrationState(Licenses licenses, ApplicationRoles roles, ImmutableList<Runnable> afterSaveTasks, MigrationLog log) {
        this.log = log;
        this.roles = (ApplicationRoles)Assertions.notNull((String)"roles", (Object)roles);
        this.licenses = (Licenses)Assertions.notNull((String)"licenses", (Object)licenses);
        this.afterSaveTasks = (ImmutableList)Assertions.notNull((String)"afterSaveTasks", afterSaveTasks);
    }

    MigrationState log(AuditEntry event) {
        return new MigrationState(this.licenses, this.roles, this.afterSaveTasks, this.log.log(event));
    }

    ApplicationRoles applicationRoles() {
        return this.roles;
    }

    Licenses licenses() {
        return this.licenses;
    }

    public ImmutableList<Runnable> afterSaveTasks() {
        return this.afterSaveTasks;
    }

    public MigrationLog log() {
        return this.log;
    }

    MigrationState changeLicenses(Function<Licenses, Licenses> action) {
        Assertions.notNull((String)"action", action);
        return new MigrationState(action.apply(this.licenses), this.roles, this.afterSaveTasks, this.log);
    }

    MigrationState withAfterSaveTask(Runnable afterSaveTask) {
        Assertions.notNull((String)"afterSaveTask", (Object)afterSaveTask);
        return new MigrationState(this.licenses, this.roles, (ImmutableList<Runnable>)ImmutableList.builder().addAll(this.afterSaveTasks).add((Object)afterSaveTask).build(), this.log);
    }

    MigrationState changeApplicationRole(ApplicationKey key, Function<ApplicationRole, ApplicationRole> action) {
        Assertions.notNull((String)"action", action);
        Assertions.notNull((String)"key", (Object)key);
        Supplier supplier = () -> ApplicationRole.forKey(key);
        ApplicationRole orElse = (ApplicationRole)this.roles.get(key).getOrElse(supplier);
        ApplicationRole roleWithLog = action.apply(orElse);
        return new MigrationState(this.licenses, this.roles.put(roleWithLog), this.afterSaveTasks, this.log);
    }

    MigrationState changeEachRole(Function<ApplicationRole, ApplicationRole> action) {
        Assertions.notNull((String)"action", action);
        ApplicationRoles newRoles = this.roles;
        for (ApplicationRole role : this.roles.asMap().values()) {
            newRoles = newRoles.put(action.apply(role));
        }
        return new MigrationState(this.licenses, newRoles, this.afterSaveTasks, this.log);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MigrationState that = (MigrationState)o;
        return Objects.equals(this.licenses, that.licenses) && Objects.equals(this.roles, that.roles);
    }

    public int hashCode() {
        return Objects.hash(this.licenses, this.roles);
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("licenses", (Object)this.licenses).append("roles", (Object)this.roles).append("tasks", this.afterSaveTasks).append("logs", (Object)this.log).toString();
    }
}

