/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks.role;

import com.atlassian.fugue.Option;
import com.atlassian.jira.application.ApplicationKeys;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.license.Jira6xServiceDeskPluginEncodedLicenseSupplier;
import com.atlassian.jira.upgrade.tasks.role.Jira6xServiceDeskLicenseProvider;
import com.atlassian.jira.upgrade.tasks.role.License;
import com.atlassian.jira.upgrade.tasks.role.LicenseDao;
import com.atlassian.jira.upgrade.tasks.role.LicenseUtils;
import com.atlassian.jira.upgrade.tasks.role.MigrationFailedException;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;

public class Jira6xServiceDeskLicenseProviderImpl
implements Jira6xServiceDeskLicenseProvider {
    private final Jira6xServiceDeskPluginEncodedLicenseSupplier sdLicenseSupplier;
    private final LicenseDao licenseDao;
    private final FeatureManager featureManager;
    private final Supplier<Option<License>> cachedLicense;

    public Jira6xServiceDeskLicenseProviderImpl(Jira6xServiceDeskPluginEncodedLicenseSupplier sdLicenseSupplier, LicenseDao licenseDao, FeatureManager featureManager) {
        this.featureManager = (FeatureManager)Assertions.notNull((String)"featureManager", (Object)featureManager);
        this.sdLicenseSupplier = (Jira6xServiceDeskPluginEncodedLicenseSupplier)Assertions.notNull((String)"serviceDeskLicenseSupplier", (Object)sdLicenseSupplier);
        this.licenseDao = (LicenseDao)Assertions.notNull((String)"licenseDao", (Object)licenseDao);
        this.cachedLicense = Suppliers.memoize(this::retrieveLicense);
    }

    @Override
    public Option<License> serviceDeskLicense() {
        return (Option)this.cachedLicense.get();
    }

    private Option<License> retrieveLicense() {
        if (this.featureManager.isOnDemand()) {
            return this.sdLicenseForCloud();
        }
        return this.sdLicenseSupplier.getCurrentOrUpgrade().map(License::new).orElse(this::get6xSdLicenseFromOldStoreSafely);
    }

    private Option<License> get6xSdLicenseFromOldStoreSafely() {
        try {
            return this.licenseDao.get6xLicense().filter(LicenseUtils::isServiceDeskLicense);
        }
        catch (MigrationFailedException e) {
            return Option.none();
        }
    }

    private Option<License> sdLicenseForCloud() {
        return this.licenseDao.getLicenses().license(ApplicationKeys.SERVICE_DESK).filter(LicenseUtils::isServiceDeskLicense).orElse(this.licenseDao.get6xLicense()).filter(LicenseUtils::isServiceDeskLicense);
    }
}

