/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks.role;

import com.atlassian.jira.auditing.AssociatedItem;
import com.atlassian.jira.auditing.ChangedValue;
import com.atlassian.jira.util.dbc.Assertions;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class AuditEntry {
    private final Class<?> sourceClass;
    private final String summary;
    private final Iterable<ChangedValue> changedValues;
    private final String description;
    private final String changedObject;
    private final AssociatedItem.Type eventType;

    public AuditEntry(Class<?> sourceClass, String summary, String description) {
        this(sourceClass, summary, null, description, null);
    }

    public AuditEntry(Class<?> sourceClass, String summary, @Nullable Iterable<ChangedValue> changedValues, String description, @Nullable String changedObject) {
        this(sourceClass, summary, changedValues, description, changedObject, AssociatedItem.Type.APPLICATION_ROLE);
    }

    public AuditEntry(Class<?> sourceClass, String summary, @Nullable Iterable<ChangedValue> changedValues, String description, @Nullable String changedObject, @Nonnull AssociatedItem.Type eventType) {
        this.changedObject = changedObject;
        this.sourceClass = (Class)Assertions.notNull((String)"sourceClass", sourceClass);
        this.summary = (String)Assertions.notNull((String)"summary", (Object)summary);
        this.changedValues = changedValues;
        this.description = description;
        this.eventType = (AssociatedItem.Type)Assertions.notNull((String)"eventType", (Object)eventType);
    }

    public Class<?> getSourceClass() {
        return this.sourceClass;
    }

    public String getSummary() {
        return this.summary;
    }

    public Iterable<ChangedValue> getChangedValues() {
        return this.changedValues;
    }

    public String getDescription() {
        return this.description;
    }

    @Nullable
    public String getChangedObject() {
        return this.changedObject;
    }

    @Nonnull
    public AssociatedItem.Type getType() {
        return this.eventType;
    }

    public String toLogMessage() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getSummary()).append(" - ").append(this.getDescription());
        if (this.getChangedObject() != null) {
            sb.append(" - ");
            sb.append(this.getChangedObject());
        }
        if (this.changedValues != null) {
            sb.append(" - ");
            String changed = StreamSupport.stream(this.getChangedValues().spliterator(), false).map(changedValue -> "(" + changedValue.getName() + ": " + changedValue.getFrom() + " --> " + changedValue.getTo() + ")").collect(Collectors.joining(", "));
            sb.append(changed);
        }
        sb.append(", type: ").append(this.eventType.name());
        return sb.toString();
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuditEntry that = (AuditEntry)o;
        return Objects.equals(this.sourceClass, that.sourceClass) && Objects.equals(this.summary, that.summary) && Objects.equals(this.changedValues, that.changedValues) && Objects.equals(this.description, that.description) && Objects.equals(this.changedObject, that.changedObject) && Objects.equals(this.eventType, that.eventType);
    }

    public int hashCode() {
        return Objects.hash(this.sourceClass, this.summary, this.changedValues, this.description, this.changedObject, this.eventType);
    }

    public String toString() {
        return "AuditEntry{sourceClass=" + this.sourceClass + ", summary='" + this.summary + '\'' + ", changedValues=" + this.changedValues + ", description='" + this.description + '\'' + ", changedObject='" + this.changedObject + '\'' + ", license=" + this.eventType + '}';
    }
}

