/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks;

import com.atlassian.jira.upgrade.LegacyImmediateUpgradeTask;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import javax.annotation.Nullable;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.model.ModelEntity;

public class UpgradeTask_Build6327
extends LegacyImmediateUpgradeTask {
    private static String ENTITY_NAME = "AuditChangedValue";

    @Override
    public String getBuildNumber() {
        return "6327";
    }

    @Override
    public String getShortDescription() {
        return "Change AuditChangedValue deltaTo and deltaFrom fields to CLOB on Oracle";
    }

    @Override
    public void doUpgrade(boolean setupMode) throws Exception {
        if (!this.isORACLE()) {
            return;
        }
        this.convertToClob("deltaFrom");
        this.convertToClob("deltaTo");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void convertToClob(String fieldName) throws GenericEntityException, SQLException {
        ModelEntity auditLogTable = UpgradeTask_Build6327.getOfBizDelegator().getModelReader().getModelEntity(ENTITY_NAME);
        String searchFieldColumn = auditLogTable.getField(fieldName).getColName();
        String tableName = this.convertToSchemaTableName(auditLogTable.getPlainTableName());
        try (Connection connection = this.getDatabaseConnection();){
            Statement statement = connection.createStatement();
            statement.execute(String.format("ALTER TABLE %s ADD (tmp_sf CLOB)", tableName));
            statement.execute(String.format("UPDATE %s SET tmp_sf = %s", tableName, searchFieldColumn));
            statement.execute(String.format("ALTER TABLE %s DROP COLUMN %s", tableName, searchFieldColumn));
            statement.execute(String.format("ALTER TABLE %s RENAME COLUMN tmp_sf TO %s", tableName, searchFieldColumn));
        }
    }

    @Override
    @Nullable
    public String dependsUpon() {
        return "6326";
    }
}

