/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks;

import com.atlassian.jira.config.properties.PropertiesManager;
import com.atlassian.jira.upgrade.LegacyImmediateUpgradeTask;
import com.opensymphony.module.propertyset.PropertySet;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.ofbiz.core.entity.GenericValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpgradeTask_Build605
extends LegacyImmediateUpgradeTask {
    private static final Logger log = LoggerFactory.getLogger(UpgradeTask_Build605.class);
    static final String JIRA_OPTION_CACHE_PROJECTS = "jira.option.cache.projects";
    static final String JIRA_OPTION_CACHE_PERMISSIONS = "jira.option.cache.permissions";
    static final String JIRA_OPTION_CACHE_ISSUES = "jira.option.cache.issues";
    public static final String ISSUE_CACHE_LISTENER_CLASS = "com.atlassian.jira.event.listeners.cache.IssueCacheListener";
    private final PropertiesManager propertiesManager;

    public UpgradeTask_Build605(PropertiesManager propertiesManager) {
        this.propertiesManager = propertiesManager;
    }

    @Override
    public void doUpgrade(boolean setupMode) {
        List listenerConfigs = UpgradeTask_Build605.getOfBizDelegator().findAll("ListenerConfig");
        ArrayList<GenericValue> toRemove = new ArrayList<GenericValue>();
        for (GenericValue listenerConfig : listenerConfigs) {
            if (!listenerConfig.getString("clazz").equals(ISSUE_CACHE_LISTENER_CLASS)) continue;
            toRemove.add(listenerConfig);
        }
        UpgradeTask_Build605.getOfBizDelegator().removeAll(toRemove);
        this.removeOption(JIRA_OPTION_CACHE_ISSUES);
        this.removeOption(JIRA_OPTION_CACHE_PERMISSIONS);
        this.removeOption(JIRA_OPTION_CACHE_PROJECTS);
        log.debug("Removed JIRA issue cache configuration and listener");
    }

    private void removeOption(String key) {
        PropertySet ps = this.propertiesManager.getPropertySet();
        if (ps.exists(key)) {
            ps.remove(key);
        }
    }

    @Override
    public String getBuildNumber() {
        return "605";
    }

    @Override
    public String getShortDescription() {
        return "Cleans up left over configuration from JIRA issues cache";
    }

    @Override
    @Nullable
    public String dependsUpon() {
        return "603";
    }
}

