/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade;

import com.atlassian.fugue.Option;
import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.bc.license.JiraLicenseService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.config.util.IndexingConfiguration;
import com.atlassian.jira.event.JiraListener;
import com.atlassian.jira.event.ListenerManager;
import com.atlassian.jira.event.listeners.history.IssueAssignHistoryListener;
import com.atlassian.jira.event.listeners.mail.MailListener;
import com.atlassian.jira.event.listeners.search.IssueIndexListener;
import com.atlassian.jira.issue.attachment.AttachmentStore;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.service.JiraServiceContainer;
import com.atlassian.jira.service.ServiceManager;
import com.atlassian.jira.startup.JiraStartupLogger;
import com.atlassian.jira.task.TaskManager;
import com.atlassian.jira.upgrade.ConsistencyChecker;
import com.atlassian.jira.util.BuildUtilsInfo;
import com.atlassian.jira.util.CompositeShutdown;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.JiraUtils;
import com.atlassian.jira.util.LuceneDirectoryUtils;
import com.atlassian.jira.util.Shutdown;
import com.atlassian.jira.util.collect.CollectionBuilder;
import com.atlassian.jira.util.index.IndexLifecycleManager;
import com.atlassian.jira.util.johnson.JohnsonProvider;
import com.atlassian.jira.util.system.check.PluginVersionCheck;
import com.atlassian.jira.util.system.check.SystemEnvironmentChecklist;
import com.atlassian.jira.web.ServletContextProvider;
import com.atlassian.johnson.JohnsonEventContainer;
import com.atlassian.johnson.event.Event;
import com.atlassian.johnson.event.EventLevel;
import com.atlassian.johnson.event.EventType;
import com.atlassian.plugin.PluginAccessor;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletContext;
import org.apache.log4j.Level;
import org.apache.lucene.search.BooleanQuery;
import org.ofbiz.core.entity.GenericValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsistencyCheckImpl
implements ConsistencyChecker {
    static final String INIT_KEY = ConsistencyCheckImpl.class.getName() + ":initialized";
    private static final Logger log = LoggerFactory.getLogger(ConsistencyCheckImpl.class);
    private final JiraStartupLogger startupLog = new JiraStartupLogger();
    private JohnsonProvider johnsonProvider;

    public ConsistencyCheckImpl(JohnsonProvider johnsonProvider) {
        this.johnsonProvider = johnsonProvider;
    }

    @Override
    public void destroy(ServletContext context) {
        Boolean initialized = (Boolean)context.getAttribute(INIT_KEY);
        if (initialized == null || !initialized.booleanValue()) {
            return;
        }
        Collection<JiraServiceContainer> services = this.getServices();
        Iterator<JiraServiceContainer> iterator = services.iterator();
        while (iterator.hasNext()) {
            JiraServiceContainer element;
            JiraServiceContainer service = element = iterator.next();
            try {
                service.destroy();
            }
            catch (RuntimeException e) {
                log.error("Failed to destroy service '" + (service != null && service.getName() != null ? service.getName() : "Unknown") + "' " + e.getMessage(), (Throwable)e);
            }
        }
        try {
            this.getShutdown().shutdown();
        }
        catch (RuntimeException e) {
            log.error("Failed to run shutdown hooks.", (Throwable)e);
        }
    }

    private Shutdown getShutdown() {
        return new CompositeShutdown(this.getIndexManagerShutdown(), () -> this.getTaskManager().shutdownAndWait(0L));
    }

    Shutdown getComponentManager() {
        return ComponentManager.getInstance();
    }

    IndexLifecycleManager getIndexManager() {
        return (IndexLifecycleManager)ComponentAccessor.getComponent(IndexLifecycleManager.class);
    }

    LuceneDirectoryUtils getLuceneDirectoryUtils() {
        return (LuceneDirectoryUtils)ComponentAccessor.getComponent(LuceneDirectoryUtils.class);
    }

    private Shutdown getIndexManagerShutdown() {
        try {
            return this.getIndexManager();
        }
        catch (RuntimeException e) {
            log.error("Failed to get IndexManager, cannot shut it down cleanly...", (Throwable)e);
            return new Shutdown(){

                public void shutdown() {
                }

                public String toString() {
                    return "NullShutdownForIndexManager";
                }
            };
        }
    }

    TaskManager getTaskManager() {
        return (TaskManager)ComponentAccessor.getComponent(TaskManager.class);
    }

    protected Collection<JiraServiceContainer> getServices() {
        return ((ServiceManager)ComponentAccessor.getComponent(ServiceManager.class)).getServices();
    }

    @Override
    public void initialise(ServletContext servletContext) {
        this.setStartupTime(servletContext);
        this.checkConsistency(servletContext);
        this.checkAndInitLucene();
        new PluginVersionCheck((PluginAccessor)ComponentAccessor.getComponentOfType(PluginAccessor.class), (BuildUtilsInfo)ComponentAccessor.getComponentOfType(BuildUtilsInfo.class), this.johnsonProvider).check(servletContext);
        this.printJIRAStartupMessage();
        ServletContextProvider.getServletContext().setAttribute(INIT_KEY, (Object)Boolean.TRUE);
    }

    private void printJIRAStartupMessage() {
        JohnsonEventContainer eventCont = this.johnsonProvider.getContainer();
        if (!eventCont.hasEvents()) {
            this.startupLog.printStartedMessage();
        }
        this.checkSystemEnvironment();
    }

    public void checkConsistency(ServletContext context) {
        try {
            log.info("Checking JIRA consistency");
            boolean connection = this.checkConnection();
            if (connection) {
                this.checkDataConsistency(context);
            }
        }
        catch (Exception dataConsistencyCheckException) {
            log.error("An error occurred during the consistency check", (Throwable)dataConsistencyCheckException);
        }
    }

    @Override
    public void checkDataConsistency(ServletContext context) throws Exception {
        this.checkMailListenerAndService();
        this.checkIssueAssignHistoryListener();
        this.checkAttachmentStorage();
        this.checkIndexingSetup();
        this.checkLanguageExists();
        this.checkAndInitSID();
    }

    private void checkSystemEnvironment() {
        List<String> messages = SystemEnvironmentChecklist.getEnglishWarningMessages();
        for (String message : messages) {
            this.startupLog.printMessage(message, Level.WARN);
        }
    }

    private void checkAndInitLucene() {
        ApplicationProperties ap = ComponentAccessor.getApplicationProperties();
        IndexLifecycleManager indexManager = this.getIndexManager();
        Collection<String> existingLockFilepaths = this.getLuceneDirectoryUtils().getStaleLockPaths(indexManager.getAllIndexPaths());
        if (existingLockFilepaths != null && !existingLockFilepaths.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (String filePath : existingLockFilepaths) {
                if (filePath == null) continue;
                sb.append(filePath).append(' ');
            }
            if (sb.length() > 1) {
                sb.deleteCharAt(sb.length() - 1);
            }
            List messages = CollectionBuilder.newBuilder((Object[])new String[]{"Index lock file(s) found. This occurs either because JIRA was not cleanly shutdown", "or because there is another instance of this JIRA installation currently running.", "Please ensure that no other instance of this JIRA installation is running", "and then remove the following lock file(s) and restart JIRA:", "", sb.toString(), "", "Once restarted you will need to reindex your data to ensure that indexes are up to date.", "", "Do NOT delete the lock file(s) if there is another JIRA running with the same index directory", "instead cleanly shutdown the other instance."}).asList();
            this.startupLog.printMessage(messages, Level.ERROR);
            Event event = new Event(EventType.get((String)"index-lock-already-exists"), "An existing index lock was found.", EventLevel.get((String)"error"));
            event.addAttribute((Object)"lockfiles", (Object)sb.toString());
            this.addJohnsonEvent(event);
        }
        int maxClausesCount = 65000;
        try {
            maxClausesCount = Integer.parseInt(ap.getDefaultBackedString("jira.search.maxclauses"));
        }
        catch (NumberFormatException e) {
            log.warn("Could not read the property 'jira.search.maxclauses' for the number of maximum search clauses. Using default " + maxClausesCount);
        }
        BooleanQuery.setMaxClauseCount((int)maxClausesCount);
    }

    private void checkLanguageExists() {
        ApplicationProperties ap = ComponentAccessor.getApplicationProperties();
        if (ap.getString("jira.i18n.language.index") == null) {
            log.info("Input Language has not been set.  Setting to 'English - Moderate Stemming'");
            ap.setString("jira.i18n.language.index", "english-moderate-stemming");
        }
    }

    private boolean checkConnection() {
        boolean worked = true;
        try {
            OfBizDelegator ofBizDelegator = ComponentAccessor.getOfBizDelegator();
            if (ofBizDelegator == null) {
                log.error("Could not get OfBizDelegator");
                worked = false;
            } else {
                try {
                    ofBizDelegator.findAll("Project");
                }
                catch (RuntimeException e) {
                    log.error("Could not connect to database. Check your entityengine.xml settings: " + e, (Throwable)e);
                    worked = false;
                    Event event = new Event(EventType.get((String)"database"), "Could not connect to database", e.getMessage(), EventLevel.get((String)"error"));
                    this.addJohnsonEvent(event);
                }
            }
        }
        catch (Exception databaseConnectionTestException) {
            log.error("Could not check database connection. Check your entityengine.xml settings.", (Throwable)databaseConnectionTestException);
            worked = false;
            Event event = new Event(EventType.get((String)"database"), "Could not connect to database.", databaseConnectionTestException.getMessage(), EventLevel.get((String)"error"));
            this.addJohnsonEvent(event);
        }
        return worked;
    }

    private void addJohnsonEvent(Event event) {
        JohnsonEventContainer eventCont = this.johnsonProvider.getContainer();
        eventCont.addEvent(event);
    }

    private void checkMailListenerAndService() throws Exception {
        this.ensureSingleListener(MailListener.class, "Mail Listener");
        this.ensureSingleService("com.atlassian.jira.service.services.mail.MailQueueService", "Mail Queue Service");
    }

    private void checkIssueAssignHistoryListener() throws Exception {
        this.ensureSingleListener(IssueAssignHistoryListener.class, "Issue Assignment Listener");
    }

    private void checkAttachmentStorage() throws Exception {
        Option result;
        ApplicationProperties ap = ComponentAccessor.getApplicationProperties();
        if (ap.getOption("jira.option.allowattachments") && (result = ((AttachmentStore)ComponentAccessor.getComponent(AttachmentStore.class)).errors()).isDefined()) {
            log.error("Attachments are turned on, " + ((ErrorCollection)result.get()).toString() + " - disabling attachments");
            ap.setOption("jira.option.allowattachments", false);
        }
    }

    private void checkIndexingSetup() throws Exception {
        String indexPath = ComponentAccessor.getIndexPathManager().getIndexRootPath();
        if (!this.directoryExists(indexPath)) {
            log.error("Indexing is turned on, but index path [" + indexPath + "] invalid - disabling indexing");
            this.removeListeners(IssueIndexListener.class);
            ((IndexingConfiguration)ComponentAccessor.getComponent(IndexingConfiguration.class)).disableIndex();
            if (JiraUtils.isSetup()) {
                Event event = new Event(EventType.get((String)"reindex"), "The JIRA search index is missing.", EventLevel.get((String)"error"));
                this.addJohnsonEvent(event);
            }
            return;
        }
        this.ensureSingleListener(IssueIndexListener.class, "Issue Index Listener");
    }

    private boolean directoryExists(String path) {
        File dir;
        return path != null && (dir = new File(path)).exists() && dir.isDirectory();
    }

    private void ensureSingleListener(Class<? extends JiraListener> clazz, String name) throws Exception {
        String classname = clazz.getName();
        List listenerConfigs = ComponentAccessor.getOfBizDelegator().findAll("ListenerConfig");
        boolean foundOne = false;
        ArrayList toRemove = Lists.newArrayListWithCapacity((int)listenerConfigs.size());
        for (Object element : listenerConfigs) {
            GenericValue listenerConfig = (GenericValue)element;
            if (!listenerConfig.getString("clazz").equals(classname)) continue;
            if (foundOne) {
                toRemove.add(listenerConfig);
                continue;
            }
            foundOne = true;
        }
        if (!foundOne) {
            if ("true".equals(ComponentAccessor.getApplicationProperties().getString("jira.setup"))) {
                log.error("Could not find " + name + ", adding.");
            } else {
                log.info("Could not find " + name + ", adding.");
            }
            ListenerManager listenerManager = (ListenerManager)ComponentAccessor.getComponent(ListenerManager.class);
            try {
                listenerManager.createListener(name, clazz);
            }
            catch (Exception e) {
                log.error("Error adding listener: " + e, (Throwable)e);
            }
        } else if (toRemove.size() > 0) {
            log.debug("Removing " + toRemove.size() + " extra listeners with class " + classname);
            ComponentAccessor.getOfBizDelegator().removeAll((List)toRemove);
            ComponentAccessor.getListenerManager().refresh();
        }
    }

    private void ensureSingleService(String clazz, String name) throws Exception {
        Collection<JiraServiceContainer> serviceConfigs = this.getServices();
        boolean foundOne = false;
        ArrayList<JiraServiceContainer> toRemove = new ArrayList<JiraServiceContainer>();
        for (JiraServiceContainer jiraServiceContainer : serviceConfigs) {
            if (!jiraServiceContainer.getServiceClass().equals(clazz)) continue;
            if (foundOne) {
                toRemove.add(jiraServiceContainer);
                continue;
            }
            foundOne = true;
        }
        if (!foundOne) {
            if ("true".equals(ComponentAccessor.getApplicationProperties().getString("jira.setup"))) {
                log.error("Could not find " + name + ", adding.");
            } else {
                log.info("Could not find " + name + ", adding.");
            }
            try {
                ComponentAccessor.getServiceManager().addService(name, clazz, "0 * * * * ?");
            }
            catch (Exception e) {
                log.error("Error adding service: " + e, (Throwable)e);
            }
        } else if (!toRemove.isEmpty()) {
            log.debug("Removing " + toRemove.size() + " extra services with class " + clazz);
            for (Object object : toRemove) {
                JiraServiceContainer serviceContainer = (JiraServiceContainer)object;
                ComponentAccessor.getServiceManager().removeService(serviceContainer.getId());
            }
        }
    }

    private void setStartupTime(ServletContext context) {
        if (context != null) {
            context.setAttribute("jira_startup_time", (Object)System.currentTimeMillis());
        }
    }

    private void removeListeners(Class<? extends JiraListener> clazz) {
        ((ListenerManager)ComponentAccessor.getComponent(ListenerManager.class)).deleteListener(clazz);
    }

    private void checkAndInitSID() {
        String serverId = ((JiraLicenseService)ComponentAccessor.getComponentOfType(JiraLicenseService.class)).getServerId();
        if (log.isInfoEnabled()) {
            log.info("The Server ID for this JIRA instance is: [" + serverId + "]");
        }
    }
}

