/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.studio.startup;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ClassMaker<T> {
    private static final Logger log = LoggerFactory.getLogger(ClassMaker.class);
    private final Class<T> instanceType;
    private final ClassLoader loader;

    ClassMaker(Class<T> superClass, ClassLoader loader) {
        this.instanceType = superClass;
        this.loader = loader;
    }

    T createInstance(String name) {
        try {
            Class<?> loadedClass = this.loader.loadClass(name);
            if (this.instanceType.isAssignableFrom(loadedClass)) {
                Class<?> c = loadedClass;
                Constructor<?> constructor = c.getConstructor(new Class[0]);
                return (T)constructor.newInstance(new Object[0]);
            }
            log.info(String.format("Unable to create an instance of '%s' as it is not a subclass of '%s'.", loadedClass.getName(), this.instanceType.getName()));
        }
        catch (ClassNotFoundException e) {
            log.info(String.format("Unable to find class '%s'.", name), (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            log.info(String.format("Unable to find no-arg constructor for class '%s'.", name), (Throwable)e);
        }
        catch (InvocationTargetException e) {
            log.info(String.format("Exception thrown while creating '%s'.", name), (Throwable)e);
        }
        catch (InstantiationException e) {
            log.info(String.format("Exception thrown while creating '%s'.", name), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            log.info(String.format("Exception thrown while creating '%s'.", name), (Throwable)e);
        }
        return null;
    }
}

