/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.startup;

import com.atlassian.jira.startup.StartupCheck;
import com.atlassian.jira.web.ServletContextProvider;
import com.opensymphony.util.TextUtils;
import javax.servlet.ServletContext;

public class JiraWebappStartupCheck
implements StartupCheck {
    private static final String NAME = "JIRA Webapp Configuration Check";
    private static final String FAULT_DESCRIPTION = "Running JIRA from a packed WAR is not supported. Configure your Servlet container to unpack the WAR before running it.";

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public boolean isOk() {
        ServletContext servletContext = ServletContextProvider.getServletContext();
        String realPath = servletContext.getRealPath("/");
        return realPath != null;
    }

    @Override
    public String getFaultDescription() {
        return FAULT_DESCRIPTION;
    }

    @Override
    public String getHTMLFaultDescription() {
        return TextUtils.htmlEncode((String)this.getFaultDescription());
    }

    @Override
    public void stop() {
    }
}

