/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.sharing.index;

import com.atlassian.jira.issue.statistics.util.FieldHitCollector;
import com.atlassian.jira.sharing.SharedEntity;
import com.atlassian.jira.sharing.SharedEntityAccessor;
import com.atlassian.jira.sharing.SharedEntityColumn;
import com.atlassian.jira.sharing.SharedEntityColumnDefinition;
import com.atlassian.jira.sharing.index.IndexSearcherFactory;
import com.atlassian.jira.sharing.index.QueryFactory;
import com.atlassian.jira.sharing.search.SharedEntitySearchParameters;
import com.atlassian.jira.sharing.search.SharedEntitySearchResult;
import com.atlassian.jira.sharing.search.SharedEntitySearcher;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.Function;
import com.atlassian.jira.util.collect.CollectionUtil;
import com.atlassian.jira.util.dbc.Assertions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.search.FieldComparatorSource;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TopDocs;

public class DefaultSharedEntitySearcher<S extends SharedEntity>
implements SharedEntitySearcher<S> {
    private static final SortFieldFactory SORT_FACTORY = new SortFieldFactory();
    private final IndexSearcherFactory searcherFactory;
    private final SharedEntityAccessor<S> accessor;
    private final QueryFactory queryFactory;

    public DefaultSharedEntitySearcher(IndexSearcherFactory searcherFactory, SharedEntityAccessor<S> accessor, QueryFactory queryFactory) {
        this.searcherFactory = (IndexSearcherFactory)Assertions.notNull((String)"searcherFactory", (Object)searcherFactory);
        this.accessor = (SharedEntityAccessor)Assertions.notNull((String)"accessor", accessor);
        this.queryFactory = (QueryFactory)Assertions.notNull((String)"queryFactory", (Object)queryFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SharedEntitySearchResult<S> search(SharedEntitySearchParameters searchParameters, ApplicationUser user, final int pageOffset, final int pageWidth) {
        this.checkParametersForSanity(searchParameters, pageOffset, pageWidth);
        final Query query = this.queryFactory.create(searchParameters, user);
        final Sort sort = new Sort((SortField[])new SharedEntitySortField[]{SORT_FACTORY.getSortField(searchParameters.getSortColumn(), !searchParameters.isAscendingSort()), SharedEntitySortField.NAME, SharedEntitySortField.ID});
        final IndexSearcher searcher = this.searcherFactory.get();
        try {
            SharedEntitySearchResult sharedEntitySearchResult = new Engine(true){

                @Override
                TopDocs getHits() throws IOException {
                    return searcher.search(query, Integer.MAX_VALUE, sort);
                }

                @Override
                Page page(TopDocs source) {
                    return new Page(source, pageOffset, pageWidth, searcher);
                }
            }.search(user);
            return sharedEntitySearchResult;
        }
        finally {
            try {
                searcher.close();
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SharedEntitySearchResult<S> search(SharedEntitySearchParameters searchParameters) {
        final Query query = this.queryFactory.create((SharedEntitySearchParameters)Assertions.notNull((String)"searchParameters", (Object)searchParameters));
        final IndexSearcher searcher = this.searcherFactory.get();
        try {
            SharedEntitySearchResult sharedEntitySearchResult = new Engine(false){

                @Override
                TopDocs getHits() throws IOException {
                    return searcher.search(query, Integer.MAX_VALUE);
                }

                @Override
                Page page(TopDocs source) {
                    return new All(source, searcher);
                }
            }.search();
            return sharedEntitySearchResult;
        }
        finally {
            try {
                searcher.close();
            }
            catch (IOException iOException) {}
        }
    }

    private void checkParametersForSanity(SharedEntitySearchParameters searchParameters, int pageOffset, int pageWidth) {
        Assertions.notNull((String)"searchParameters", (Object)searchParameters);
        Assertions.not((String)"pageOffset < 0", (pageOffset < 0 ? 1 : 0) != 0);
        Assertions.not((String)"pageWidth <= 0", (pageWidth <= 0 ? 1 : 0) != 0);
        Assertions.not((String)"pageWidth of MAX_VALUE used with non zero pageOffset", (pageWidth == Integer.MAX_VALUE && pageOffset != 0 ? 1 : 0) != 0);
    }

    private static class SortFieldFactory {
        private SortFieldFactory() {
        }

        SharedEntitySortField getSortField(SharedEntityColumn column, boolean reverse) {
            SharedEntityColumnDefinition columnDefinition = SharedEntityColumnDefinition.definitionFor(column);
            if (columnDefinition.isCustomSort()) {
                return new SharedEntitySortField(columnDefinition, columnDefinition.createSortComparator(), reverse);
            }
            return new SharedEntitySortField(columnDefinition, reverse);
        }
    }

    public static final class Ids
    implements SharedEntityAccessor.RetrievalDescriptor {
        final List<Long> ids;
        final boolean preserveOrder;

        public Ids(Collection<Long> ids, boolean preserveOrder) {
            this.ids = Collections.unmodifiableList(new ArrayList<Long>(ids));
            this.preserveOrder = preserveOrder;
        }

        @Nonnull
        public List<Long> getIds() {
            return this.ids;
        }

        public boolean preserveOrder() {
            return this.preserveOrder;
        }
    }

    class All
    extends Page {
        public All(TopDocs hits, IndexSearcher searcher) {
            super(hits, 0, hits.totalHits, searcher);
        }
    }

    class Page {
        private final List<String> result;
        private final boolean hasNext;

        private Page(TopDocs hits, int pageOffset, int pageWidth, IndexSearcher searcher) {
            int startOffset = Math.min(hits.totalHits, pageOffset * pageWidth);
            int endOffset = Math.min(hits.totalHits, startOffset + pageWidth);
            FieldHitCollector collector = new FieldHitCollector(searcher, "id");
            for (int i = startOffset; i < endOffset; ++i) {
                try {
                    Document doc = searcher.doc(hits.scoreDocs[i].doc);
                    collector.collect(doc);
                    continue;
                }
                catch (CorruptIndexException e) {
                    throw new RuntimeException(e);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            this.result = collector.getValues();
            this.hasNext = hits.totalHits > endOffset;
        }

        public List<String> list() {
            return this.result;
        }

        public boolean hasNext() {
            return this.hasNext;
        }
    }

    abstract class Engine {
        private final boolean preserveSort;

        private Engine(boolean preserveSort) {
            this.preserveSort = preserveSort;
        }

        abstract TopDocs getHits() throws IOException;

        abstract Page page(TopDocs var1);

        SharedEntitySearchResult<S> search(ApplicationUser user) {
            TopDocs hits;
            try {
                hits = this.getHits();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            Page page = this.page(hits);
            Ids ids = new Ids(CollectionUtil.transform(page.list(), Transformers.STRING_TO_LONG), this.preserveSort);
            return new SharedEntitySearchResult(DefaultSharedEntitySearcher.this.accessor.get(user, (SharedEntityAccessor.RetrievalDescriptor)ids), page.hasNext(), hits.totalHits);
        }

        SharedEntitySearchResult<S> search() {
            TopDocs hits;
            try {
                hits = this.getHits();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            Page page = this.page(hits);
            Ids ids = new Ids(CollectionUtil.transform(page.list(), Transformers.STRING_TO_LONG), this.preserveSort);
            return new SharedEntitySearchResult(DefaultSharedEntitySearcher.this.accessor.get((SharedEntityAccessor.RetrievalDescriptor)ids), page.hasNext(), hits.totalHits);
        }
    }

    private static class Transformers {
        static final Function<String, Long> STRING_TO_LONG = new Function<String, Long>(){

            public Long get(String input) {
                return Long.valueOf(String.valueOf(input));
            }
        };

        private Transformers() {
        }
    }

    static final class SharedEntitySortField
    extends SortField {
        static final SharedEntitySortField NAME = new SharedEntitySortField(SharedEntityColumnDefinition.NAME, false);
        static final SharedEntitySortField ID = new SharedEntitySortField(SharedEntityColumnDefinition.ID, false);

        SharedEntitySortField(SharedEntityColumnDefinition column, boolean reverse) {
            super(column.getSortColumn(), column.getSortType(), reverse);
        }

        SharedEntitySortField(SharedEntityColumnDefinition column, FieldComparatorSource FieldComparatorSource2, boolean reverse) {
            super(column.getSortColumn(), FieldComparatorSource2, reverse);
        }
    }
}

