/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.security;

import com.atlassian.jira.bc.security.login.LoginLoggers;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.log.Log4jKit;
import com.atlassian.jira.web.bean.I18nBean;
import com.atlassian.jira.web.util.OutlookDate;
import com.atlassian.jira.web.util.OutlookDateManager;
import com.atlassian.seraph.auth.AuthenticationContext;
import com.google.common.base.Supplier;
import java.security.Principal;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;

public class JiraAuthenticationContextImpl
implements JiraAuthenticationContext {
    private static final ThreadLocal<Map<String, Object>> REQUEST_CACHE = new ThreadLocal<Map<String, Object>>(){

        @Override
        protected Map<String, Object> initialValue() {
            return new HashMap<String, Object>();
        }
    };
    private final AuthenticationContext authenticationContext;
    private final I18nHelper.BeanFactory i18n;

    public static void clearRequestCache() {
        REQUEST_CACHE.remove();
    }

    public static Map<String, Object> getRequestCache() {
        return REQUEST_CACHE.get();
    }

    public static <T> T getRequestCache(@Nonnull String cacheKey, @Nonnull Supplier<T> cacheFactory) {
        Map<String, Object> requestCache = JiraAuthenticationContextImpl.getRequestCache();
        Object cache = requestCache.get(cacheKey);
        if (cache == null) {
            cache = cacheFactory.get();
            requestCache.put(cacheKey, cache);
        }
        return (T)cache;
    }

    public JiraAuthenticationContextImpl(AuthenticationContext authenticationContext, I18nHelper.BeanFactory i18n) {
        this.authenticationContext = authenticationContext;
        this.i18n = i18n;
    }

    public ApplicationUser getLoggedInUser() {
        Principal principal = this.authenticationContext.getUser();
        if (principal == null) {
            return null;
        }
        if (principal instanceof ApplicationUser) {
            return (ApplicationUser)principal;
        }
        return this.getUserManager().getUserByName(principal.getName());
    }

    protected UserManager getUserManager() {
        return ComponentAccessor.getUserManager();
    }

    public boolean isLoggedInUser() {
        return this.getLoggedInUser() != null;
    }

    public ApplicationUser getUser() {
        return this.getLoggedInUser();
    }

    public Locale getLocale() {
        return I18nBean.getLocaleFromUser(this.getUser());
    }

    public OutlookDate getOutlookDate() {
        return ((OutlookDateManager)ComponentAccessor.getComponent(OutlookDateManager.class)).getOutlookDate(this.getLocale());
    }

    public String getText(String key) {
        return this.getI18nHelper().getText(key);
    }

    public I18nHelper getI18nHelper() {
        return this.i18n.getInstance(this.getUser());
    }

    public I18nHelper getI18nBean() {
        return this.getI18nHelper();
    }

    public void setLoggedInUser(ApplicationUser user) {
        this.setLoggedInUserImpl(user);
    }

    public void clearLoggedInUser() {
        this.setLoggedInUserImpl(null);
    }

    private void setLoggedInUserImpl(ApplicationUser user) {
        String userName = user == null ? null : user.getName();
        Log4jKit.putUserToMDC(userName);
        if (LoginLoggers.LOGIN_SETAUTHCTX_LOG.isDebugEnabled()) {
            LoginLoggers.LOGIN_SETAUTHCTX_LOG.debug((Object)("Setting JIRA Auth Context to be  '" + (StringUtils.isBlank((String)userName) ? "anonymous" : userName) + "'"));
        }
        if (user == null) {
            this.authenticationContext.clearUser();
        } else {
            this.authenticationContext.setUser((Principal)user);
        }
    }
}

