/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.security;

import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CachedReference;
import com.atlassian.cache.Supplier;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.security.GlobalPermissionEntry;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.ofbiz.core.entity.GenericValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlobalPermissionsCache {
    private static final Logger log = LoggerFactory.getLogger(GlobalPermissionsCache.class);
    private final OfBizDelegator ofBizDelegator;
    private final CachedReference<Set<GlobalPermissionEntry>> permissions;

    GlobalPermissionsCache(OfBizDelegator ofBizDelegator, CacheManager cacheManager) {
        this.ofBizDelegator = ofBizDelegator;
        if (log.isDebugEnabled()) {
            log.debug("GlobalPermissionsCache.GlobalPermissionsCache");
        }
        this.permissions = cacheManager.getCachedReference("com.atlassian.jira.security.GlobalPermissionsCache.permissions", (Supplier)new PermissionsSupplier());
        this.permissions.reset();
    }

    public void clearCache() {
        this.permissions.reset();
    }

    public boolean hasPermission(GlobalPermissionEntry jiraPermission) {
        return ((Set)this.permissions.get()).contains(jiraPermission);
    }

    public Set<GlobalPermissionEntry> getPermissions() {
        return (Set)this.permissions.get();
    }

    public Collection<GlobalPermissionEntry> getPermissions(String permissionType) {
        Set globalPermissionEntries = (Set)this.permissions.get();
        ArrayList matchingPerms = Lists.newArrayListWithCapacity((int)globalPermissionEntries.size());
        for (GlobalPermissionEntry perm : globalPermissionEntries) {
            if (!perm.getPermissionKey().equals(permissionType)) continue;
            matchingPerms.add(perm);
        }
        return matchingPerms;
    }

    private class PermissionsSupplier
    implements Supplier<Set<GlobalPermissionEntry>> {
        private PermissionsSupplier() {
        }

        public Set<GlobalPermissionEntry> get() {
            HashSet<GlobalPermissionEntry> permissions = new HashSet<GlobalPermissionEntry>();
            List allPermissions = GlobalPermissionsCache.this.ofBizDelegator.findAll("GlobalPermissionEntry");
            for (GenericValue permissionGV : allPermissions) {
                GlobalPermissionEntry permEntry = new GlobalPermissionEntry(permissionGV);
                boolean added = permissions.add(permEntry);
                if (added) continue;
                log.warn("Could not add permission " + permEntry + " - it already existed?");
            }
            return ImmutableSet.copyOf(permissions);
        }
    }
}

