/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.scheduler;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.scheduler.JiraQuartz1SchedulerConfiguration;
import com.atlassian.jira.scheduler.JiraQuartz1SchedulerService;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.core.DelegatingSchedulerService;
import com.atlassian.scheduler.core.LifecycleAwareSchedulerService;
import com.atlassian.scheduler.core.RunningJob;
import com.atlassian.scheduler.core.impl.NullRunDetailsDao;
import com.atlassian.scheduler.core.spi.RunDetailsDao;
import com.atlassian.util.concurrent.LazyReference;
import com.google.common.annotations.VisibleForTesting;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.ofbiz.core.entity.DelegatorInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
public class Quartz1BridgingSchedulerService
extends DelegatingSchedulerService
implements LifecycleAwareSchedulerService {
    private static final Logger LOG = LoggerFactory.getLogger(Quartz1BridgingSchedulerService.class);
    private final LifecycleAwareSchedulerService delegate;
    private final LazyReference<LifecycleAwareSchedulerService> quartzRef;

    public Quartz1BridgingSchedulerService(LifecycleAwareSchedulerService delegate, final ApplicationProperties applicationProperties, final DelegatorInterface delegatorInterface) {
        this(delegate, new LazyReference<LifecycleAwareSchedulerService>(){

            protected LifecycleAwareSchedulerService create() throws Exception {
                return new JiraQuartz1SchedulerService((RunDetailsDao)new NullRunDetailsDao(), new JiraQuartz1SchedulerConfiguration(applicationProperties, delegatorInterface));
            }
        });
    }

    @VisibleForTesting
    Quartz1BridgingSchedulerService(LifecycleAwareSchedulerService delegate, LazyReference<LifecycleAwareSchedulerService> quartzRef) {
        super((SchedulerService)delegate);
        this.delegate = delegate;
        this.quartzRef = quartzRef;
    }

    public void scheduleJob(JobId jobId, JobConfig jobConfig) throws SchedulerServiceException {
        super.scheduleJob(jobId, jobConfig);
        this.quartzScheduleJob(jobId, jobConfig);
    }

    @Nonnull
    public JobId scheduleJobWithGeneratedId(JobConfig jobConfig) throws SchedulerServiceException {
        JobId jobId = super.scheduleJobWithGeneratedId(jobConfig);
        this.quartzScheduleJob(jobId, jobConfig);
        return jobId;
    }

    public void unscheduleJob(JobId jobId) {
        super.unscheduleJob(jobId);
        this.quartzUnscheduleJob(jobId);
    }

    private void quartzScheduleJob(JobId jobId, JobConfig jobConfig) {
        try {
            this.getQuartz().scheduleJob(jobId, jobConfig);
        }
        catch (Exception ex) {
            if (LOG.isDebugEnabled()) {
                LOG.warn("Unable to mirror scheduleJob(jobId={}, jobConfig={}) to Quartz tables", new Object[]{jobId, jobConfig, ex});
            }
            LOG.warn("Unable to mirror scheduleJob(jobId={}, jobConfig={}) to Quartz tables: " + ex, (Object)jobId, (Object)jobConfig);
        }
    }

    private void quartzUnscheduleJob(JobId jobId) {
        try {
            this.getQuartz().unscheduleJob(jobId);
        }
        catch (Exception ex) {
            if (LOG.isDebugEnabled()) {
                LOG.warn("Unable to mirror unscheduleJob(jobId={}) to Quartz tables", (Object)jobId, (Object)ex);
            }
            LOG.warn("Unable to mirror scheduleJob(jobId={}, jobConfig={}) to Quartz tables: " + ex, (Object)jobId);
        }
    }

    public void start() throws SchedulerServiceException {
        this.delegate.start();
    }

    public void standby() throws SchedulerServiceException {
        this.delegate.standby();
    }

    @Nonnull
    public Collection<RunningJob> getLocallyRunningJobs() {
        return this.delegate.getLocallyRunningJobs();
    }

    public boolean waitUntilIdle(long time, TimeUnit unit) throws InterruptedException {
        return this.delegate.waitUntilIdle(time, unit);
    }

    @Nonnull
    public LifecycleAwareSchedulerService.State getState() {
        return this.delegate.getState();
    }

    public void shutdown() {
        this.delegate.shutdown();
        try {
            this.getQuartz().shutdown();
        }
        catch (Exception ex) {
            LOG.debug("Scheduler shutdown threw an exception; ignoring...", (Throwable)ex);
        }
    }

    private LifecycleAwareSchedulerService getQuartz() {
        return (LifecycleAwareSchedulerService)this.quartzRef.get();
    }
}

