/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.scheduler;

import com.atlassian.jira.entity.Delete;
import com.atlassian.jira.entity.Entity;
import com.atlassian.jira.entity.EntityEngine;
import com.atlassian.jira.entity.EntityListConsumer;
import com.atlassian.jira.entity.Select;
import com.atlassian.jira.scheduler.OfBizRunDetails;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.core.spi.RunDetailsDao;
import com.atlassian.scheduler.status.RunDetails;
import com.atlassian.scheduler.status.RunOutcome;
import java.sql.Timestamp;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.ofbiz.core.entity.EntityCondition;
import org.ofbiz.core.entity.EntityExpr;
import org.ofbiz.core.entity.EntityOperator;
import org.ofbiz.core.entity.GenericValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OfBizRunDetailsDao
implements RunDetailsDao {
    private static final Logger LOG = LoggerFactory.getLogger(OfBizRunDetailsDao.class);
    private static final String START_TIME_DESC = "startTime DESC";
    private static final long AUTOMATIC_PURGE_OFFSET_MILLIS = TimeUnit.DAYS.toMillis(90L);
    private final AtomicBoolean started = new AtomicBoolean();
    private final EntityEngine entityEngine;

    public OfBizRunDetailsDao(EntityEngine entityEngine) {
        this.entityEngine = entityEngine;
    }

    public void start() {
        if (this.started.compareAndSet(false, true)) {
            this.purgeHistory(new Date(System.currentTimeMillis() - AUTOMATIC_PURGE_OFFSET_MILLIS));
        } else {
            LOG.warn("start() called while already started?!", (Throwable)new IllegalStateException());
        }
    }

    public void stop() {
        this.started.set(false);
    }

    @Nullable
    public RunDetails getLastRunForJob(@Nonnull JobId jobId) {
        return (RunDetails)Select.from(Entity.RUN_DETAILS).whereEqual("jobId", jobId.toString()).orderBy(START_TIME_DESC).limit(1).runWith(this.entityEngine).singleValue();
    }

    @Nullable
    public RunDetails getLastSuccessfulRunForJob(@Nonnull JobId jobId) {
        return (RunDetails)Select.from(Entity.RUN_DETAILS).whereEqual("jobId", jobId.toString()).andEqual("runOutcome", "S").orderBy(START_TIME_DESC).limit(1).runWith(this.entityEngine).singleValue();
    }

    public void addRunDetails(@Nonnull JobId jobId, @Nonnull RunDetails runDetails) {
        if (!this.started.get()) {
            OfBizRunDetailsDao.warnNotStarted("Cannot record run details when the scheduling system is not started: jobId=" + jobId + "; runDetails=" + runDetails);
            return;
        }
        List<Long> idsToRemove = OfBizRunDetailsDao.isSuccess(runDetails) ? this.getAllIdsForJob(jobId) : this.getUnsuccessfulIdsForJob(jobId);
        this.entityEngine.createValue(Entity.RUN_DETAILS, new OfBizRunDetails(null, jobId.toString(), runDetails));
        if (!idsToRemove.isEmpty()) {
            Delete.from(Entity.RUN_DETAILS).whereCondition((EntityCondition)new EntityExpr("id", EntityOperator.IN, idsToRemove)).execute(this.entityEngine);
        }
    }

    public List<OfBizRunDetails> getAll() {
        return Select.from("RunDetails").orderBy("jobId", START_TIME_DESC).runWith(this.entityEngine).consumeWith(new MostRecentForEachJobId());
    }

    public void purgeHistory(Date before) {
        Delete.from(Entity.RUN_DETAILS).whereCondition((EntityCondition)new EntityExpr("startTime", EntityOperator.LESS_THAN, (Object)new Timestamp(before.getTime()))).execute(this.entityEngine);
    }

    private List<Long> getAllIdsForJob(JobId jobId) {
        return Select.id().from(Entity.RUN_DETAILS).whereEqual("jobId", jobId.toString()).runWith(this.entityEngine).asList();
    }

    private List<Long> getUnsuccessfulIdsForJob(JobId jobId) {
        return Select.id().from(Entity.RUN_DETAILS).whereEqual("jobId", jobId.toString()).whereCondition((EntityCondition)new EntityExpr("runOutcome", EntityOperator.NOT_EQUAL, (Object)"S")).runWith(this.entityEngine).asList();
    }

    private static boolean isSuccess(RunDetails runDetails) {
        return runDetails.getRunOutcome() == RunOutcome.SUCCESS;
    }

    private static void warnNotStarted(String message) {
        if (LOG.isDebugEnabled()) {
            LOG.warn(message, (Throwable)new IllegalStateException());
        } else {
            LOG.warn(message);
        }
    }

    static class MostRecentForEachJobId
    implements EntityListConsumer<GenericValue, List<OfBizRunDetails>> {
        private final List<OfBizRunDetails> list = new LinkedList<OfBizRunDetails>();
        private String previousJobId = null;

        MostRecentForEachJobId() {
        }

        @Override
        public void consume(GenericValue entity) {
            String jobId = entity.getString("jobId");
            if (!jobId.equals(this.previousJobId)) {
                this.list.add((OfBizRunDetails)Entity.RUN_DETAILS.build(entity));
                this.previousJobId = jobId;
            }
        }

        @Override
        public List<OfBizRunDetails> result() {
            return this.list;
        }
    }
}

