/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.scheduler;

import com.atlassian.jira.cluster.ClusterNodeProperties;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.scheduler.caesium.spi.CaesiumSchedulerConfiguration;
import java.util.TimeZone;
import javax.annotation.Nullable;

public class JiraCaesiumSchedulerConfiguration
implements CaesiumSchedulerConfiguration {
    private static final int REFRESH_INTERVAL_IN_MINUTES = 5;
    private static final int WORKER_THREAD_COUNT = 4;
    private final ApplicationProperties applicationProperties;
    private final ClusterNodeProperties clusterNodeProperties;

    public JiraCaesiumSchedulerConfiguration(ApplicationProperties applicationProperties, ClusterNodeProperties clusterNodeProperties) {
        this.applicationProperties = applicationProperties;
        this.clusterNodeProperties = clusterNodeProperties;
    }

    @Nullable
    public TimeZone getDefaultTimeZone() {
        String zoneId = this.applicationProperties.getString("jira.default.timezone");
        return zoneId != null ? TimeZone.getTimeZone(zoneId) : null;
    }

    public int refreshClusteredJobsIntervalInMinutes() {
        return this.isClustered() ? 5 : 0;
    }

    public int workerThreadCount() {
        return 4;
    }

    public boolean useQuartzJobDataMapMigration() {
        return true;
    }

    public boolean useFineGrainedSchedules() {
        return false;
    }

    private boolean isClustered() {
        return this.clusterNodeProperties.getNodeId() != null;
    }
}

