/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.propertyset;

import com.google.common.collect.ImmutableMap;
import com.opensymphony.module.propertyset.PropertyImplementationException;
import com.opensymphony.module.propertyset.ofbiz.DataPropertyHandler;
import com.opensymphony.module.propertyset.ofbiz.DatePropertyHandler;
import com.opensymphony.module.propertyset.ofbiz.DecimalPropertyHandler;
import com.opensymphony.module.propertyset.ofbiz.NumberPropertyHandler;
import com.opensymphony.module.propertyset.ofbiz.PropertyHandler;
import com.opensymphony.module.propertyset.ofbiz.StringPropertyHandler;
import com.opensymphony.util.Data;
import java.util.Date;
import java.util.Map;
import javax.annotation.Nonnull;

class OfBizPropertyTypeRegistry {
    private static final Map<Integer, TypeMapper> TYPE_MAPPER;

    OfBizPropertyTypeRegistry() {
    }

    @Nonnull
    static TypeMapper mapper(int type) {
        return OfBizPropertyTypeRegistry.mapper((Integer)type);
    }

    @Nonnull
    static TypeMapper mapper(Integer type) {
        TypeMapper mapper = TYPE_MAPPER.get(type);
        if (mapper == null) {
            throw new PropertyImplementationException("Invalid property type: " + type);
        }
        return mapper;
    }

    static {
        StringPropertyHandler stringPropertyHandler = new StringPropertyHandler();
        TypeMapper propString = new TypeMapper("OSPropertyString", (PropertyHandler)stringPropertyHandler);
        TypeMapper propText = new TypeMapper("OSPropertyText", (PropertyHandler)stringPropertyHandler);
        TypeMapper propDate = new TypeMapper("OSPropertyDate", (PropertyHandler)new SafeDatePropertyHandler());
        TypeMapper propData = new TypeMapper("OSPropertyData", (PropertyHandler)new SafeDataPropertyHandler());
        TypeMapper propNumber = new TypeMapper("OSPropertyNumber", (PropertyHandler)new NumberPropertyHandler());
        TypeMapper propDecimal = new TypeMapper("OSPropertyDecimal", (PropertyHandler)new DecimalPropertyHandler());
        TYPE_MAPPER = ImmutableMap.builder().put((Object)1, (Object)propNumber).put((Object)2, (Object)propNumber).put((Object)3, (Object)propNumber).put((Object)4, (Object)propDecimal).put((Object)5, (Object)propString).put((Object)6, (Object)propText).put((Object)7, (Object)propDate).put((Object)8, (Object)propData).put((Object)9, (Object)propData).put((Object)10, (Object)propData).put((Object)11, (Object)propData).build();
    }

    static class TypeMapper {
        private final PropertyHandler handler;
        private final String entityName;

        public TypeMapper(String entityName, PropertyHandler handler) {
            this.entityName = entityName;
            this.handler = handler;
        }

        public String getEntityName() {
            return this.entityName;
        }

        public PropertyHandler getHandler() {
            return this.handler;
        }

        public boolean hasSameEntityName(@Nonnull TypeMapper otherMapper) {
            return this.entityName.equals(otherMapper.entityName);
        }
    }

    static class SafeDataPropertyHandler
    extends DataPropertyHandler {
        SafeDataPropertyHandler() {
        }

        public Object processGet(int type, Object input) {
            Object result = super.processGet(type, input);
            return result instanceof Data ? new Data((byte[])((Data)result).getBytes().clone()) : result;
        }
    }

    static class SafeDatePropertyHandler
    extends DatePropertyHandler {
        SafeDatePropertyHandler() {
        }

        public Object processGet(int type, Object input) {
            Object result = super.processGet(type, input);
            return result instanceof Date ? ((Date)result).clone() : result;
        }
    }
}

