/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.project.util;

import com.atlassian.event.api.EventListener;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.project.util.ProjectKeyStore;
import com.atlassian.util.profiling.UtilTimerStack;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjectKeyCache {
    private static final Logger log = LoggerFactory.getLogger(ProjectKeyCache.class);
    private ProjectKeyStore delegateProjectKeyStore;
    private ImmutableMap<String, Long> projectsByKey;
    private ImmutableSetMultimap<Long, String> projectKeys;
    private ImmutableSortedMap<String, Long> projectsByKeyIgnoreCase;

    public ProjectKeyCache(ProjectKeyStore delegateProjectKeyStore) {
        this.delegateProjectKeyStore = delegateProjectKeyStore;
        this.init();
    }

    @EventListener
    public void onClearCache(ClearCacheEvent event) {
        this.init();
    }

    @Nullable
    public Long getProjectId(String key) {
        return (Long)this.projectsByKey.get((Object)key);
    }

    @Nonnull
    public Map<String, Long> getAllProjectKeys() {
        return this.projectsByKey;
    }

    @Nullable
    public Long getProjectIdByKeyIgnoreCase(String projectKey) {
        return (Long)this.projectsByKeyIgnoreCase.get((Object)projectKey);
    }

    @Nonnull
    public Set<String> getProjectKeys(Long projectId) {
        return this.projectKeys.get((Object)projectId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void init() {
        if (log.isDebugEnabled()) {
            log.debug("CachingProjectKeyStore.refresh");
        }
        long start = System.currentTimeMillis();
        UtilTimerStack.push((String)"CachingProjectKeyStore.refresh");
        try {
            LinkedHashMap tmpByKey = Maps.newLinkedHashMap();
            HashMultimap tmpProjectKeys = HashMultimap.create();
            for (Map.Entry<String, Long> projectKey : this.delegateProjectKeyStore.getAllProjectKeys().entrySet()) {
                tmpByKey.put(projectKey.getKey(), projectKey.getValue());
                tmpProjectKeys.put((Object)projectKey.getValue(), (Object)projectKey.getKey());
            }
            this.projectsByKey = ImmutableMap.copyOf((Map)tmpByKey);
            this.projectKeys = ImmutableSetMultimap.copyOf((Multimap)tmpProjectKeys);
            this.projectsByKeyIgnoreCase = ImmutableSortedMap.copyOf(this.projectsByKey, (Comparator)String.CASE_INSENSITIVE_ORDER);
        }
        finally {
            UtilTimerStack.pop((String)"CachingProjectKeyStore.refresh");
        }
        if (log.isDebugEnabled()) {
            log.debug("CachingProjectKeyStore.refresh took " + (System.currentTimeMillis() - start));
        }
    }
}

