/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.project.type;

import com.atlassian.collectors.CollectorsUtil;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.type.BrowseProjectTypeManager;
import com.atlassian.jira.project.type.ProjectType;
import com.atlassian.jira.project.type.ProjectTypeKey;
import com.atlassian.jira.project.type.ProjectTypeManager;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Stream;

public class BrowseProjectTypeManagerImpl
implements BrowseProjectTypeManager {
    private final ProjectTypeManager projectTypeManager;
    private final PermissionManager permissionManager;

    public BrowseProjectTypeManagerImpl(ProjectTypeManager projectTypeManager, PermissionManager permissionManager) {
        this.projectTypeManager = projectTypeManager;
        this.permissionManager = permissionManager;
    }

    @Override
    public List<ProjectType> getAllProjectTypes(ApplicationUser user) {
        Stream<ProjectType> installedProjectTypes = this.getProjectTypes(this.projectTypeManager.getAllProjectTypes(), user);
        Stream<ProjectType> projectTypesOfProjects = this.getProjectTypes(this.permissionManager.getProjects(ProjectPermissions.BROWSE_PROJECTS, user), user);
        return (List)Stream.concat(installedProjectTypes, projectTypesOfProjects).distinct().sorted(Comparator.comparingInt(ProjectType::getWeight)).collect(CollectorsUtil.toImmutableList());
    }

    private Stream<ProjectType> getProjectTypes(Collection<Project> projects, ApplicationUser user) {
        return this.getUniqueProjectTypes(projects.stream().map(project -> project.getProjectTypeKey()), user);
    }

    private Stream<ProjectType> getProjectTypes(List<ProjectType> projectTypes, ApplicationUser user) {
        return this.getUniqueProjectTypes(projectTypes.stream().map(projectType -> projectType.getKey()), user);
    }

    private Stream<ProjectType> getUniqueProjectTypes(Stream<ProjectTypeKey> projectTypeKeySet, ApplicationUser user) {
        return projectTypeKeySet.distinct().map(projectTypeKey -> this.getProjectTypeFor((ProjectTypeKey)projectTypeKey, user));
    }

    private ProjectType getProjectTypeFor(ProjectTypeKey key, ApplicationUser user) {
        return (ProjectType)this.projectTypeManager.getAccessibleProjectType(user, key).getOrElse(() -> this.getInaccessibleProjectType(key));
    }

    private ProjectType getInaccessibleProjectType(ProjectTypeKey projectTypeKey) {
        ProjectType inaccessibleProjectType = this.projectTypeManager.getInaccessibleProjectType();
        return new ProjectType(projectTypeKey, inaccessibleProjectType.getDescriptionI18nKey(), inaccessibleProjectType.getIcon(), inaccessibleProjectType.getColor(), inaccessibleProjectType.getWeight());
    }
}

