/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.project.template.hook;

import com.atlassian.jira.project.template.hook.WorkflowTemplate;
import com.atlassian.plugin.Plugin;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.net.URL;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.map.annotate.JacksonInject;

@JsonIgnoreProperties(ignoreUnknown=true)
public class WorkflowTemplateImpl
implements WorkflowTemplate {
    private final String key;
    private final String name;
    private final String bundlePath;
    private final URL bundleUrl;

    public WorkflowTemplateImpl(@JsonProperty(value="key") String key, @JsonProperty(value="name") String name, @JsonProperty(value="workflow-bundle") String bundlePath, @JacksonInject(value="plugin") Plugin plugin) {
        this.key = ((String)Preconditions.checkNotNull((Object)key)).toUpperCase();
        this.name = (String)Preconditions.checkNotNull((Object)name);
        this.bundlePath = (String)Preconditions.checkNotNull((Object)bundlePath);
        this.bundleUrl = this.getBundleURL(plugin);
    }

    @VisibleForTesting
    public WorkflowTemplateImpl(String key, String name, String bundlePath, URL bundleUrl) {
        this.key = key;
        this.name = name;
        this.bundlePath = bundlePath;
        this.bundleUrl = bundleUrl;
    }

    public String key() {
        return this.key;
    }

    public String name() {
        return this.name;
    }

    public String bundlePath() {
        return this.bundlePath;
    }

    public URL bundleUrl() {
        return this.bundleUrl;
    }

    private URL getBundleURL(Plugin plugin) {
        URL url = plugin.getResource(this.bundlePath());
        if (url == null) {
            throw new IllegalArgumentException("Workflow bundle for workflow '" + this.name + "'not found on path specified: " + this.bundlePath);
        }
        return url;
    }
}

